/*
 * Decompiled with CFR 0.152.
 */
package io.vertx.serviceproxy.generator.model;

import io.vertx.codegen.annotations.ProxyClose;
import io.vertx.codegen.annotations.ProxyIgnore;
import io.vertx.codegen.processor.ClassModel;
import io.vertx.codegen.processor.GenException;
import io.vertx.codegen.processor.Helper;
import io.vertx.codegen.processor.MethodInfo;
import io.vertx.codegen.processor.ParamInfo;
import io.vertx.codegen.processor.TypeParamInfo;
import io.vertx.codegen.processor.doc.Doc;
import io.vertx.codegen.processor.doc.Text;
import io.vertx.codegen.processor.type.ApiTypeInfo;
import io.vertx.codegen.processor.type.ClassKind;
import io.vertx.codegen.processor.type.ClassTypeInfo;
import io.vertx.codegen.processor.type.ParameterizedTypeInfo;
import io.vertx.codegen.processor.type.TypeInfo;
import io.vertx.codegen.processor.type.TypeMirrorFactory;
import io.vertx.serviceproxy.generator.model.ProxyMethodInfo;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.annotation.processing.ProcessingEnvironment;
import javax.lang.model.element.AnnotationMirror;
import javax.lang.model.element.Element;
import javax.lang.model.element.ExecutableElement;
import javax.lang.model.element.Modifier;
import javax.lang.model.element.TypeElement;
import javax.lang.model.util.Elements;
import javax.lang.model.util.Types;

public class ProxyModel
extends ClassModel {
    public ProxyModel(ProcessingEnvironment env, TypeMirrorFactory typeFactory, TypeElement modelElt) {
        super(env, typeFactory, modelElt);
    }

    public String getKind() {
        return "proxy";
    }

    protected void checkParamType(ExecutableElement elem, TypeInfo typeInfo, int pos, int numParams, boolean allowAnyJavaType) {
        if (typeInfo.getKind().basic || typeInfo.getKind().json) {
            return;
        }
        if (typeInfo.getKind() == ClassKind.ENUM) {
            return;
        }
        if (this.isLegalContainerParam(typeInfo)) {
            return;
        }
        if (typeInfo.isDataObjectHolder()) {
            if (typeInfo.getDataObject().isSerializable() && typeInfo.getDataObject().isDeserializable()) {
                return;
            }
            throw new GenException((Element)elem, "Data Object " + typeInfo + " must have a valid serializer and deserializer");
        }
        if (elem.getModifiers().contains((Object)Modifier.STATIC)) {
            return;
        }
        throw new GenException((Element)elem, "type " + typeInfo + " is not legal for use for a parameter in proxy");
    }

    protected void checkReturnType(ExecutableElement elem, TypeInfo type, boolean allowAnyJavaType) {
        if (elem.getModifiers().contains((Object)Modifier.STATIC)) {
            return;
        }
        if (type.isVoid() || type.getName().startsWith("io.vertx.core.Future")) {
            return;
        }
        throw new GenException((Element)elem, "Proxy methods must return Future<T>");
    }

    protected void checkMethod(MethodInfo methodInfo) {
        List methodsByName = (List)this.methodMap.get(methodInfo.getName());
        if (methodsByName != null && methodsByName.size() > 1) {
            throw new GenException((Element)this.modelElt, "Overloaded methods are not allowed in ProxyGen interfaces " + methodInfo.getName());
        }
    }

    protected MethodInfo createMethodInfo(Set<ClassTypeInfo> ownerTypes, String methodName, String comment, Doc doc, TypeInfo returnType, Text returnDescription, boolean isFluent, boolean isCacheReturn, List<ParamInfo> mParams, ExecutableElement methodElt, boolean isStatic, boolean isDefault, ArrayList<TypeParamInfo.Method> typeParams, TypeElement declaringElt, boolean methodDeprecated, Text methodDeprecatedDesc, boolean methodOverride) {
        AnnotationMirror proxyIgnoreAnnotation = Helper.resolveMethodAnnotation(ProxyIgnore.class, (Elements)this.elementUtils, (Types)this.typeUtils, (TypeElement)declaringElt, (ExecutableElement)methodElt);
        boolean isProxyIgnore = proxyIgnoreAnnotation != null;
        AnnotationMirror proxyCloseAnnotation = Helper.resolveMethodAnnotation(ProxyClose.class, (Elements)this.elementUtils, (Types)this.typeUtils, (TypeElement)declaringElt, (ExecutableElement)methodElt);
        boolean isProxyClose = proxyCloseAnnotation != null;
        ProxyMethodInfo proxyMeth = new ProxyMethodInfo(ownerTypes, methodName, returnType, returnDescription, isFluent, isCacheReturn, mParams, comment, doc, isStatic, isDefault, typeParams, isProxyIgnore, isProxyClose, methodDeprecated, methodDeprecatedDesc, methodOverride);
        if (isProxyClose) {
            TypeInfo type;
            TypeInfo arg;
            if (mParams.size() > 0) {
                throw new GenException((Element)this.modelElt, "@ProxyClose methods can't have parameters");
            }
            if (proxyMeth.getReturnType().getKind() == ClassKind.FUTURE && (arg = (TypeInfo)((ParameterizedTypeInfo)(type = proxyMeth.getReturnType())).getArgs().get(0)).getKind() != ClassKind.VOID) {
                throw new GenException((Element)this.modelElt, "@ProxyClose  must return Future<Void> instead of " + type);
            }
        }
        return proxyMeth;
    }

    private boolean isLegalAsyncResultType(TypeInfo resultType) {
        ApiTypeInfo cla;
        if (resultType.getKind().json || resultType.getKind().basic || this.isLegalContainerParam(resultType) || resultType.getKind() == ClassKind.VOID || resultType.getKind() == ClassKind.ENUM || resultType.isDataObjectHolder()) {
            return true;
        }
        return resultType.getKind() == ClassKind.API && (cla = (ApiTypeInfo)resultType).isProxyGen();
    }

    private boolean isLegalContainerParam(TypeInfo type) {
        ClassTypeInfo raw = type.getRaw();
        if (raw.getName().equals(List.class.getName()) || raw.getName().equals(Set.class.getName())) {
            TypeInfo argument = (TypeInfo)((ParameterizedTypeInfo)type).getArgs().get(0);
            if (argument.getKind().basic || argument.getKind().json || this.isValidDataObject(argument)) {
                return true;
            }
        } else if (raw.getName().equals(Map.class.getName())) {
            TypeInfo argument0 = (TypeInfo)((ParameterizedTypeInfo)type).getArgs().get(0);
            if (!argument0.getName().equals(String.class.getName())) {
                return false;
            }
            TypeInfo argument1 = (TypeInfo)((ParameterizedTypeInfo)type).getArgs().get(1);
            if (argument1.getKind().basic || argument1.getKind().json || this.isValidDataObject(argument1)) {
                return true;
            }
        }
        return false;
    }

    private boolean isValidDataObject(TypeInfo typeInfo) {
        return typeInfo.isDataObjectHolder() && typeInfo.getDataObject().isSerializable() && typeInfo.getDataObject().isDeserializable();
    }
}

