/*
 * Decompiled with CFR 0.152.
 */
package io.vertx.serviceproxy.impl;

import io.vertx.core.Future;
import io.vertx.core.Vertx;
import io.vertx.core.eventbus.Message;
import io.vertx.core.eventbus.ReplyException;
import io.vertx.core.eventbus.ReplyFailure;
import io.vertx.core.internal.ContextInternal;
import io.vertx.core.json.JsonObject;
import io.vertx.ext.auth.User;
import io.vertx.ext.auth.authorization.Authorization;
import io.vertx.ext.auth.authorization.AuthorizationContext;
import io.vertx.ext.auth.authorization.AuthorizationProvider;
import io.vertx.serviceproxy.AuthorizationInterceptor;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;

public class AuthorizationInterceptorImpl
implements AuthorizationInterceptor {
    private final AuthorizationProvider authorizationProvider;
    private Set<Authorization> authorizations;

    public AuthorizationInterceptorImpl(AuthorizationProvider authorizationProvider) {
        this.authorizationProvider = authorizationProvider;
    }

    @Override
    public AuthorizationInterceptorImpl setAuthorizations(Set<Authorization> authorizations) {
        this.authorizations = authorizations;
        return this;
    }

    @Override
    public AuthorizationInterceptorImpl addAuthorization(Authorization authorization) {
        if (this.authorizations == null) {
            this.authorizations = new HashSet<Authorization>();
        }
        this.authorizations.add(authorization);
        return this;
    }

    @Override
    public Future<Message<JsonObject>> intercept(Vertx vertx, Map<String, Object> interceptorContext, Message<JsonObject> body) {
        ContextInternal vertxContext = (ContextInternal)vertx.getOrCreateContext();
        if (!interceptorContext.containsKey("user")) {
            return vertxContext.succeededFuture(body);
        }
        if (this.authorizations == null || this.authorizations.isEmpty()) {
            return vertxContext.succeededFuture(body);
        }
        User user = (User)interceptorContext.get("user");
        return this.authorizationProvider.getAuthorizations(user).recover(err -> vertxContext.failedFuture((Throwable)new ReplyException(ReplyFailure.RECIPIENT_FAILURE, 500, err.getMessage()))).compose(voidResult -> {
            AuthorizationContext userAuthorizationContext = AuthorizationContext.create((User)user);
            for (Authorization authorization : this.authorizations) {
                if (authorization.match(userAuthorizationContext)) continue;
                return vertxContext.failedFuture((Throwable)new ReplyException(ReplyFailure.RECIPIENT_FAILURE, 403, "Forbidden"));
            }
            return vertxContext.succeededFuture((Object)body);
        });
    }
}

