/*
 * Decompiled with CFR 0.152.
 */
package io.vertx.serviceproxy.impl;

import io.vertx.core.Future;
import io.vertx.core.Vertx;
import io.vertx.core.eventbus.Message;
import io.vertx.core.eventbus.ReplyException;
import io.vertx.core.eventbus.ReplyFailure;
import io.vertx.core.internal.ContextInternal;
import io.vertx.core.json.JsonObject;
import io.vertx.ext.auth.authentication.AuthenticationProvider;
import io.vertx.ext.auth.authentication.CredentialValidationException;
import io.vertx.ext.auth.authentication.Credentials;
import io.vertx.ext.auth.authentication.TokenCredentials;
import io.vertx.serviceproxy.AuthenticationInterceptor;
import java.util.Map;

public class AuthenticationInterceptorImpl
implements AuthenticationInterceptor {
    final AuthenticationProvider authenticationProvider;

    public AuthenticationInterceptorImpl(AuthenticationProvider authenticationProvider) {
        this.authenticationProvider = authenticationProvider;
    }

    @Override
    public Future<Message<JsonObject>> intercept(Vertx vertx, Map<String, Object> interceptorContext, Message<JsonObject> body) {
        ContextInternal vertxContext = (ContextInternal)vertx.getOrCreateContext();
        TokenCredentials tokenCredentials = new TokenCredentials(body.headers().get("auth-token"));
        try {
            tokenCredentials.checkValid(null);
            if (this.authenticationProvider == null) {
                return vertxContext.failedFuture((Throwable)new ReplyException(ReplyFailure.RECIPIENT_FAILURE, 500, "No AuthenticationProvider present"));
            }
            return this.authenticationProvider.authenticate((Credentials)tokenCredentials).recover(err -> vertxContext.failedFuture((Throwable)new ReplyException(ReplyFailure.RECIPIENT_FAILURE, 500, err.getMessage()))).compose(user -> {
                if (user == null) {
                    return vertxContext.failedFuture((Throwable)new ReplyException(ReplyFailure.RECIPIENT_FAILURE, 401, "User is null"));
                }
                interceptorContext.put("user", user);
                return vertxContext.succeededFuture((Object)body);
            });
        }
        catch (CredentialValidationException e) {
            return Future.failedFuture((Throwable)new ReplyException(ReplyFailure.RECIPIENT_FAILURE, 401, e.getMessage()));
        }
    }
}

