/*
 * Decompiled with CFR 0.152.
 */
package io.vertx.serviceproxy.impl.utils;

import io.vertx.serviceproxy.AuthenticationInterceptor;
import io.vertx.serviceproxy.AuthorizationInterceptor;
import io.vertx.serviceproxy.ServiceInterceptor;
import io.vertx.serviceproxy.impl.InterceptorHolder;
import io.vertx.serviceproxy.impl.InterceptorPriority;
import java.util.List;

public class InterceptorUtils {
    private InterceptorUtils() {
        throw new UnsupportedOperationException();
    }

    public static InterceptorPriority getWeight(ServiceInterceptor interceptor) {
        if (interceptor instanceof AuthenticationInterceptor) {
            return InterceptorPriority.AUTHENTICATION;
        }
        if (interceptor instanceof AuthorizationInterceptor) {
            return InterceptorPriority.AUTHORIZATION;
        }
        return InterceptorPriority.USER;
    }

    public static void checkInterceptorOrder(List<InterceptorHolder> interceptorHolders, ServiceInterceptor interceptor) {
        if (interceptorHolders.isEmpty()) {
            return;
        }
        InterceptorPriority weight = InterceptorUtils.getWeight(interceptor);
        InterceptorPriority lastWeight = InterceptorUtils.getWeight(interceptorHolders.get(interceptorHolders.size() - 1).interceptor());
        if (lastWeight.ordinal() > weight.ordinal()) {
            String message = String.format("Cannot add [%s] interceptor to service binder, please check adding order!", weight.name());
            throw new IllegalStateException(message);
        }
    }
}

