/*
 * Decompiled with CFR 0.152.
 */
package io.vertx.ext.shell.impl;

import io.termd.core.util.Helper;
import io.vertx.core.Handler;
import io.vertx.core.Promise;
import io.vertx.ext.shell.Shell;
import io.vertx.ext.shell.cli.CliToken;
import io.vertx.ext.shell.cli.Completion;
import io.vertx.ext.shell.session.Session;
import io.vertx.ext.shell.session.impl.SessionImpl;
import io.vertx.ext.shell.system.ExecStatus;
import io.vertx.ext.shell.system.Job;
import io.vertx.ext.shell.system.JobController;
import io.vertx.ext.shell.system.Process;
import io.vertx.ext.shell.system.impl.InternalCommandManager;
import io.vertx.ext.shell.system.impl.JobControllerImpl;
import io.vertx.ext.shell.term.Term;
import java.util.List;
import java.util.Optional;
import java.util.UUID;
import java.util.function.Function;

public class ShellImpl
implements Shell {
    final String id;
    final Promise<Void> closedPromise;
    private final InternalCommandManager commandManager;
    private final Session session = new SessionImpl();
    private final JobControllerImpl jobController;
    private Term term;
    private String welcome;
    private Function<Session, String> promptFunc = s -> "% ";

    public ShellImpl(Term term, InternalCommandManager commandManager) {
        this.session.put("vert.x-command-manager", commandManager);
        this.id = UUID.randomUUID().toString();
        this.jobController = new JobControllerImpl();
        this.commandManager = commandManager;
        this.closedPromise = Promise.promise();
        this.term = term;
        if (term != null) {
            term.setSession(this.session);
            this.jobController.foregroundUpdatedHandler((Handler<Job>)((Handler)job -> {
                if (job == null) {
                    this.readline();
                }
            }));
        }
    }

    @Override
    public JobController jobController() {
        return this.jobController;
    }

    @Override
    public synchronized Job createJob(List<CliToken> args) {
        StringBuilder line = new StringBuilder();
        args.stream().map(CliToken::raw).forEach(line::append);
        Process process = this.commandManager.createProcess(args);
        return this.jobController.createJob(process, line.toString());
    }

    @Override
    public Job createJob(String line) {
        return this.createJob(CliToken.tokenize(line));
    }

    @Override
    public Session session() {
        return this.session;
    }

    public long lastAccessedTime() {
        return this.term.lastAccessedTime();
    }

    public void setWelcome(String welcome) {
        this.welcome = welcome;
    }

    @Override
    public void setPrompt(Function<Session, String> prompt) {
        this.promptFunc = prompt;
    }

    public ShellImpl init() {
        this.term.interruptHandler(key -> this.jobController().foregroundJob().interrupt());
        this.term.suspendHandler(key -> {
            this.term.echo(Helper.fromCodePoints((int[])new int[]{key, 10}));
            Job job = this.jobController.foregroundJob();
            this.term.echo(this.statusLine(job, ExecStatus.STOPPED) + "\n");
            job.suspend();
            return true;
        });
        this.term.closeHandler((Handler<Void>)((Handler)v -> this.jobController.close((Handler<Void>)((Handler)ar -> this.closedPromise.complete()))));
        if (this.welcome != null && this.welcome.length() > 0) {
            this.term.write(this.welcome);
        }
        return this;
    }

    private String statusLine(Job job, ExecStatus status) {
        StringBuilder sb = new StringBuilder("[").append(job.id()).append("]");
        if (this.findJob() == job) {
            sb.append("+");
        }
        sb.append(" ").append(Character.toUpperCase(status.name().charAt(0))).append(job.status().name().substring(1).toLowerCase());
        sb.append(" ").append(job.line());
        return sb.toString();
    }

    private Job findJob() {
        Job foregroundJob = this.jobController.foregroundJob();
        return this.jobController().jobs().stream().filter(job -> job != foregroundJob).sorted((j1, j2) -> Long.valueOf(j1.lastStopped()).compareTo(j2.lastStopped())).findFirst().orElse(null);
    }

    public void readline() {
        String prompt;
        try {
            prompt = this.promptFunc.apply(this.session);
        }
        catch (Exception e) {
            prompt = "% ";
        }
        this.term.readline(prompt, (Handler<String>)((Handler)line -> {
            Job job2;
            if (line == null) {
                this.term.close();
                return;
            }
            List<CliToken> tokens = CliToken.tokenize(line);
            if (tokens.stream().filter(CliToken::isText).count() == 0L) {
                this.readline();
                return;
            }
            Optional<CliToken> first = tokens.stream().filter(CliToken::isText).findFirst();
            if (first.isPresent()) {
                String name;
                switch (name = first.get().value()) {
                    case "exit": 
                    case "logout": {
                        this.term.close();
                        return;
                    }
                    case "jobs": {
                        this.jobController.jobs().forEach(job -> {
                            String statusLine = this.statusLine((Job)job, job.status()) + "\n";
                            this.term.write(statusLine);
                        });
                        this.readline();
                        return;
                    }
                    case "fg": {
                        Job job3 = this.findJob();
                        if (job3 == null) {
                            this.term.write("no such job\n");
                            this.readline();
                        } else if (job3.status() == ExecStatus.STOPPED) {
                            job3.resume(true);
                        } else {
                            job3.toForeground();
                        }
                        return;
                    }
                    case "bg": {
                        Job job4 = this.findJob();
                        if (job4 == null) {
                            this.term.write("no such job\n");
                            this.readline();
                        } else if (job4.status() == ExecStatus.STOPPED) {
                            job4.resume(false);
                            this.term.echo(this.statusLine(job4, ExecStatus.RUNNING) + "\n");
                            this.readline();
                        } else {
                            this.term.write("job " + job4.id() + " already in background\n");
                            this.readline();
                        }
                        return;
                    }
                }
            }
            try {
                job2 = this.createJob(tokens);
            }
            catch (Exception e) {
                this.term.echo(e.getMessage() + "\n");
                this.readline();
                return;
            }
            job2.setTty(this.term);
            job2.setSession(this.session);
            job2.run();
        }), (Handler<Completion>)((Handler)completion -> this.commandManager.complete((Completion)completion)));
    }

    @Override
    public void close() {
        if (this.term != null) {
            this.term.close();
        } else {
            this.jobController.close((Handler<Void>)((Handler)ar -> this.closedPromise.complete()));
        }
    }
}

