/*
 * Decompiled with CFR 0.152.
 */
package io.vertx.ext.shell.term.impl;

import io.termd.core.readline.Keymap;
import io.vertx.core.AsyncResult;
import io.vertx.core.Future;
import io.vertx.core.Handler;
import io.vertx.core.Vertx;
import io.vertx.core.buffer.Buffer;
import io.vertx.core.http.HttpServer;
import io.vertx.core.http.HttpServerOptions;
import io.vertx.ext.auth.AuthProvider;
import io.vertx.ext.shell.term.HttpTermOptions;
import io.vertx.ext.shell.term.Term;
import io.vertx.ext.shell.term.TermServer;
import io.vertx.ext.shell.term.impl.Helper;
import io.vertx.ext.shell.term.impl.SockJSTermHandlerImpl;
import io.vertx.ext.web.Router;
import io.vertx.ext.web.handler.AuthHandler;
import io.vertx.ext.web.handler.BasicAuthHandler;
import io.vertx.ext.web.handler.sockjs.SockJSHandler;
import io.vertx.ext.web.handler.sockjs.SockJSHandlerOptions;
import java.io.ByteArrayInputStream;
import java.io.InputStream;
import java.nio.charset.Charset;

public class HttpTermServer
implements TermServer {
    private final Vertx vertx;
    private HttpTermOptions options;
    private Handler<Term> termHandler;
    private HttpServer server;
    private Router router;
    private AuthProvider authProvider;

    public HttpTermServer(Vertx vertx, HttpTermOptions options) {
        this(vertx, null, options);
    }

    public HttpTermServer(Vertx vertx, Router router, HttpTermOptions options) {
        this.vertx = vertx;
        this.options = options;
        this.router = router;
    }

    @Override
    public TermServer termHandler(Handler<Term> handler) {
        this.termHandler = handler;
        return this;
    }

    @Override
    public TermServer authProvider(AuthProvider provider) {
        this.authProvider = provider;
        return this;
    }

    @Override
    public TermServer listen(Handler<AsyncResult<TermServer>> listenHandler) {
        Charset charset = Charset.forName(this.options.getCharset());
        boolean createServer = false;
        if (this.router == null) {
            createServer = true;
            this.router = Router.router((Vertx)this.vertx);
        }
        if (this.options.getAuthOptions() != null) {
            this.authProvider = this.options.getAuthOptions().createProvider(this.vertx);
        }
        if (this.options.getSockJSPath() != null && this.options.getSockJSHandlerOptions() != null) {
            Buffer inputrc;
            if (this.authProvider != null) {
                AuthHandler basicAuthHandler = BasicAuthHandler.create((AuthProvider)this.authProvider);
                this.router.route(this.options.getSockJSPath()).handler((Handler)basicAuthHandler);
            }
            if ((inputrc = Helper.loadResource(this.vertx.fileSystem(), this.options.getIntputrc())) == null) {
                if (listenHandler != null) {
                    listenHandler.handle((Object)Future.failedFuture((String)("Could not load inputrc from " + this.options.getIntputrc())));
                }
                return this;
            }
            Keymap keymap = new Keymap((InputStream)new ByteArrayInputStream(inputrc.getBytes()));
            SockJSHandler sockJSHandler = SockJSHandler.create((Vertx)this.vertx, (SockJSHandlerOptions)this.options.getSockJSHandlerOptions());
            sockJSHandler.socketHandler((Handler)new SockJSTermHandlerImpl(this.vertx, charset, keymap).termHandler(this.termHandler));
            this.router.route(this.options.getSockJSPath()).handler((Handler)sockJSHandler);
        }
        if (this.options.getVertsShellJsResource() != null) {
            this.router.get("/vertxshell.js").handler(ctx -> ctx.response().putHeader("Content-Type", "application/javascript").end(this.options.getVertsShellJsResource()));
        }
        if (this.options.getTermJsResource() != null) {
            this.router.get("/term.js").handler(ctx -> ctx.response().putHeader("Content-Type", "application/javascript").end(this.options.getTermJsResource()));
        }
        if (this.options.getShellHtmlResource() != null) {
            this.router.get("/shell.html").handler(ctx -> ctx.response().putHeader("Content-Type", "text/html").end(this.options.getShellHtmlResource()));
        }
        if (createServer) {
            this.server = this.vertx.createHttpServer((HttpServerOptions)this.options);
            this.server.requestHandler(arg_0 -> ((Router)this.router).accept(arg_0));
            this.server.listen(ar -> {
                if (listenHandler != null) {
                    if (ar.succeeded()) {
                        listenHandler.handle((Object)Future.succeededFuture((Object)this));
                    } else {
                        listenHandler.handle((Object)Future.failedFuture((Throwable)ar.cause()));
                    }
                }
            });
        } else if (listenHandler != null) {
            listenHandler.handle((Object)Future.succeededFuture((Object)this));
        }
        return this;
    }

    @Override
    public int actualPort() {
        return -1;
    }

    @Override
    public void close() {
        this.close((Handler<AsyncResult<Void>>)((Handler)ar -> {}));
    }

    @Override
    public void close(Handler<AsyncResult<Void>> completionHandler) {
        if (this.server != null) {
            this.server.close(completionHandler);
            this.server = null;
        } else {
            completionHandler.handle((Object)Future.failedFuture((String)"Not started"));
        }
    }
}

