/*
 * Decompiled with CFR 0.152.
 */
package io.vertx.ext.shell;

import io.vertx.codegen.annotations.DataObject;
import io.vertx.core.json.JsonObject;
import io.vertx.ext.shell.ShellServerOptionsConverter;
import java.io.ByteArrayOutputStream;
import java.io.InputStream;
import java.util.Map;

@DataObject(generateConverter=true)
public class ShellServerOptions {
    public static final long DEFAULT_REAPER_INTERVAL = 1000L;
    public static final long DEFAULT_SESSION_TIMEOUT = 1800000L;
    public static final String DEFAULT_WELCOME_MESSAGE;
    private String welcomeMessage;
    private long sessionTimeout;
    private long reaperInterval;

    public ShellServerOptions() {
        this.welcomeMessage = DEFAULT_WELCOME_MESSAGE;
        this.sessionTimeout = 1800000L;
        this.reaperInterval = 1000L;
    }

    public ShellServerOptions(ShellServerOptions that) {
        this.welcomeMessage = that.welcomeMessage;
        this.sessionTimeout = that.sessionTimeout;
        this.reaperInterval = that.reaperInterval;
    }

    public ShellServerOptions(JsonObject json) {
        this();
        ShellServerOptionsConverter.fromJson((Iterable<Map.Entry<String, Object>>)json, this);
    }

    public String getWelcomeMessage() {
        return this.welcomeMessage;
    }

    public ShellServerOptions setWelcomeMessage(String welcomeMessage) {
        this.welcomeMessage = welcomeMessage;
        return this;
    }

    public long getSessionTimeout() {
        return this.sessionTimeout;
    }

    public ShellServerOptions setSessionTimeout(long sessionTimeout) {
        this.sessionTimeout = sessionTimeout;
        return this;
    }

    public long getReaperInterval() {
        return this.reaperInterval;
    }

    public ShellServerOptions setReaperInterval(long reaperInterval) {
        this.reaperInterval = reaperInterval;
        return this;
    }

    static {
        String welcome = "Welcome to Vert.x Shell";
        InputStream resource = ShellServerOptions.class.getResourceAsStream("vertx-banner.txt");
        if (resource != null) {
            try (InputStream in = resource;){
                int len;
                ByteArrayOutputStream tmp = new ByteArrayOutputStream();
                byte[] buf = new byte[256];
                while ((len = in.read(buf)) != -1) {
                    tmp.write(buf, 0, len);
                }
                welcome = tmp.toString();
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        DEFAULT_WELCOME_MESSAGE = welcome + "\n\n";
    }
}

