/*
 * Decompiled with CFR 0.152.
 */
package io.vertx.ext.shell.term.impl;

import io.termd.core.telnet.TelnetHandler;
import io.vertx.core.Handler;
import io.vertx.core.Vertx;
import io.vertx.core.net.NetSocket;
import io.vertx.ext.shell.term.impl.VertxTelnetConnection;
import java.util.function.Supplier;

public class TelnetSocketHandler
implements Handler<NetSocket> {
    final Vertx vertx;
    final Supplier<TelnetHandler> factory;

    public TelnetSocketHandler(Vertx vertx, Supplier<TelnetHandler> factory) {
        this.vertx = vertx;
        this.factory = factory;
    }

    public void handle(NetSocket socket) {
        TelnetHandler handler = this.factory.get();
        VertxTelnetConnection connection = new VertxTelnetConnection(handler, Vertx.currentContext(), socket);
        socket.handler(event -> connection.receive(event.getBytes()));
        socket.closeHandler(event -> connection.onClose());
        connection.onInit();
    }
}

