/*
 * Decompiled with CFR 0.152.
 */
package io.vertx.ext.shell.term.impl;

import io.termd.core.readline.Function;
import io.termd.core.readline.Keymap;
import io.termd.core.readline.Readline;
import io.termd.core.tty.TtyConnection;
import io.vertx.core.Handler;
import io.vertx.core.Vertx;
import io.vertx.ext.shell.cli.CliToken;
import io.vertx.ext.shell.cli.Completion;
import io.vertx.ext.shell.session.Session;
import io.vertx.ext.shell.term.SignalHandler;
import io.vertx.ext.shell.term.Term;
import io.vertx.ext.shell.term.impl.Helper;
import java.util.Collections;
import java.util.List;
import java.util.function.Consumer;
import java.util.stream.Collectors;

public class TermImpl
implements Term {
    private static final List<Function> readlineFunctions = io.termd.core.util.Helper.loadServices((ClassLoader)Thread.currentThread().getContextClassLoader(), Function.class);
    private final Vertx vertx;
    private final Readline readline;
    private final Consumer<int[]> echoHandler;
    final TtyConnection conn;
    volatile Handler<String> stdinHandler;
    private SignalHandler interruptHandler;
    private SignalHandler suspendHandler;
    private Session session;
    private boolean inReadline;

    public TermImpl(Vertx vertx, TtyConnection conn) {
        this(vertx, Helper.defaultKeymap(), conn);
    }

    public TermImpl(Vertx vertx, Keymap keymap, TtyConnection conn) {
        this.vertx = vertx;
        this.conn = conn;
        this.readline = new Readline(keymap);
        readlineFunctions.forEach(arg_0 -> ((Readline)this.readline).addFunction(arg_0));
        this.echoHandler = codePoints -> {
            this.echo((int)codePoints);
            this.readline.queueEvent(codePoints);
        };
        conn.setStdinHandler(this.echoHandler);
        conn.setEventHandler((event, key) -> {
            switch (event) {
                case INTR: {
                    if (this.interruptHandler != null && this.interruptHandler.deliver((int)key)) break;
                    this.echo((int)key, 10);
                    break;
                }
                case EOF: {
                    if (this.stdinHandler != null) {
                        this.stdinHandler.handle((Object)io.termd.core.util.Helper.fromCodePoints((int[])new int[]{key}));
                        break;
                    }
                    this.echo((int)key);
                    this.readline.queueEvent(new int[]{key});
                    break;
                }
                case SUSP: {
                    if (this.suspendHandler != null && this.suspendHandler.deliver((int)key)) break;
                    this.echo((int)key, 26);
                }
            }
        });
    }

    @Override
    public Term setSession(Session session) {
        this.session = session;
        return this;
    }

    @Override
    public void readline(String prompt, Handler<String> lineHandler) {
        if (this.conn.getStdinHandler() != this.echoHandler) {
            throw new IllegalStateException();
        }
        if (this.inReadline) {
            throw new IllegalStateException();
        }
        this.inReadline = true;
        this.readline.readline(this.conn, prompt, line -> {
            this.inReadline = false;
            lineHandler.handle(line);
        });
    }

    @Override
    public void readline(String prompt, Handler<String> lineHandler, Handler<Completion> completionHandler) {
        if (this.conn.getStdinHandler() != this.echoHandler) {
            throw new IllegalStateException();
        }
        if (this.inReadline) {
            throw new IllegalStateException();
        }
        this.inReadline = true;
        this.readline.readline(this.conn, prompt, line -> {
            this.inReadline = false;
            lineHandler.handle(line);
        }, abc -> {
            final String line = io.termd.core.util.Helper.fromCodePoints((int[])abc.line());
            final List<CliToken> tokens = Collections.unmodifiableList(CliToken.tokenize(line));
            Completion comp = new Completion((io.termd.core.readline.Completion)abc){
                final /* synthetic */ io.termd.core.readline.Completion val$abc;
                {
                    this.val$abc = completion;
                }

                @Override
                public Vertx vertx() {
                    return TermImpl.this.vertx;
                }

                @Override
                public Session session() {
                    return TermImpl.this.session;
                }

                @Override
                public String rawLine() {
                    return line;
                }

                @Override
                public List<CliToken> lineTokens() {
                    return tokens;
                }

                @Override
                public void complete(List<String> candidates) {
                    if (candidates.size() > 0) {
                        this.val$abc.suggest(candidates.stream().map(io.termd.core.util.Helper::toCodePoints).collect(Collectors.toList()));
                    } else {
                        this.val$abc.end();
                    }
                }

                @Override
                public void complete(String value, boolean terminal) {
                    this.val$abc.complete(io.termd.core.util.Helper.toCodePoints((String)value), terminal);
                }
            };
            completionHandler.handle((Object)comp);
        });
    }

    @Override
    public Term closeHandler(Handler<Void> handler) {
        if (handler != null) {
            this.conn.setCloseHandler(arg_0 -> handler.handle(arg_0));
        } else {
            this.conn.setCloseHandler(null);
        }
        return this;
    }

    @Override
    public long lastAccessedTime() {
        return this.conn.lastAccessedTime();
    }

    @Override
    public String type() {
        return this.conn.terminalType();
    }

    @Override
    public int width() {
        return this.conn.size() != null ? this.conn.size().x() : -1;
    }

    @Override
    public int height() {
        return this.conn.size() != null ? this.conn.size().y() : -1;
    }

    void checkPending() {
        if (this.stdinHandler != null && this.readline.hasEvent()) {
            this.stdinHandler.handle((Object)io.termd.core.util.Helper.fromCodePoints((int[])this.readline.nextEvent().buffer().array()));
            this.vertx.runOnContext(v -> this.checkPending());
        }
    }

    @Override
    public TermImpl resizehandler(Handler<Void> handler) {
        if (this.inReadline) {
            throw new IllegalStateException();
        }
        if (handler != null) {
            this.conn.setSizeHandler(resize -> handler.handle(null));
        } else {
            this.conn.setSizeHandler(null);
        }
        return this;
    }

    @Override
    public Term stdinHandler(Handler<String> handler) {
        if (this.inReadline) {
            throw new IllegalStateException();
        }
        this.stdinHandler = handler;
        if (handler != null) {
            this.conn.setStdinHandler(codePoints -> handler.handle((Object)io.termd.core.util.Helper.fromCodePoints((int[])codePoints)));
            this.checkPending();
        } else {
            this.conn.setStdinHandler(this.echoHandler);
        }
        return this;
    }

    @Override
    public Term write(String data) {
        this.conn.write(data);
        return this;
    }

    @Override
    public TermImpl interruptHandler(SignalHandler handler) {
        this.interruptHandler = handler;
        return this;
    }

    @Override
    public TermImpl suspendHandler(SignalHandler handler) {
        this.suspendHandler = handler;
        return this;
    }

    @Override
    public void close() {
        this.conn.close();
    }

    @Override
    public TermImpl echo(String text) {
        this.echo(io.termd.core.util.Helper.toCodePoints((String)text));
        return this;
    }

    public void echo(int ... codePoints) {
        Consumer out = this.conn.stdoutHandler();
        for (int codePoint : codePoints) {
            if (codePoint < 32) {
                if (codePoint == 9) {
                    out.accept(new int[]{9});
                    continue;
                }
                if (codePoint == 8) {
                    out.accept(new int[]{8, 32, 8});
                    continue;
                }
                if (codePoint == 13 || codePoint == 10) {
                    out.accept(new int[]{10});
                    continue;
                }
                out.accept(new int[]{94, codePoint + 64});
                continue;
            }
            if (codePoint == 127) {
                out.accept(new int[]{8, 32, 8});
                continue;
            }
            out.accept(new int[]{codePoint});
        }
    }
}

