/*
 * Decompiled with CFR 0.152.
 */
package io.vertx.ext.shell.command.base;

import io.vertx.core.Handler;
import io.vertx.core.Vertx;
import io.vertx.core.cli.annotations.Argument;
import io.vertx.core.cli.annotations.Description;
import io.vertx.core.cli.annotations.Name;
import io.vertx.core.cli.annotations.Summary;
import io.vertx.ext.shell.command.AnnotatedCommand;
import io.vertx.ext.shell.command.CommandProcess;
import java.util.concurrent.atomic.AtomicLong;

@Name(value="sleep")
@Summary(value="Suspend execution for an interval of time")
public class Sleep
extends AnnotatedCommand {
    private String seconds;

    @Description(value="the number of seconds to wait")
    @Argument(index=0, argName="seconds")
    public void setSeconds(String seconds) {
        this.seconds = seconds;
    }

    @Override
    public void process(CommandProcess process) {
        int timeout = -1;
        try {
            timeout = Integer.parseInt(this.seconds);
        }
        catch (NumberFormatException numberFormatException) {
            // empty catch block
        }
        this.scheduleSleep(process, (long)timeout * 1000L);
    }

    private void scheduleSleep(CommandProcess process, long millis) {
        Vertx vertx = process.vertx();
        if (millis > 0L) {
            long now = System.currentTimeMillis();
            AtomicLong remaining = new AtomicLong(-1L);
            long id = process.vertx().setTimer(millis, v -> process.end());
            process.suspendHandler((Handler<Void>)((Handler)v -> {
                vertx.cancelTimer(id);
                remaining.set(millis - (System.currentTimeMillis() - now));
            }));
            process.resumeHandler((Handler<Void>)((Handler)v -> this.scheduleSleep(process, remaining.get())));
            process.interruptHandler((Handler<Void>)((Handler)v -> process.end()));
            process.endHandler((Handler<Void>)((Handler)v -> vertx.cancelTimer(id)));
        } else {
            process.end();
        }
    }
}

