/*
 * Decompiled with CFR 0.152.
 */
package io.vertx.ext.shell.term;

import io.vertx.core.json.JsonObject;
import io.vertx.core.json.impl.JsonUtil;
import io.vertx.core.net.JksOptions;
import io.vertx.core.net.PemKeyCertOptions;
import io.vertx.core.net.PfxOptions;
import io.vertx.ext.shell.term.SSHTermOptions;
import java.util.Base64;
import java.util.Map;

public class SSHTermOptionsConverter {
    private static final Base64.Decoder BASE64_DECODER = JsonUtil.BASE64_DECODER;
    private static final Base64.Encoder BASE64_ENCODER = JsonUtil.BASE64_ENCODER;

    static void fromJson(Iterable<Map.Entry<String, Object>> json, SSHTermOptions obj) {
        for (Map.Entry<String, Object> member : json) {
            switch (member.getKey()) {
                case "authOptions": {
                    if (!(member.getValue() instanceof JsonObject)) break;
                    obj.setAuthOptions(((JsonObject)member.getValue()).copy());
                    break;
                }
                case "defaultCharset": {
                    if (!(member.getValue() instanceof String)) break;
                    obj.setDefaultCharset((String)member.getValue());
                    break;
                }
                case "host": {
                    if (!(member.getValue() instanceof String)) break;
                    obj.setHost((String)member.getValue());
                    break;
                }
                case "intputrc": {
                    if (!(member.getValue() instanceof String)) break;
                    obj.setIntputrc((String)member.getValue());
                    break;
                }
                case "keyPairOptions": {
                    if (!(member.getValue() instanceof JsonObject)) break;
                    obj.setKeyPairOptions(new JksOptions((JsonObject)member.getValue()));
                    break;
                }
                case "pemKeyPairOptions": {
                    if (!(member.getValue() instanceof JsonObject)) break;
                    obj.setPemKeyPairOptions(new PemKeyCertOptions((JsonObject)member.getValue()));
                    break;
                }
                case "pfxKeyPairOptions": {
                    if (!(member.getValue() instanceof JsonObject)) break;
                    obj.setPfxKeyPairOptions(new PfxOptions((JsonObject)member.getValue()));
                    break;
                }
                case "port": {
                    if (!(member.getValue() instanceof Number)) break;
                    obj.setPort(((Number)member.getValue()).intValue());
                }
            }
        }
    }

    static void toJson(SSHTermOptions obj, JsonObject json) {
        SSHTermOptionsConverter.toJson(obj, json.getMap());
    }

    static void toJson(SSHTermOptions obj, Map<String, Object> json) {
        if (obj.getAuthOptions() != null) {
            json.put("authOptions", obj.getAuthOptions());
        }
        if (obj.getDefaultCharset() != null) {
            json.put("defaultCharset", obj.getDefaultCharset());
        }
        if (obj.getHost() != null) {
            json.put("host", obj.getHost());
        }
        if (obj.getIntputrc() != null) {
            json.put("intputrc", obj.getIntputrc());
        }
        json.put("port", obj.getPort());
    }
}

