/*
 * Decompiled with CFR 0.152.
 */
package io.vertx.ext.shell.command.impl;

import io.vertx.core.AbstractVerticle;
import io.vertx.core.AsyncResult;
import io.vertx.core.Closeable;
import io.vertx.core.Future;
import io.vertx.core.Handler;
import io.vertx.core.Promise;
import io.vertx.core.Verticle;
import io.vertx.core.Vertx;
import io.vertx.core.impl.VertxInternal;
import io.vertx.ext.shell.command.AnnotatedCommand;
import io.vertx.ext.shell.command.Command;
import io.vertx.ext.shell.command.CommandRegistry;
import io.vertx.ext.shell.command.impl.CommandRegistration;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.stream.Collectors;

public class CommandRegistryImpl
implements CommandRegistry {
    private static final Map<Vertx, CommandRegistryImpl> registries = new ConcurrentHashMap<Vertx, CommandRegistryImpl>();
    final VertxInternal vertx;
    final ConcurrentHashMap<String, CommandRegistration> commandMap = new ConcurrentHashMap();
    final Closeable hook;
    private volatile boolean closed;

    public static CommandRegistry get(Vertx vertx) {
        return registries.computeIfAbsent(vertx, v -> new CommandRegistryImpl((VertxInternal)vertx));
    }

    public CommandRegistryImpl(VertxInternal vertx) {
        this.vertx = vertx;
        this.hook = completionHandler -> {
            try {
                this.doClose();
                registries.remove(vertx);
            }
            catch (Exception e) {
                completionHandler.handle((AsyncResult)Future.failedFuture((Throwable)e));
                return;
            }
            completionHandler.handle((AsyncResult)Future.succeededFuture());
        };
        vertx.addCloseHook(this.hook);
    }

    private void doClose() {
        this.closed = true;
    }

    public boolean isClosed() {
        return this.closed;
    }

    @Override
    public List<Command> commands() {
        return new ArrayList<Command>(this.commandMap.values().stream().map(reg -> reg.command).collect(Collectors.toList()));
    }

    @Override
    public Future<Command> registerCommand(Class<? extends AnnotatedCommand> command) {
        return this.registerCommand(Command.create((Vertx)this.vertx, command));
    }

    @Override
    public CommandRegistry registerCommand(Class<? extends AnnotatedCommand> command, Handler<AsyncResult<Command>> completionHandler) {
        return this.registerCommand(Command.create((Vertx)this.vertx, command), completionHandler);
    }

    @Override
    public Future<Command> registerCommand(Command command) {
        Promise promise = Promise.promise();
        this.registerCommand(command, (Handler<AsyncResult<Command>>)promise);
        return promise.future();
    }

    @Override
    public CommandRegistry registerCommand(Command command, Handler<AsyncResult<Command>> completionHandler) {
        return this.registerCommands(Collections.singletonList(command), (Handler<AsyncResult<List<Command>>>)((Handler)ar -> {
            if (completionHandler != null) {
                if (ar.succeeded()) {
                    completionHandler.handle((Object)Future.succeededFuture(((List)ar.result()).get(0)));
                } else {
                    completionHandler.handle((Object)Future.failedFuture((Throwable)ar.cause()));
                }
            }
        }));
    }

    @Override
    public Future<List<Command>> registerCommands(List<Command> commands) {
        Promise promise = Promise.promise();
        this.registerCommands(commands, (Handler<AsyncResult<List<Command>>>)promise);
        return promise.future();
    }

    @Override
    public CommandRegistry registerCommands(final List<Command> commands, Handler<AsyncResult<List<Command>>> doneHandler) {
        if (this.closed) {
            throw new IllegalStateException();
        }
        this.vertx.deployVerticle((Verticle)new AbstractVerticle(){

            public void start() throws Exception {
                HashMap<String, CommandRegistration> newReg = new HashMap<String, CommandRegistration>();
                for (Command command : commands) {
                    String name = command.name();
                    if (CommandRegistryImpl.this.commandMap.containsKey(name)) {
                        throw new Exception("Command " + name + " already registered");
                    }
                    CommandRegistration registration = new CommandRegistration(command, this.deploymentID());
                    newReg.put(name, registration);
                }
                CommandRegistryImpl.this.commandMap.putAll(newReg);
            }

            public void stop() throws Exception {
                String deploymentId = this.deploymentID();
                CommandRegistryImpl.this.commandMap.values().removeIf(reg -> deploymentId.equals(reg.deploymendID));
            }
        }, ar -> {
            if (ar.succeeded()) {
                List regs = this.commandMap.values().stream().filter(reg -> ((String)ar.result()).equals(reg.deploymendID)).map(reg -> reg.command).collect(Collectors.toList());
                doneHandler.handle((Object)Future.succeededFuture(regs));
            } else {
                doneHandler.handle((Object)Future.failedFuture((Throwable)ar.cause()));
            }
        });
        return this;
    }

    @Override
    public Future<Void> unregisterCommand(String commandName) {
        Promise promise = Promise.promise();
        this.unregisterCommand(commandName, (Handler<AsyncResult<Void>>)promise);
        return promise.future();
    }

    @Override
    public CommandRegistry unregisterCommand(String name, Handler<AsyncResult<Void>> completionHandler) {
        if (this.closed) {
            throw new IllegalStateException();
        }
        CommandRegistration registration = this.commandMap.remove(name);
        if (registration != null) {
            String deploymendID = registration.deploymendID;
            if (deploymendID != null && this.commandMap.values().stream().noneMatch(reg -> deploymendID.equals(reg.deploymendID))) {
                if (completionHandler != null) {
                    this.vertx.undeploy(deploymendID, completionHandler);
                }
                return this;
            }
            if (completionHandler != null) {
                completionHandler.handle((Object)Future.succeededFuture());
            }
        } else if (completionHandler != null) {
            completionHandler.handle((Object)Future.failedFuture((String)("Command " + name + " not registered")));
        }
        return this;
    }
}

