/*
 * Decompiled with CFR 0.152.
 */
package io.vertx.ext.shell.term.impl;

import io.termd.core.readline.Keymap;
import io.termd.core.telnet.TelnetTtyConnection;
import io.vertx.core.AsyncResult;
import io.vertx.core.Future;
import io.vertx.core.Handler;
import io.vertx.core.Vertx;
import io.vertx.core.buffer.Buffer;
import io.vertx.core.net.NetServer;
import io.vertx.core.net.NetServerOptions;
import io.vertx.ext.auth.authentication.AuthenticationProvider;
import io.vertx.ext.shell.term.TelnetTermOptions;
import io.vertx.ext.shell.term.Term;
import io.vertx.ext.shell.term.TermServer;
import io.vertx.ext.shell.term.impl.Helper;
import io.vertx.ext.shell.term.impl.TelnetSocketHandler;
import io.vertx.ext.shell.term.impl.TermConnectionHandler;
import java.io.ByteArrayInputStream;
import java.io.InputStream;
import java.nio.charset.Charset;

public class TelnetTermServer
implements TermServer {
    private final Vertx vertx;
    private final TelnetTermOptions options;
    private Handler<Term> termHandler;
    private NetServer server;

    public TelnetTermServer(Vertx vertx, TelnetTermOptions options) {
        this.vertx = vertx;
        this.options = new TelnetTermOptions(options);
    }

    @Override
    public TermServer authenticationProvider(AuthenticationProvider provider) {
        return this;
    }

    @Override
    public TermServer termHandler(Handler<Term> handler) {
        this.termHandler = handler;
        return this;
    }

    @Override
    public TermServer listen(Handler<AsyncResult<Void>> listenHandler) {
        Charset charset = Charset.forName(this.options.getCharset());
        if (this.server == null) {
            this.server = this.vertx.createNetServer((NetServerOptions)this.options);
            Buffer inputrc = Helper.loadResource(this.vertx.fileSystem(), this.options.getIntputrc());
            if (inputrc == null) {
                listenHandler.handle((Object)Future.failedFuture((String)("Could not load inputrc from " + this.options.getIntputrc())));
                return this;
            }
            Keymap keymap = new Keymap((InputStream)new ByteArrayInputStream(inputrc.getBytes()));
            TermConnectionHandler connectionHandler = new TermConnectionHandler(this.vertx, keymap, this.termHandler);
            this.server.connectHandler((Handler)new TelnetSocketHandler(this.vertx, () -> new TelnetTtyConnection(this.options.getInBinary(), this.options.getOutBinary(), charset, connectionHandler::handle)));
            this.server.listen(ar -> {
                if (ar.succeeded()) {
                    listenHandler.handle((Object)Future.succeededFuture());
                } else {
                    listenHandler.handle((Object)Future.failedFuture((Throwable)ar.cause()));
                }
            });
        } else {
            listenHandler.handle((Object)Future.failedFuture((String)"Already started"));
        }
        return this;
    }

    @Override
    public void close(Handler<AsyncResult<Void>> completionHandler) {
        if (this.server != null) {
            this.server.close(completionHandler);
            this.server = null;
        } else {
            completionHandler.handle((Object)Future.failedFuture((String)"No started"));
        }
    }

    @Override
    public int actualPort() {
        return this.server.actualPort();
    }
}

