/*
 * Decompiled with CFR 0.152.
 */
package io.vertx.ext.shell.term;

import io.vertx.codegen.annotations.DataObject;
import io.vertx.codegen.json.annotations.JsonGen;
import io.vertx.core.buffer.Buffer;
import io.vertx.core.http.ClientAuth;
import io.vertx.core.http.HttpServerOptions;
import io.vertx.core.json.JsonObject;
import io.vertx.core.net.JksOptions;
import io.vertx.core.net.PemKeyCertOptions;
import io.vertx.core.net.PemTrustOptions;
import io.vertx.core.net.PfxOptions;
import io.vertx.ext.shell.term.HttpTermOptionsConverter;
import io.vertx.ext.shell.term.impl.Helper;
import io.vertx.ext.web.handler.sockjs.SockJSHandlerOptions;
import java.nio.charset.StandardCharsets;
import java.util.Map;

@DataObject
@JsonGen(publicConverter=false)
public class HttpTermOptions
extends HttpServerOptions {
    public static final String DEFAULT_CHARSET = StandardCharsets.UTF_8.name();
    public static final String DEFAULT_INPUTRC = "/io/vertx/ext/shell/inputrc";
    private static final String DEFAULT_SOCKJSPATH = "/shell/*";
    private SockJSHandlerOptions sockJSHandlerOptions;
    private JsonObject authOptions;
    private String sockJSPath;
    private Buffer vertsShellJsResource;
    private Buffer termJsResource;
    private Buffer shellHtmlResource;
    private String charset;
    private String intputrc;

    public static Buffer defaultVertxShellJsResource() {
        return Helper.loadResource("/io/vertx/ext/shell/vertxshell.js");
    }

    public static Buffer defaultTermJsResource() {
        return Helper.loadResource("/io/vertx/ext/shell/term.js");
    }

    public static Buffer defaultShellHtmlResource() {
        return Helper.loadResource("/io/vertx/ext/shell/shell.html");
    }

    public HttpTermOptions() {
        this.init();
    }

    public HttpTermOptions(JsonObject json) {
        super(json);
        this.init();
        HttpTermOptionsConverter.fromJson((Iterable<Map.Entry<String, Object>>)json, this);
    }

    public HttpTermOptions(HttpTermOptions that) {
        this.sockJSHandlerOptions = new SockJSHandlerOptions(that.sockJSHandlerOptions);
        this.sockJSPath = that.sockJSPath;
        this.vertsShellJsResource = that.vertsShellJsResource != null ? that.vertsShellJsResource.copy() : null;
        this.termJsResource = that.termJsResource != null ? that.termJsResource.copy() : null;
        this.shellHtmlResource = that.shellHtmlResource != null ? that.shellHtmlResource.copy() : null;
        this.authOptions = that.authOptions != null ? that.authOptions.copy() : null;
        this.charset = that.charset;
        this.intputrc = that.intputrc;
    }

    private void init() {
        this.sockJSHandlerOptions = new SockJSHandlerOptions();
        this.sockJSPath = DEFAULT_SOCKJSPATH;
        this.vertsShellJsResource = HttpTermOptions.defaultVertxShellJsResource();
        this.termJsResource = HttpTermOptions.defaultTermJsResource();
        this.shellHtmlResource = HttpTermOptions.defaultShellHtmlResource();
        this.charset = DEFAULT_CHARSET;
        this.intputrc = DEFAULT_INPUTRC;
    }

    public SockJSHandlerOptions getSockJSHandlerOptions() {
        return this.sockJSHandlerOptions;
    }

    public HttpTermOptions setSockJSHandlerOptions(SockJSHandlerOptions sockJSHandlerOptions) {
        this.sockJSHandlerOptions = sockJSHandlerOptions;
        return this;
    }

    public String getSockJSPath() {
        return this.sockJSPath;
    }

    public HttpTermOptions setSockJSPath(String sockJSPath) {
        this.sockJSPath = sockJSPath;
        return this;
    }

    public JsonObject getAuthOptions() {
        return this.authOptions;
    }

    public HttpTermOptions setAuthOptions(JsonObject authOptions) {
        this.authOptions = authOptions;
        return this;
    }

    public HttpTermOptions setSendBufferSize(int sendBufferSize) {
        return (HttpTermOptions)super.setSendBufferSize(sendBufferSize);
    }

    public HttpTermOptions setReceiveBufferSize(int receiveBufferSize) {
        return (HttpTermOptions)super.setReceiveBufferSize(receiveBufferSize);
    }

    public HttpTermOptions setReuseAddress(boolean reuseAddress) {
        return (HttpTermOptions)super.setReuseAddress(reuseAddress);
    }

    public HttpTermOptions setTrafficClass(int trafficClass) {
        return (HttpTermOptions)super.setTrafficClass(trafficClass);
    }

    public HttpTermOptions setTcpNoDelay(boolean tcpNoDelay) {
        return (HttpTermOptions)super.setTcpNoDelay(tcpNoDelay);
    }

    public HttpTermOptions setTcpKeepAlive(boolean tcpKeepAlive) {
        return (HttpTermOptions)super.setTcpKeepAlive(tcpKeepAlive);
    }

    public HttpTermOptions setSoLinger(int soLinger) {
        return (HttpTermOptions)super.setSoLinger(soLinger);
    }

    public HttpTermOptions setIdleTimeout(int idleTimeout) {
        return (HttpTermOptions)super.setIdleTimeout(idleTimeout);
    }

    public HttpTermOptions setSsl(boolean ssl) {
        return (HttpTermOptions)super.setSsl(ssl);
    }

    public HttpTermOptions setKeyStoreOptions(JksOptions options) {
        return (HttpTermOptions)super.setKeyStoreOptions(options);
    }

    public HttpTermOptions setPfxKeyCertOptions(PfxOptions options) {
        return (HttpTermOptions)super.setPfxKeyCertOptions(options);
    }

    public HttpTermOptions setPemKeyCertOptions(PemKeyCertOptions options) {
        return (HttpTermOptions)super.setPemKeyCertOptions(options);
    }

    public HttpTermOptions setTrustStoreOptions(JksOptions options) {
        return (HttpTermOptions)super.setTrustStoreOptions(options);
    }

    public HttpTermOptions setPemTrustOptions(PemTrustOptions options) {
        return (HttpTermOptions)super.setPemTrustOptions(options);
    }

    public HttpTermOptions setPfxTrustOptions(PfxOptions options) {
        return (HttpTermOptions)super.setPfxTrustOptions(options);
    }

    public HttpTermOptions addEnabledCipherSuite(String suite) {
        return (HttpTermOptions)super.addEnabledCipherSuite(suite);
    }

    public HttpTermOptions addCrlPath(String crlPath) throws NullPointerException {
        return (HttpTermOptions)super.addCrlPath(crlPath);
    }

    public HttpTermOptions addCrlValue(Buffer crlValue) throws NullPointerException {
        return (HttpTermOptions)super.addCrlValue(crlValue);
    }

    public HttpTermOptions setAcceptBacklog(int acceptBacklog) {
        return (HttpTermOptions)super.setAcceptBacklog(acceptBacklog);
    }

    public HttpTermOptions setPort(int port) {
        return (HttpTermOptions)super.setPort(port);
    }

    public HttpTermOptions setHost(String host) {
        return (HttpTermOptions)super.setHost(host);
    }

    public HttpTermOptions setClientAuth(ClientAuth clientAuth) {
        return (HttpTermOptions)super.setClientAuth(clientAuth);
    }

    public HttpTermOptions setCompressionSupported(boolean compressionSupported) {
        return (HttpTermOptions)super.setCompressionSupported(compressionSupported);
    }

    public HttpTermOptions setHandle100ContinueAutomatically(boolean handle100ContinueAutomatically) {
        return (HttpTermOptions)super.setHandle100ContinueAutomatically(handle100ContinueAutomatically);
    }

    public Buffer getVertsShellJsResource() {
        return this.vertsShellJsResource;
    }

    public HttpTermOptions setVertsShellJsResource(Buffer vertsShellJsResource) {
        this.vertsShellJsResource = vertsShellJsResource;
        return this;
    }

    public Buffer getTermJsResource() {
        return this.termJsResource;
    }

    public HttpTermOptions setTermJsResource(Buffer termJsResource) {
        this.termJsResource = termJsResource;
        return this;
    }

    public Buffer getShellHtmlResource() {
        return this.shellHtmlResource;
    }

    public HttpTermOptions setShellHtmlResource(Buffer shellHtmlResource) {
        this.shellHtmlResource = shellHtmlResource;
        return this;
    }

    public String getCharset() {
        return this.charset;
    }

    public HttpTermOptions setCharset(String charset) {
        this.charset = charset;
        return this;
    }

    public String getIntputrc() {
        return this.intputrc;
    }

    public HttpTermOptions setIntputrc(String intputrc) {
        this.intputrc = intputrc;
        return this;
    }
}

