/*
 * Decompiled with CFR 0.152.
 */
package io.vertx.ext.shell.command.impl;

import io.vertx.core.AbstractVerticle;
import io.vertx.core.AsyncResult;
import io.vertx.core.Closeable;
import io.vertx.core.Completable;
import io.vertx.core.Deployable;
import io.vertx.core.Future;
import io.vertx.core.Promise;
import io.vertx.core.Vertx;
import io.vertx.core.internal.VertxInternal;
import io.vertx.ext.shell.command.AnnotatedCommand;
import io.vertx.ext.shell.command.Command;
import io.vertx.ext.shell.command.CommandRegistry;
import io.vertx.ext.shell.command.impl.CommandRegistration;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.stream.Collectors;

public class CommandRegistryImpl
implements CommandRegistry {
    private static final Map<Vertx, CommandRegistryImpl> registries = new ConcurrentHashMap<Vertx, CommandRegistryImpl>();
    final VertxInternal vertx;
    final ConcurrentHashMap<String, CommandRegistration> commandMap = new ConcurrentHashMap();
    final Closeable hook;
    private volatile boolean closed;

    public static CommandRegistry get(Vertx vertx) {
        return registries.computeIfAbsent(vertx, v -> new CommandRegistryImpl((VertxInternal)vertx));
    }

    public CommandRegistryImpl(VertxInternal vertx) {
        this.vertx = vertx;
        this.hook = completionHandler -> {
            try {
                this.doClose();
                registries.remove(vertx);
            }
            catch (Exception e) {
                completionHandler.handle((AsyncResult)Future.failedFuture((Throwable)e));
                return;
            }
            completionHandler.handle((AsyncResult)Future.succeededFuture());
        };
        vertx.addCloseHook(this.hook);
    }

    private void doClose() {
        this.closed = true;
    }

    public boolean isClosed() {
        return this.closed;
    }

    @Override
    public List<Command> commands() {
        return new ArrayList<Command>(this.commandMap.values().stream().map(reg -> reg.command).collect(Collectors.toList()));
    }

    @Override
    public Future<Command> registerCommand(Class<? extends AnnotatedCommand> command) {
        return this.registerCommand(Command.create((Vertx)this.vertx, command));
    }

    public CommandRegistry registerCommand(Class<? extends AnnotatedCommand> command, Completable<Command> completionHandler) {
        return this.registerCommand(Command.create((Vertx)this.vertx, command), completionHandler);
    }

    @Override
    public Future<Command> registerCommand(Command command) {
        Promise promise = Promise.promise();
        this.registerCommand(command, (Completable<Command>)promise);
        return promise.future();
    }

    public CommandRegistry registerCommand(Command command, Completable<Command> completionHandler) {
        return this.registerCommands(Collections.singletonList(command), (Completable<List<Command>>)((Completable)(res, err) -> {
            if (completionHandler != null) {
                if (err == null) {
                    completionHandler.succeed((Object)((Command)res.get(0)));
                } else {
                    completionHandler.fail(err);
                }
            }
        }));
    }

    @Override
    public Future<List<Command>> registerCommands(List<Command> commands) {
        Promise promise = Promise.promise();
        this.registerCommands(commands, (Completable<List<Command>>)promise);
        return promise.future();
    }

    public CommandRegistry registerCommands(final List<Command> commands, Completable<List<Command>> doneHandler) {
        if (this.closed) {
            throw new IllegalStateException();
        }
        this.vertx.deployVerticle((Deployable)new AbstractVerticle(){

            public void start() throws Exception {
                HashMap<String, CommandRegistration> newReg = new HashMap<String, CommandRegistration>();
                for (Command command : commands) {
                    String name = command.name();
                    if (CommandRegistryImpl.this.commandMap.containsKey(name)) {
                        throw new Exception("Command " + name + " already registered");
                    }
                    CommandRegistration registration = new CommandRegistration(command, this.deploymentID());
                    newReg.put(name, registration);
                }
                CommandRegistryImpl.this.commandMap.putAll(newReg);
            }

            public void stop() throws Exception {
                String deploymentId = this.deploymentID();
                CommandRegistryImpl.this.commandMap.values().removeIf(reg -> deploymentId.equals(reg.deploymendID));
            }
        }).onComplete(ar -> {
            if (ar.succeeded()) {
                List regs = this.commandMap.values().stream().filter(reg -> ((String)ar.result()).equals(reg.deploymendID)).map(reg -> reg.command).collect(Collectors.toList());
                doneHandler.succeed(regs);
            } else {
                doneHandler.fail(ar.cause());
            }
        });
        return this;
    }

    @Override
    public Future<Void> unregisterCommand(String commandName) {
        Promise promise = Promise.promise();
        this.unregisterCommand(commandName, (Completable<Void>)promise);
        return promise.future();
    }

    public CommandRegistry unregisterCommand(String name, Completable<Void> completionHandler) {
        if (this.closed) {
            throw new IllegalStateException();
        }
        CommandRegistration registration = this.commandMap.remove(name);
        if (registration != null) {
            String deploymendID = registration.deploymendID;
            if (deploymendID != null && this.commandMap.values().stream().noneMatch(reg -> deploymendID.equals(reg.deploymendID))) {
                if (completionHandler != null) {
                    this.vertx.undeploy(deploymendID).onComplete(completionHandler);
                }
                return this;
            }
            if (completionHandler != null) {
                completionHandler.succeed();
            }
        } else if (completionHandler != null) {
            completionHandler.fail("Command " + name + " not registered");
        }
        return this;
    }
}

