/*
 * Decompiled with CFR 0.152.
 */
package io.vertx.ext.shell.term.impl;

import io.termd.core.readline.Keymap;
import io.vertx.core.Completable;
import io.vertx.core.Future;
import io.vertx.core.Handler;
import io.vertx.core.Vertx;
import io.vertx.core.buffer.Buffer;
import io.vertx.core.http.HttpServer;
import io.vertx.core.http.HttpServerOptions;
import io.vertx.ext.auth.authentication.AuthenticationProvider;
import io.vertx.ext.shell.impl.ShellAuth;
import io.vertx.ext.shell.term.HttpTermOptions;
import io.vertx.ext.shell.term.Term;
import io.vertx.ext.shell.term.TermServer;
import io.vertx.ext.shell.term.impl.Helper;
import io.vertx.ext.shell.term.impl.SockJSTermHandlerImpl;
import io.vertx.ext.web.Router;
import io.vertx.ext.web.handler.BasicAuthHandler;
import io.vertx.ext.web.handler.sockjs.SockJSHandler;
import io.vertx.ext.web.handler.sockjs.SockJSHandlerOptions;
import java.io.ByteArrayInputStream;
import java.io.InputStream;
import java.nio.charset.Charset;

public class HttpTermServer
implements TermServer {
    private final Vertx vertx;
    private HttpTermOptions options;
    private Handler<Term> termHandler;
    private HttpServer server;
    private Router router;
    private AuthenticationProvider authProvider;

    public HttpTermServer(Vertx vertx, HttpTermOptions options) {
        this(vertx, null, options);
    }

    public HttpTermServer(Vertx vertx, Router router, HttpTermOptions options) {
        this.vertx = vertx;
        this.options = options;
        this.router = router;
    }

    @Override
    public TermServer termHandler(Handler<Term> handler) {
        this.termHandler = handler;
        return this;
    }

    @Override
    public TermServer authenticationProvider(AuthenticationProvider provider) {
        this.authProvider = provider;
        return this;
    }

    public TermServer listen(Completable<Void> listenHandler) {
        Charset charset = Charset.forName(this.options.getCharset());
        boolean createServer = false;
        if (this.router == null) {
            createServer = true;
            this.router = Router.router((Vertx)this.vertx);
        }
        if (this.options.getAuthOptions() != null) {
            this.authProvider = ShellAuth.load(this.vertx, this.options.getAuthOptions());
        }
        if (this.options.getSockJSPath() != null && this.options.getSockJSHandlerOptions() != null) {
            Buffer inputrc;
            if (this.authProvider != null) {
                BasicAuthHandler basicAuthHandler = BasicAuthHandler.create((AuthenticationProvider)this.authProvider);
                this.router.route(this.options.getSockJSPath()).handler((Handler)basicAuthHandler);
            }
            if ((inputrc = Helper.loadResource(this.vertx.fileSystem(), this.options.getIntputrc())) == null) {
                if (listenHandler != null) {
                    listenHandler.fail("Could not load inputrc from " + this.options.getIntputrc());
                }
                return this;
            }
            Keymap keymap = new Keymap((InputStream)new ByteArrayInputStream(inputrc.getBytes()));
            this.router.route(this.options.getSockJSPath()).subRouter(SockJSHandler.create((Vertx)this.vertx, (SockJSHandlerOptions)this.options.getSockJSHandlerOptions()).socketHandler((Handler)new SockJSTermHandlerImpl(this.vertx, charset, keymap).termHandler(this.termHandler)));
        }
        if (this.options.getVertsShellJsResource() != null) {
            this.router.get("/vertxshell.js").handler(ctx -> ctx.response().putHeader("Content-Type", "application/javascript").end(this.options.getVertsShellJsResource()));
        }
        if (this.options.getTermJsResource() != null) {
            this.router.get("/term.js").handler(ctx -> ctx.response().putHeader("Content-Type", "application/javascript").end(this.options.getTermJsResource()));
        }
        if (this.options.getShellHtmlResource() != null) {
            this.router.get("/shell.html").handler(ctx -> ctx.response().putHeader("Content-Type", "text/html").end(this.options.getShellHtmlResource()));
        }
        if (createServer) {
            this.server = this.vertx.createHttpServer((HttpServerOptions)this.options);
            this.server.requestHandler((Handler)this.router);
            this.server.listen().onComplete(ar -> {
                if (listenHandler != null) {
                    if (ar.succeeded()) {
                        listenHandler.succeed();
                    } else {
                        listenHandler.fail(ar.cause());
                    }
                }
            });
        } else if (listenHandler != null) {
            listenHandler.succeed();
        }
        return this;
    }

    @Override
    public int actualPort() {
        return this.server.actualPort();
    }

    @Override
    public Future<Void> listen() {
        return Future.future(this::listen);
    }

    @Override
    public Future<Void> close() {
        return Future.future(this::close);
    }

    public void close(Completable<Void> completionHandler) {
        if (this.server != null) {
            this.server.close().onComplete(completionHandler);
            this.server = null;
        } else {
            completionHandler.fail("Not started");
        }
    }
}

