/*
 * Decompiled with CFR 0.152.
 */
package io.vertx.sqlclient.templates.generator;

import io.vertx.codegen.DataObjectModel;
import io.vertx.codegen.Generator;
import io.vertx.codegen.PropertyInfo;
import io.vertx.codegen.PropertyKind;
import io.vertx.codegen.annotations.DataObject;
import io.vertx.codegen.format.CamelCase;
import io.vertx.codegen.format.Case;
import io.vertx.codegen.format.LowerCamelCase;
import io.vertx.codegen.format.SnakeCase;
import io.vertx.codegen.type.AnnotationValueInfo;
import io.vertx.codegen.type.ClassTypeInfo;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.lang.annotation.Annotation;
import java.util.Collection;
import java.util.Collections;
import java.util.EnumSet;
import java.util.Map;
import java.util.Optional;

public abstract class MapperGenBase
extends Generator<DataObjectModel> {
    static final EnumSet<PropertyKind> PK = EnumSet.of(PropertyKind.VALUE, PropertyKind.LIST, PropertyKind.SET);
    private Case formatter;

    public MapperGenBase() {
        this.kinds = Collections.singleton("dataObject");
        this.name = "data_object_mappers";
    }

    public Collection<Class<? extends Annotation>> annotations() {
        return Collections.singletonList(DataObject.class);
    }

    public String filename(DataObjectModel model) {
        if (model.isClass()) {
            return this.getAnnotation(model).map(ann -> model.getType().getPackageName() + "." + this.genSimpleName(model) + ".java").orElse(null);
        }
        return null;
    }

    protected abstract Optional<AnnotationValueInfo> getAnnotation(DataObjectModel var1);

    private Case getCase(DataObjectModel model, String name) {
        AnnotationValueInfo abc = this.getAnnotation(model).get();
        ClassTypeInfo cti = (ClassTypeInfo)abc.getMember(name);
        switch (cti.getName()) {
            case "io.vertx.codegen.format.CamelCase": {
                return CamelCase.INSTANCE;
            }
            case "io.vertx.codegen.format.SnakeCase": {
                return SnakeCase.INSTANCE;
            }
            case "io.vertx.codegen.format.LowerCamelCase": {
                return LowerCamelCase.INSTANCE;
            }
        }
        throw new UnsupportedOperationException();
    }

    protected abstract String genSimpleName(DataObjectModel var1);

    public String render(DataObjectModel model, int index, int size, Map<String, Object> session) {
        StringWriter buffer = new StringWriter();
        PrintWriter writer = new PrintWriter(buffer);
        String visibility = model.isPublicConverter() ? "public" : "";
        this.formatter = this.getCase(model, "formatter");
        writer.print("package " + model.getType().getPackageName() + ";\n");
        writer.print("\n");
        writer.print("/**\n");
        writer.print(" * Mapper for {@link " + model.getType().getSimpleName() + "}.\n");
        writer.print(" * NOTE: This class has been automatically generated from the {@link " + model.getType().getSimpleName() + "} original class using Vert.x codegen.\n");
        writer.print(" */\n");
        this.renderDeclaration(model, writer);
        this.renderMembers(visibility, model, writer);
        writer.print("}\n");
        return buffer.toString();
    }

    protected abstract void renderDeclaration(DataObjectModel var1, PrintWriter var2);

    protected abstract void renderMembers(String var1, DataObjectModel var2, PrintWriter var3);

    protected String getMappingName(PropertyInfo prop, String annotationName) {
        String value;
        AnnotationValueInfo ann = prop.getAnnotation(annotationName);
        if (ann != null && (value = (String)ann.getMember("name")).length() > 0) {
            return value;
        }
        return LowerCamelCase.INSTANCE.to(this.formatter, prop.getName());
    }
}

