/*
 * Decompiled with CFR 0.152.
 */
package io.vertx.sqlclient.impl;

import io.vertx.sqlclient.Row;
import io.vertx.sqlclient.RowIterator;
import io.vertx.sqlclient.RowSet;
import io.vertx.sqlclient.impl.RowInternal;
import io.vertx.sqlclient.impl.SqlResultBase;
import java.util.NoSuchElementException;
import java.util.function.Function;
import java.util.stream.Collector;

class RowSetImpl
extends SqlResultBase<RowSet, RowSetImpl>
implements RowSet {
    static Collector<Row, RowSetImpl, RowSet> COLLECTOR = Collector.of(RowSetImpl::new, (set, row) -> {
        if (set.head == null) {
            set.head = set.tail = (RowInternal)row;
        } else {
            set.tail.setNext((RowInternal)row);
            set.tail = set.tail.getNext();
        }
    }, (set1, set2) -> null, set -> set, new Collector.Characteristics[0]);
    static Function<RowSet, RowSetImpl> FACTORY = rs -> (RowSetImpl)rs;
    private RowInternal head;
    private RowInternal tail;

    RowSetImpl() {
    }

    @Override
    public RowSet value() {
        return this;
    }

    @Override
    public RowIterator iterator() {
        return new RowIterator(){
            RowInternal current;
            {
                this.current = RowSetImpl.this.head;
            }

            @Override
            public boolean hasNext() {
                return this.current != null;
            }

            @Override
            public Row next() {
                if (this.current == null) {
                    throw new NoSuchElementException();
                }
                RowInternal r = this.current;
                this.current = this.current.getNext();
                return r;
            }
        };
    }
}

