/*
 * Decompiled with CFR 0.152.
 */
package io.vertx.sqlclient.impl;

import io.vertx.core.AsyncResult;
import io.vertx.core.Context;
import io.vertx.core.Future;
import io.vertx.core.Handler;
import io.vertx.core.Vertx;
import io.vertx.core.VertxException;
import io.vertx.sqlclient.RowSet;
import io.vertx.sqlclient.Transaction;
import io.vertx.sqlclient.impl.Connection;
import io.vertx.sqlclient.impl.RowSetImpl;
import io.vertx.sqlclient.impl.SqlConnectionBase;
import io.vertx.sqlclient.impl.SqlResultBuilder;
import io.vertx.sqlclient.impl.TxStatus;
import io.vertx.sqlclient.impl.command.CommandBase;
import io.vertx.sqlclient.impl.command.CommandResponse;
import io.vertx.sqlclient.impl.command.QueryCommandBase;
import io.vertx.sqlclient.impl.command.SimpleQueryCommand;
import java.util.ArrayDeque;
import java.util.Deque;

public class TransactionImpl
extends SqlConnectionBase<TransactionImpl>
implements Transaction {
    private static final int ST_BEGIN = 0;
    private static final int ST_PENDING = 1;
    private static final int ST_PROCESSING = 2;
    private static final int ST_COMPLETED = 3;
    private final Handler<Void> disposeHandler;
    private Deque<CommandBase<?>> pending = new ArrayDeque();
    private Handler<Void> failedHandler;
    private int status = 0;

    public TransactionImpl(Context context, Connection conn, Handler<Void> disposeHandler) {
        super(context, conn);
        this.disposeHandler = disposeHandler;
        this.doSchedule(this.doQuery("BEGIN", (Handler<AsyncResult<RowSet>>)((Handler)this::afterBegin)));
    }

    private void doSchedule(CommandBase<?> cmd) {
        if (this.context == Vertx.currentContext()) {
            this.conn.schedule(cmd);
        } else {
            this.context.runOnContext(v -> this.conn.schedule(cmd));
        }
    }

    private synchronized void afterBegin(AsyncResult<?> ar) {
        this.status = ar.succeeded() ? 1 : 3;
        this.checkPending();
    }

    private boolean isComplete(CommandBase<?> cmd) {
        if (cmd instanceof QueryCommandBase) {
            String sql = ((QueryCommandBase)cmd).sql().trim();
            return sql.equalsIgnoreCase("COMMIT") || sql.equalsIgnoreCase("ROLLBACK");
        }
        return false;
    }

    private synchronized void checkPending() {
        switch (this.status) {
            case 0: {
                break;
            }
            case 1: {
                CommandBase<?> cmd = this.pending.poll();
                if (cmd == null) break;
                if (this.isComplete(cmd)) {
                    this.status = 3;
                } else {
                    this.wrap(cmd);
                    this.status = 2;
                }
                this.doSchedule(cmd);
                break;
            }
            case 2: {
                break;
            }
            case 3: {
                CommandBase<?> cmd;
                if (this.pending.size() <= 0) break;
                VertxException err = new VertxException("Transaction already completed");
                while ((cmd = this.pending.poll()) != null) {
                    cmd.fail((Throwable)err);
                }
                break;
            }
        }
    }

    @Override
    public <R> void schedule(CommandBase<R> cmd, Handler<? super CommandResponse<R>> handler) {
        cmd.handler = cr -> {
            cr.scheduler = this;
            handler.handle(cr);
        };
        this.schedule(cmd);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void schedule(CommandBase<?> cmd) {
        TransactionImpl transactionImpl = this;
        synchronized (transactionImpl) {
            this.pending.add(cmd);
        }
        this.checkPending();
    }

    private <T> void wrap(CommandBase<T> cmd) {
        Handler handler = cmd.handler;
        cmd.handler = ar -> {
            TransactionImpl transactionImpl = this;
            synchronized (transactionImpl) {
                this.status = 1;
                if (ar.txStatus() == TxStatus.FAILED) {
                    CommandBase<?> c;
                    while ((c = this.pending.poll()) != null) {
                        c.fail(new RuntimeException("rollback exception"));
                    }
                    Handler<Void> h = this.failedHandler;
                    if (h != null) {
                        this.context.runOnContext(h);
                    }
                    this.schedule(this.doQuery("ROLLBACK", (Handler<AsyncResult<RowSet>>)((Handler)ar2 -> {
                        this.disposeHandler.handle(null);
                        handler.handle(ar);
                    })));
                } else {
                    handler.handle(ar);
                    this.checkPending();
                }
            }
        };
    }

    @Override
    public void commit() {
        this.commit(null);
    }

    @Override
    public void commit(Handler<AsyncResult<Void>> handler) {
        switch (this.status) {
            case 0: 
            case 1: 
            case 2: {
                this.schedule(this.doQuery("COMMIT", (Handler<AsyncResult<RowSet>>)((Handler)ar -> {
                    this.disposeHandler.handle(null);
                    if (handler != null) {
                        if (ar.succeeded()) {
                            handler.handle((Object)Future.succeededFuture());
                        } else {
                            handler.handle((Object)Future.failedFuture((Throwable)ar.cause()));
                        }
                    }
                })));
                break;
            }
            case 3: {
                if (handler == null) break;
                handler.handle((Object)Future.failedFuture((String)"Transaction already completed"));
            }
        }
    }

    @Override
    public void rollback() {
        this.rollback(null);
    }

    @Override
    public void rollback(Handler<AsyncResult<Void>> handler) {
        this.schedule(this.doQuery("ROLLBACK", (Handler<AsyncResult<RowSet>>)((Handler)ar -> {
            this.disposeHandler.handle(null);
            if (handler != null) {
                handler.handle((Object)ar.mapEmpty());
            }
        })));
    }

    @Override
    public void close() {
        this.rollback();
    }

    @Override
    public Transaction abortHandler(Handler<Void> handler) {
        this.failedHandler = handler;
        return this;
    }

    private CommandBase doQuery(String sql, Handler<AsyncResult<RowSet>> handler) {
        SqlResultBuilder<RowSet, RowSetImpl, RowSet> b = new SqlResultBuilder<RowSet, RowSetImpl, RowSet>(RowSetImpl.FACTORY, handler);
        SimpleQueryCommand<RowSet> cmd = new SimpleQueryCommand<RowSet>(sql, false, RowSetImpl.COLLECTOR, b);
        cmd.handler = b;
        return cmd;
    }
}

