/*
 * Decompiled with CFR 0.152.
 */
package io.vertx.sqlclient.impl;

import io.vertx.core.AsyncResult;
import io.vertx.core.Future;
import io.vertx.core.Handler;
import io.vertx.sqlclient.Cursor;
import io.vertx.sqlclient.Row;
import io.vertx.sqlclient.RowSet;
import io.vertx.sqlclient.impl.PreparedQueryImpl;
import io.vertx.sqlclient.impl.RowSetImpl;
import io.vertx.sqlclient.impl.SqlResultBuilder;
import io.vertx.sqlclient.impl.TupleInternal;
import java.util.UUID;

public class CursorImpl
implements Cursor {
    private final PreparedQueryImpl ps;
    private final TupleInternal params;
    private String id;
    private boolean closed;
    private SqlResultBuilder<RowSet<Row>, RowSetImpl<Row>, RowSet<Row>> result;

    CursorImpl(PreparedQueryImpl ps, TupleInternal params) {
        this.ps = ps;
        this.params = params;
    }

    @Override
    public synchronized boolean hasMore() {
        if (this.result == null) {
            throw new IllegalStateException("No current cursor read");
        }
        return this.result.isSuspended();
    }

    @Override
    public synchronized void read(int count, Handler<AsyncResult<RowSet<Row>>> handler) {
        if (this.id == null) {
            this.id = UUID.randomUUID().toString();
            this.result = new SqlResultBuilder<RowSet<Row>, RowSetImpl<Row>, RowSet<Row>>(RowSetImpl.FACTORY, handler);
            this.ps.execute(this.params, count, this.id, false, RowSetImpl.COLLECTOR, this.result, this.result);
        } else if (this.result.isSuspended()) {
            this.result = new SqlResultBuilder<RowSet<Row>, RowSetImpl<Row>, RowSet<Row>>(RowSetImpl.FACTORY, handler);
            this.ps.execute(this.params, count, this.id, true, RowSetImpl.COLLECTOR, this.result, this.result);
        } else {
            throw new IllegalStateException();
        }
    }

    @Override
    public synchronized void close(Handler<AsyncResult<Void>> completionHandler) {
        if (!this.closed) {
            this.closed = true;
            if (this.id == null) {
                completionHandler.handle((Object)Future.succeededFuture());
            } else {
                String id = this.id;
                this.id = null;
                this.result = null;
                this.ps.closeCursor(id, completionHandler);
            }
        }
    }
}

