/*
 * Decompiled with CFR 0.152.
 */
package io.vertx.sqlclient.impl;

import io.vertx.sqlclient.impl.Connection;
import io.vertx.sqlclient.impl.PreparedStatement;
import io.vertx.sqlclient.impl.SocketConnectionBase;
import io.vertx.sqlclient.impl.command.CloseStatementCommand;
import java.util.LinkedHashMap;
import java.util.Map;

class PreparedStatementCache
extends LinkedHashMap<String, SocketConnectionBase.CachedPreparedStatement> {
    private final int capacity;
    private final Connection conn;

    PreparedStatementCache(int capacity, Connection conn) {
        super(capacity, 0.75f, true);
        this.capacity = capacity;
        this.conn = conn;
    }

    @Override
    protected boolean removeEldestEntry(Map.Entry<String, SocketConnectionBase.CachedPreparedStatement> eldest) {
        boolean needRemove = this.size() > this.capacity;
        SocketConnectionBase.CachedPreparedStatement cachedPreparedStatementToRemove = eldest.getValue();
        if (needRemove) {
            if (cachedPreparedStatementToRemove.resp.succeeded()) {
                PreparedStatement statement = (PreparedStatement)cachedPreparedStatementToRemove.resp.result();
                CloseStatementCommand cmd = new CloseStatementCommand(statement);
                cmd.handler = ar -> {};
                this.conn.schedule(cmd);
            }
            return true;
        }
        return false;
    }

    public boolean isReady() {
        Map.Entry<String, SocketConnectionBase.CachedPreparedStatement> entry = this.getEldestEntry();
        if (entry == null) {
            return true;
        }
        return entry.getValue().resp != null;
    }

    public int getCapacity() {
        return this.capacity;
    }

    private Map.Entry<String, SocketConnectionBase.CachedPreparedStatement> getEldestEntry() {
        if (this.size() == 0) {
            return null;
        }
        return (Map.Entry)this.entrySet().toArray()[this.size() - 1];
    }
}

