/*
 * Decompiled with CFR 0.152.
 */
package io.vertx.sqlclient.impl;

import io.vertx.core.AsyncResult;
import io.vertx.core.Future;
import io.vertx.core.Handler;
import io.vertx.core.Vertx;
import io.vertx.sqlclient.Cursor;
import io.vertx.sqlclient.Row;
import io.vertx.sqlclient.RowSet;
import io.vertx.sqlclient.impl.PreparedStatementImpl;
import io.vertx.sqlclient.impl.RowSetImpl;
import io.vertx.sqlclient.impl.SqlResultBuilder;
import io.vertx.sqlclient.impl.SqlResultHandler;
import io.vertx.sqlclient.impl.TupleInternal;
import io.vertx.sqlclient.impl.command.ExtendedQueryCommand;
import java.util.UUID;

public class CursorImpl
implements Cursor {
    private final PreparedStatementImpl ps;
    private final TupleInternal params;
    private String id;
    private boolean closed;
    private SqlResultHandler<RowSet<Row>, RowSetImpl<Row>, RowSet<Row>> result;

    CursorImpl(PreparedStatementImpl ps, TupleInternal params) {
        this.ps = ps;
        this.params = params;
    }

    @Override
    public synchronized boolean hasMore() {
        if (this.result == null) {
            throw new IllegalStateException("No current cursor read");
        }
        return this.result.isSuspended();
    }

    @Override
    public synchronized void read(int count, Handler<AsyncResult<RowSet<Row>>> handler) {
        if (this.ps.context == Vertx.currentContext()) {
            ExtendedQueryCommand<RowSet<Row>> cmd;
            SqlResultBuilder<RowSet<Row>, RowSetImpl<Row>, RowSet<Row>> builder = new SqlResultBuilder<RowSet<Row>, RowSetImpl<Row>, RowSet<Row>>(RowSetImpl.FACTORY, RowSetImpl.COLLECTOR);
            SqlResultHandler<RowSet<Row>, RowSetImpl<Row>, RowSet<Row>> resultHandler = builder.createHandler(handler);
            if (this.id == null) {
                this.id = UUID.randomUUID().toString();
                cmd = builder.createExtendedQuery(this.ps.ps, this.params, count, this.id, false, this.ps.autoCommit, resultHandler);
            } else if (this.result.isSuspended()) {
                cmd = builder.createExtendedQuery(this.ps.ps, this.params, count, this.id, true, this.ps.autoCommit, resultHandler);
            } else {
                throw new IllegalStateException();
            }
            this.result = resultHandler;
            this.ps.conn.schedule(cmd, resultHandler);
        } else {
            this.ps.context.runOnContext(v -> this.read(count, handler));
        }
    }

    @Override
    public synchronized void close(Handler<AsyncResult<Void>> completionHandler) {
        if (!this.closed) {
            this.closed = true;
            if (this.id == null) {
                completionHandler.handle((Object)Future.succeededFuture());
            } else {
                String id = this.id;
                this.id = null;
                this.result = null;
                this.ps.closeCursor(id, completionHandler);
            }
        }
    }
}

