/*
 * Decompiled with CFR 0.152.
 */
package io.vertx.sqlclient.impl;

import io.netty.channel.ChannelHandlerContext;
import io.netty.handler.codec.DecoderException;
import io.vertx.core.AsyncResult;
import io.vertx.core.Context;
import io.vertx.core.Handler;
import io.vertx.core.Vertx;
import io.vertx.core.VertxException;
import io.vertx.core.impl.NetSocketInternal;
import io.vertx.core.logging.Logger;
import io.vertx.core.logging.LoggerFactory;
import io.vertx.sqlclient.impl.Connection;
import io.vertx.sqlclient.impl.Notice;
import io.vertx.sqlclient.impl.Notification;
import io.vertx.sqlclient.impl.PreparedStatement;
import io.vertx.sqlclient.impl.cache.PreparedStatementCache;
import io.vertx.sqlclient.impl.codec.InvalidCachedStatementEvent;
import io.vertx.sqlclient.impl.command.CloseConnectionCommand;
import io.vertx.sqlclient.impl.command.CloseStatementCommand;
import io.vertx.sqlclient.impl.command.CommandBase;
import io.vertx.sqlclient.impl.command.CommandResponse;
import io.vertx.sqlclient.impl.command.PrepareStatementCommand;
import java.util.ArrayDeque;

public abstract class SocketConnectionBase
implements Connection {
    private static final Logger logger = LoggerFactory.getLogger(SocketConnectionBase.class);
    protected final PreparedStatementCache psCache;
    private final int preparedStatementCacheSqlLimit;
    private final ArrayDeque<CommandBase<?>> pending = new ArrayDeque();
    private final Context context;
    private int inflight;
    private Connection.Holder holder;
    private final int pipeliningLimit;
    protected final NetSocketInternal socket;
    protected Status status = Status.CONNECTED;

    public SocketConnectionBase(NetSocketInternal socket, boolean cachePreparedStatements, int preparedStatementCacheSize, int preparedStatementCacheSqlLimit, int pipeliningLimit, Context context) {
        this.socket = socket;
        this.context = context;
        this.pipeliningLimit = pipeliningLimit;
        this.psCache = cachePreparedStatements ? new PreparedStatementCache(this, preparedStatementCacheSize) : null;
        this.preparedStatementCacheSqlLimit = preparedStatementCacheSqlLimit;
    }

    public Context context() {
        return this.context;
    }

    public void init() {
        this.socket.closeHandler(this::handleClosed);
        this.socket.exceptionHandler(this::handleException);
        this.socket.messageHandler(msg -> {
            try {
                this.handleMessage(msg);
            }
            catch (Exception e) {
                this.handleException(e);
            }
        });
    }

    public NetSocketInternal socket() {
        return this.socket;
    }

    @Override
    public boolean isSsl() {
        return this.socket.isSsl();
    }

    @Override
    public void init(Connection.Holder holder) {
        this.holder = holder;
    }

    @Override
    public int getProcessId() {
        throw new UnsupportedOperationException();
    }

    @Override
    public int getSecretKey() {
        throw new UnsupportedOperationException();
    }

    @Override
    public void close(Connection.Holder holder) {
        if (Vertx.currentContext() == this.context) {
            if (this.status == Status.CONNECTED) {
                this.status = Status.CLOSING;
                this.pending.add(CloseConnectionCommand.INSTANCE);
                this.checkPending();
            }
        } else {
            this.context.runOnContext(v -> this.close(holder));
        }
    }

    @Override
    public void schedule(CommandBase<?> cmd) {
        if (cmd.handler == null) {
            throw new IllegalArgumentException();
        }
        if (Vertx.currentContext() != this.context) {
            throw new IllegalStateException();
        }
        PreparedStatementCache psCache = this.psCache;
        if (psCache != null) {
            CloseStatementCommand closeStmtCommand;
            if (cmd instanceof PrepareStatementCommand) {
                PrepareStatementCommand psCmd = (PrepareStatementCommand)cmd;
                if (psCmd.cacheable() && psCmd.sql().length() <= this.preparedStatementCacheSqlLimit) {
                    Handler originalHandler = cmd.handler;
                    Handler<AsyncResult<PreparedStatement>> newHandler = psCache.appendStmtReq(psCmd.sql(), originalHandler);
                    if (newHandler == null) {
                        return;
                    }
                    cmd.handler = newHandler;
                }
            } else if (cmd instanceof CloseStatementCommand && (closeStmtCommand = (CloseStatementCommand)cmd).statement().cacheable()) {
                psCache.remove(closeStmtCommand.statement().sql());
            }
        }
        if (this.status == Status.CONNECTED) {
            this.pending.add(cmd);
            this.checkPending();
        } else {
            cmd.fail((Throwable)new VertxException("Connection not open " + (Object)((Object)this.status)));
        }
    }

    private void checkPending() {
        ChannelHandlerContext ctx = this.socket.channelHandlerContext();
        if (this.inflight < this.pipeliningLimit) {
            CommandBase<?> cmd;
            while (this.inflight < this.pipeliningLimit && (cmd = this.pending.poll()) != null) {
                ++this.inflight;
                ctx.write(cmd);
            }
            ctx.flush();
        }
    }

    public void handleMessage(Object msg) {
        if (msg instanceof CommandResponse) {
            --this.inflight;
            this.checkPending();
            CommandResponse resp = (CommandResponse)msg;
            resp.cmd.handler.handle(msg);
        } else if (msg instanceof Notification) {
            this.handleNotification((Notification)msg);
        } else if (msg instanceof Notice) {
            this.handleNotice((Notice)msg);
        } else if (msg instanceof InvalidCachedStatementEvent) {
            InvalidCachedStatementEvent event = (InvalidCachedStatementEvent)msg;
            this.removeCachedStatement(event.sql());
        }
    }

    private void handleNotification(Notification response) {
        if (this.holder != null) {
            this.holder.handleNotification(response.getProcessId(), response.getChannel(), response.getPayload());
        }
    }

    private void handleNotice(Notice notice) {
        notice.log(logger);
    }

    private void removeCachedStatement(String sql) {
        if (this.psCache != null) {
            this.psCache.remove(sql);
        }
    }

    private void handleClosed(Void v) {
        this.handleClose(null);
    }

    private synchronized void handleException(Throwable t) {
        if (t instanceof DecoderException) {
            DecoderException err = (DecoderException)t;
            t = err.getCause();
        }
        this.handleClose(t);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void handleClose(Throwable t) {
        if (this.status != Status.CLOSED) {
            CommandBase<?> cmd;
            Throwable cause;
            this.status = Status.CLOSED;
            if (t != null) {
                SocketConnectionBase socketConnectionBase = this;
                synchronized (socketConnectionBase) {
                    if (this.holder != null) {
                        this.holder.handleException(t);
                    }
                }
            }
            Throwable throwable = cause = t == null ? new VertxException("closed") : t;
            while ((cmd = this.pending.poll()) != null) {
                CommandBase<?> c = cmd;
                this.context.runOnContext(v -> c.fail(cause));
            }
            if (this.holder != null) {
                this.holder.handleClosed();
            }
        }
    }

    public static enum Status {
        CLOSED,
        CONNECTED,
        CLOSING;

    }
}

