/*
 * Decompiled with CFR 0.152.
 */
package io.vertx.sqlclient.impl.cache;

import io.vertx.core.AsyncResult;
import io.vertx.core.Handler;
import io.vertx.sqlclient.impl.PreparedStatement;
import io.vertx.sqlclient.impl.cache.PreparedStatementCache;
import java.util.ArrayDeque;
import java.util.Deque;

class InflightCachingStmtEntry
implements Handler<AsyncResult<PreparedStatement>> {
    private final Deque<Handler<AsyncResult<PreparedStatement>>> waiters = new ArrayDeque<Handler<AsyncResult<PreparedStatement>>>();
    private final String sql;
    private final PreparedStatementCache psCache;

    InflightCachingStmtEntry(String sql, PreparedStatementCache psCache) {
        this.sql = sql;
        this.psCache = psCache;
    }

    void addWaiter(Handler<AsyncResult<PreparedStatement>> handler) {
        this.waiters.add(handler);
    }

    public void handle(AsyncResult<PreparedStatement> preparedStatementResult) {
        Handler<AsyncResult<PreparedStatement>> waiter;
        if (preparedStatementResult.succeeded()) {
            this.psCache.cache().put(this.sql, preparedStatementResult);
        }
        this.psCache.inflight().remove(this.sql);
        while ((waiter = this.waiters.poll()) != null) {
            waiter.handle(preparedStatementResult);
        }
    }
}

