/*
 * Decompiled with CFR 0.152.
 */
package io.vertx.sqlclient.impl.cache;

import io.vertx.core.AsyncResult;
import io.vertx.core.Handler;
import io.vertx.core.Promise;
import io.vertx.sqlclient.impl.PreparedStatement;
import io.vertx.sqlclient.impl.SocketConnectionBase;
import io.vertx.sqlclient.impl.cache.InflightCachingStmtEntry;
import io.vertx.sqlclient.impl.cache.LruCache;
import io.vertx.sqlclient.impl.command.CloseStatementCommand;
import java.util.HashMap;
import java.util.Map;

public class PreparedStatementCache {
    private final Map<String, InflightCachingStmtEntry> inflight = new HashMap<String, InflightCachingStmtEntry>();
    private final LruCache cache;

    public PreparedStatementCache(SocketConnectionBase conn, int cacheCapacity) {
        Handler onEvictedHandler = stmtAr -> {
            if (stmtAr.succeeded()) {
                CloseStatementCommand cmd = new CloseStatementCommand((PreparedStatement)stmtAr.result());
                conn.schedule(cmd, Promise.promise());
            }
        };
        this.cache = new LruCache(cacheCapacity, (Handler<AsyncResult<PreparedStatement>>)onEvictedHandler);
    }

    public Handler<AsyncResult<PreparedStatement>> appendStmtReq(String sql, Handler<AsyncResult<PreparedStatement>> originalHandler) {
        AsyncResult preparedStmtCachedResult = (AsyncResult)this.cache.get(sql);
        if (preparedStmtCachedResult != null) {
            originalHandler.handle((Object)preparedStmtCachedResult);
            return null;
        }
        InflightCachingStmtEntry inflightCachingStmtEntry = this.inflight.get(sql);
        if (inflightCachingStmtEntry != null) {
            inflightCachingStmtEntry.addWaiter(originalHandler);
            return null;
        }
        InflightCachingStmtEntry newEntry = new InflightCachingStmtEntry(sql, this);
        newEntry.addWaiter(originalHandler);
        this.inflight.put(sql, newEntry);
        return newEntry;
    }

    public void remove(String sql) {
        this.inflight.remove(sql);
        this.cache.remove(sql);
    }

    LruCache cache() {
        return this.cache;
    }

    Map<String, InflightCachingStmtEntry> inflight() {
        return this.inflight;
    }
}

