/*
 * Decompiled with CFR 0.152.
 */
package io.vertx.sqlclient;

import io.netty.buffer.ByteBuf;
import io.vertx.codegen.annotations.Fluent;
import io.vertx.codegen.annotations.GenIgnore;
import io.vertx.codegen.annotations.VertxGen;
import io.vertx.core.buffer.Buffer;
import io.vertx.sqlclient.data.Numeric;
import io.vertx.sqlclient.impl.ArrayTuple;
import io.vertx.sqlclient.impl.ListTuple;
import java.math.BigDecimal;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.time.LocalTime;
import java.time.OffsetDateTime;
import java.time.OffsetTime;
import java.time.temporal.Temporal;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.UUID;

@VertxGen
public interface Tuple {
    public static final Object JSON_NULL = new Object();

    public static Tuple tuple() {
        return new ArrayTuple(10);
    }

    public static Tuple wrap(List<Object> list) {
        return new ListTuple(list);
    }

    @GenIgnore(value={"permitted-type"})
    public static Tuple wrap(Object ... array) {
        return new ListTuple(Arrays.asList(array));
    }

    public static Tuple of(Object elt1) {
        ArrayTuple tuple = new ArrayTuple(1);
        tuple.addValue(elt1);
        return tuple;
    }

    public static Tuple of(Object elt1, Object elt2) {
        ArrayTuple tuple = new ArrayTuple(2);
        tuple.addValue(elt1);
        tuple.addValue(elt2);
        return tuple;
    }

    public static Tuple of(Object elt1, Object elt2, Object elt3) {
        ArrayTuple tuple = new ArrayTuple(3);
        tuple.addValue(elt1);
        tuple.addValue(elt2);
        tuple.addValue(elt3);
        return tuple;
    }

    public static Tuple of(Object elt1, Object elt2, Object elt3, Object elt4) {
        ArrayTuple tuple = new ArrayTuple(4);
        tuple.addValue(elt1);
        tuple.addValue(elt2);
        tuple.addValue(elt3);
        tuple.addValue(elt4);
        return tuple;
    }

    public static Tuple of(Object elt1, Object elt2, Object elt3, Object elt4, Object elt5) {
        ArrayTuple tuple = new ArrayTuple(5);
        tuple.addValue(elt1);
        tuple.addValue(elt2);
        tuple.addValue(elt3);
        tuple.addValue(elt4);
        tuple.addValue(elt5);
        return tuple;
    }

    public static Tuple of(Object elt1, Object elt2, Object elt3, Object elt4, Object elt5, Object elt6) {
        ArrayTuple tuple = new ArrayTuple(5);
        tuple.addValue(elt1);
        tuple.addValue(elt2);
        tuple.addValue(elt3);
        tuple.addValue(elt4);
        tuple.addValue(elt5);
        tuple.addValue(elt6);
        return tuple;
    }

    @GenIgnore
    public static Tuple of(Object elt1, Object ... elts) {
        ArrayTuple tuple = new ArrayTuple(1 + elts.length);
        tuple.addValue(elt1);
        for (Object elt : elts) {
            tuple.addValue(elt);
        }
        return tuple;
    }

    public static Tuple tuple(List<Object> elements) {
        return new ArrayTuple(elements);
    }

    public Object getValue(int var1);

    default public Boolean getBoolean(int pos) {
        return (Boolean)this.getValue(pos);
    }

    default public Short getShort(int pos) {
        Object val = this.getValue(pos);
        if (val == null) {
            return null;
        }
        if (val instanceof Short) {
            return (Short)val;
        }
        if (val instanceof Number) {
            return ((Number)val).shortValue();
        }
        return (Short)val;
    }

    default public Integer getInteger(int pos) {
        Object val = this.getValue(pos);
        if (val == null) {
            return null;
        }
        if (val instanceof Integer) {
            return (Integer)val;
        }
        if (val instanceof Number) {
            return ((Number)val).intValue();
        }
        return (Integer)val;
    }

    default public Long getLong(int pos) {
        Object val = this.getValue(pos);
        if (val == null) {
            return null;
        }
        if (val instanceof Long) {
            return (Long)val;
        }
        if (val instanceof Number) {
            return ((Number)val).longValue();
        }
        return (Long)val;
    }

    default public Float getFloat(int pos) {
        Object val = this.getValue(pos);
        if (val == null) {
            return null;
        }
        if (val instanceof Float) {
            return (Float)val;
        }
        if (val instanceof Number) {
            return Float.valueOf(((Number)val).floatValue());
        }
        return (Float)val;
    }

    default public Double getDouble(int pos) {
        Object val = this.getValue(pos);
        if (val == null) {
            return null;
        }
        if (val instanceof Double) {
            return (Double)val;
        }
        if (val instanceof Number) {
            return ((Number)val).doubleValue();
        }
        return (Double)val;
    }

    @GenIgnore(value={"permitted-type"})
    default public Numeric getNumeric(int pos) {
        Object val = this.getValue(pos);
        if (val == null) {
            return null;
        }
        if (val instanceof Numeric) {
            return (Numeric)val;
        }
        if (val instanceof Number) {
            return Numeric.parse(val.toString());
        }
        return (Numeric)val;
    }

    default public String getString(int pos) {
        return (String)this.getValue(pos);
    }

    @GenIgnore(value={"permitted-type"})
    default public Temporal getTemporal(int pos) {
        return (Temporal)this.getValue(pos);
    }

    @GenIgnore(value={"permitted-type"})
    default public LocalDate getLocalDate(int pos) {
        return (LocalDate)this.getValue(pos);
    }

    @GenIgnore(value={"permitted-type"})
    default public LocalTime getLocalTime(int pos) {
        return (LocalTime)this.getValue(pos);
    }

    @GenIgnore(value={"permitted-type"})
    default public LocalDateTime getLocalDateTime(int pos) {
        return (LocalDateTime)this.getValue(pos);
    }

    @GenIgnore(value={"permitted-type"})
    default public OffsetTime getOffsetTime(int pos) {
        return (OffsetTime)this.getValue(pos);
    }

    @GenIgnore(value={"permitted-type"})
    default public OffsetDateTime getOffsetDateTime(int pos) {
        return (OffsetDateTime)this.getValue(pos);
    }

    default public Buffer getBuffer(int pos) {
        Object val = this.getValue(pos);
        if (val == null) {
            return null;
        }
        if (val instanceof Buffer) {
            return (Buffer)val;
        }
        if (val instanceof ByteBuf) {
            return Buffer.buffer((ByteBuf)((ByteBuf)val));
        }
        if (val instanceof byte[]) {
            return Buffer.buffer((byte[])((byte[])val));
        }
        return (Buffer)val;
    }

    @GenIgnore(value={"permitted-type"})
    default public UUID getUUID(int pos) {
        Object val = this.getValue(pos);
        if (val == null) {
            return null;
        }
        if (val instanceof UUID) {
            return (UUID)val;
        }
        if (val instanceof String) {
            return UUID.fromString((String)val);
        }
        return (UUID)val;
    }

    @GenIgnore(value={"permitted-type"})
    default public BigDecimal getBigDecimal(int pos) {
        Object val = this.getValue(pos);
        if (val == null) {
            return null;
        }
        if (val instanceof BigDecimal) {
            return (BigDecimal)val;
        }
        if (val instanceof Number) {
            return new BigDecimal(val.toString());
        }
        return (BigDecimal)val;
    }

    @GenIgnore(value={"permitted-type"})
    default public Boolean[] getBooleanArray(int pos) {
        return (Boolean[])this.getValue(pos);
    }

    @GenIgnore(value={"permitted-type"})
    default public Short[] getShortArray(int pos) {
        return (Short[])this.getValue(pos);
    }

    @GenIgnore(value={"permitted-type"})
    default public Integer[] getIntegerArray(int pos) {
        return (Integer[])this.getValue(pos);
    }

    @GenIgnore(value={"permitted-type"})
    default public Long[] getLongArray(int pos) {
        return (Long[])this.getValue(pos);
    }

    @GenIgnore(value={"permitted-type"})
    default public Float[] getFloatArray(int pos) {
        return (Float[])this.getValue(pos);
    }

    @GenIgnore(value={"permitted-type"})
    default public Double[] getDoubleArray(int pos) {
        return (Double[])this.getValue(pos);
    }

    @GenIgnore(value={"permitted-type"})
    default public Numeric[] getNumericArray(int pos) {
        return (Numeric[])this.getValue(pos);
    }

    @GenIgnore(value={"permitted-type"})
    default public String[] getStringArray(int pos) {
        return (String[])this.getValue(pos);
    }

    @GenIgnore(value={"permitted-type"})
    default public Temporal[] getTemporalArray(int pos) {
        return (Temporal[])this.getValue(pos);
    }

    @GenIgnore(value={"permitted-type"})
    default public LocalDate[] getLocalDateArray(int pos) {
        return (LocalDate[])this.getValue(pos);
    }

    @GenIgnore(value={"permitted-type"})
    default public LocalTime[] getLocalTimeArray(int pos) {
        return (LocalTime[])this.getValue(pos);
    }

    @GenIgnore(value={"permitted-type"})
    default public LocalDateTime[] getLocalDateTimeArray(int pos) {
        return (LocalDateTime[])this.getValue(pos);
    }

    @GenIgnore(value={"permitted-type"})
    default public OffsetTime[] getOffsetTimeArray(int pos) {
        return (OffsetTime[])this.getValue(pos);
    }

    @GenIgnore(value={"permitted-type"})
    default public OffsetDateTime[] getOffsetDateTimeArray(int pos) {
        return (OffsetDateTime[])this.getValue(pos);
    }

    @GenIgnore
    default public Buffer[] getBufferArray(int pos) {
        return (Buffer[])this.getValue(pos);
    }

    @GenIgnore(value={"permitted-type"})
    default public UUID[] getUUIDArray(int pos) {
        return (UUID[])this.getValue(pos);
    }

    @GenIgnore(value={"permitted-type"})
    default public BigDecimal[] getBigDecimalArray(int pos) {
        return (BigDecimal[])this.getValue(pos);
    }

    @Fluent
    public Tuple addValue(Object var1);

    @Fluent
    default public Tuple addBoolean(Boolean value) {
        return this.addValue(value);
    }

    @Fluent
    default public Tuple addShort(Short value) {
        return this.addValue(value);
    }

    @Fluent
    default public Tuple addInteger(Integer value) {
        return this.addValue(value);
    }

    @Fluent
    default public Tuple addLong(Long value) {
        return this.addValue(value);
    }

    @Fluent
    default public Tuple addFloat(Float value) {
        return this.addValue(value);
    }

    @Fluent
    default public Tuple addDouble(Double value) {
        return this.addValue(value);
    }

    @Fluent
    default public Tuple addString(String value) {
        return this.addValue(value);
    }

    @GenIgnore(value={"permitted-type"})
    default public Tuple addTemporal(Temporal value) {
        return this.addValue(value);
    }

    @GenIgnore(value={"permitted-type"})
    default public Tuple addLocalDate(LocalDate value) {
        return this.addValue(value);
    }

    @GenIgnore(value={"permitted-type"})
    default public Tuple addLocalTime(LocalTime value) {
        return this.addValue(value);
    }

    @GenIgnore(value={"permitted-type"})
    default public Tuple addLocalDateTime(LocalDateTime value) {
        return this.addValue(value);
    }

    @GenIgnore(value={"permitted-type"})
    default public Tuple addOffsetTime(OffsetTime value) {
        return this.addValue(value);
    }

    @GenIgnore(value={"permitted-type"})
    default public Tuple addOffsetDateTime(OffsetDateTime value) {
        return this.addValue(value);
    }

    @Fluent
    default public Tuple addBuffer(Buffer value) {
        return this.addValue(value);
    }

    @GenIgnore(value={"permitted-type"})
    default public Tuple addUUID(UUID value) {
        return this.addValue(value);
    }

    @GenIgnore(value={"permitted-type"})
    default public Tuple addBigDecimal(BigDecimal value) {
        return this.addValue(value);
    }

    @GenIgnore(value={"permitted-type"})
    default public Tuple addBooleanArray(Boolean[] value) {
        return this.addValue(value);
    }

    @GenIgnore(value={"permitted-type"})
    default public Tuple addShortArray(Short[] value) {
        return this.addValue(value);
    }

    @GenIgnore(value={"permitted-type"})
    default public Tuple addIntegerArray(Integer[] value) {
        return this.addValue(value);
    }

    @GenIgnore(value={"permitted-type"})
    default public Tuple addLongArray(Long[] value) {
        return this.addValue(value);
    }

    @GenIgnore(value={"permitted-type"})
    default public Tuple addFloatArray(Float[] value) {
        return this.addValue(value);
    }

    @GenIgnore(value={"permitted-type"})
    default public Tuple addDoubleArray(Double[] value) {
        return this.addValue(value);
    }

    @GenIgnore(value={"permitted-type"})
    default public Tuple addStringArray(String[] value) {
        return this.addValue(value);
    }

    @GenIgnore(value={"permitted-type"})
    default public Tuple addTemporalArray(Temporal[] value) {
        return this.addValue(value);
    }

    @GenIgnore(value={"permitted-type"})
    default public Tuple addLocalDateArray(LocalDate[] value) {
        return this.addValue(value);
    }

    @GenIgnore(value={"permitted-type"})
    default public Tuple addLocalTimeArray(LocalTime[] value) {
        return this.addValue(value);
    }

    @GenIgnore(value={"permitted-type"})
    default public Tuple addLocalDateTimeArray(LocalDateTime[] value) {
        return this.addValue(value);
    }

    @GenIgnore(value={"permitted-type"})
    default public Tuple addOffsetTimeArray(OffsetTime[] value) {
        return this.addValue(value);
    }

    @GenIgnore(value={"permitted-type"})
    default public Tuple addOffsetDateTimeArray(OffsetDateTime[] value) {
        return this.addValue(value);
    }

    @GenIgnore
    default public Tuple addBufferArray(Buffer[] value) {
        return this.addValue(value);
    }

    @GenIgnore(value={"permitted-type"})
    default public Tuple addUUIDArray(UUID[] value) {
        return this.addValue(value);
    }

    @GenIgnore(value={"permitted-type"})
    default public Tuple addBigDecimalArray(BigDecimal[] value) {
        return this.addValue(value);
    }

    default public <T> T get(Class<T> type, int pos) {
        if (type == null) {
            throw new IllegalArgumentException("Accessor type can not be null");
        }
        Object value = this.getValue(pos);
        if (value.getClass() == type) {
            return type.cast(value);
        }
        try {
            if (value instanceof Buffer) {
                return type.cast(value);
            }
            if (value instanceof Temporal) {
                return type.cast(value);
            }
        }
        catch (ClassCastException e) {
            throw new IllegalArgumentException("mismatched type [" + type.getName() + "] for the value of type [" + value.getClass().getName() + "]");
        }
        throw new IllegalArgumentException("mismatched type [" + type.getName() + "] for the value of type [" + value.getClass().getName() + "]");
    }

    @GenIgnore
    default public <T> T[] getValues(Class<T> type, int pos) {
        if (type == null) {
            throw new IllegalArgumentException("Accessor type can not be null");
        }
        Object value = this.getValue(pos);
        if (value.getClass().isArray() && value.getClass().getComponentType() == type) {
            return (Object[])value;
        }
        throw new IllegalArgumentException("mismatched array element type [" + type.getName() + "] for the value of type [" + value.getClass().getName() + "]");
    }

    @GenIgnore
    default public <T> Tuple addValues(T[] value) {
        return this.addValue(value);
    }

    public int size();

    public void clear();

    @GenIgnore
    default public List<Class<?>> types() {
        int len = this.size();
        ArrayList types = new ArrayList();
        for (int i = 0; i < len; ++i) {
            Object param = this.getValue(i);
            if (param == null) {
                types.add(Object.class);
                continue;
            }
            types.add(param.getClass());
        }
        return types;
    }

    default public String deepToString() {
        StringBuilder sb = new StringBuilder();
        sb.append("[");
        int size = this.size();
        for (int i = 0; i < size; ++i) {
            sb.append(this.getValue(i));
            if (i + 1 >= size) continue;
            sb.append(",");
        }
        sb.append("]");
        return sb.toString();
    }
}

