/*
 * Decompiled with CFR 0.152.
 */
package io.vertx.sqlclient.impl;

import io.vertx.sqlclient.Query;
import io.vertx.sqlclient.Row;
import io.vertx.sqlclient.RowSet;
import io.vertx.sqlclient.SqlResult;
import io.vertx.sqlclient.impl.RowSetImpl;
import io.vertx.sqlclient.impl.SqlResultBuilder;
import io.vertx.sqlclient.impl.SqlResultImpl;
import java.util.Objects;
import java.util.function.Function;
import java.util.stream.Collector;

abstract class QueryBase<T, R extends SqlResult<T>>
implements Query<R> {
    protected final SqlResultBuilder<T, ?, R> builder;

    public QueryBase(SqlResultBuilder<T, ?, R> builder) {
        this.builder = builder;
    }

    protected abstract <T2, R2 extends SqlResult<T2>> QueryBase<T2, R2> copy(SqlResultBuilder<T2, ?, R2> var1);

    @Override
    public <U> Query<SqlResult<U>> collecting(Collector<Row, ?, U> collector) {
        Objects.requireNonNull(collector, "Supplied collector must not be null");
        return this.copy(new SqlResultBuilder(SqlResultImpl::new, collector));
    }

    @Override
    public <U> Query<RowSet<U>> mapping(Function<Row, U> mapper) {
        Objects.requireNonNull(mapper, "Supplied mapper must not be null");
        return this.copy(new SqlResultBuilder(RowSetImpl.factory(), RowSetImpl.collector(mapper)));
    }
}

