/*
 * Decompiled with CFR 0.152.
 */
package io.vertx.sqlclient.impl;

import io.vertx.core.AsyncResult;
import io.vertx.core.Context;
import io.vertx.core.Handler;
import io.vertx.core.Vertx;
import io.vertx.sqlclient.SqlConnection;
import io.vertx.sqlclient.Transaction;
import io.vertx.sqlclient.impl.Connection;
import io.vertx.sqlclient.impl.SqlConnectionBase;
import io.vertx.sqlclient.impl.TransactionImpl;
import io.vertx.sqlclient.impl.command.CommandBase;
import io.vertx.sqlclient.impl.command.CommandResponse;
import io.vertx.sqlclient.spi.DatabaseMetadata;

public abstract class SqlConnectionImpl<C extends SqlConnectionImpl>
extends SqlConnectionBase<C>
implements SqlConnection,
Connection.Holder {
    private volatile Handler<Throwable> exceptionHandler;
    private volatile Handler<Void> closeHandler;
    private TransactionImpl tx;

    public SqlConnectionImpl(Context context, Connection conn) {
        super(context, conn);
    }

    @Override
    public void handleClosed() {
        Handler<Void> handler = this.closeHandler;
        if (handler != null) {
            this.context.runOnContext(handler);
        }
    }

    @Override
    public <R> void schedule(CommandBase<R> cmd, Handler<? super CommandResponse<R>> handler) {
        cmd.handler = handler;
        this.schedule(cmd);
    }

    protected void schedule(CommandBase<?> cmd) {
        if (this.context == Vertx.currentContext()) {
            if (this.tx != null) {
                this.tx.schedule(cmd);
            } else {
                this.conn.schedule(cmd);
            }
        } else {
            this.context.runOnContext(v -> this.schedule(cmd));
        }
    }

    @Override
    public void handleException(Throwable err) {
        Handler<Throwable> handler = this.exceptionHandler;
        if (handler != null) {
            this.context.runOnContext(v -> handler.handle((Object)err));
        } else {
            err.printStackTrace();
        }
    }

    @Override
    public boolean isSSL() {
        return this.conn.isSsl();
    }

    @Override
    public DatabaseMetadata databaseMetadata() {
        return this.conn.getDatabaseMetaData();
    }

    public C closeHandler(Handler<Void> handler) {
        this.closeHandler = handler;
        return (C)this;
    }

    public C exceptionHandler(Handler<Throwable> handler) {
        this.exceptionHandler = handler;
        return (C)this;
    }

    @Override
    public Transaction begin() {
        return this.begin(false);
    }

    public Transaction begin(boolean closeOnEnd) {
        if (this.tx != null) {
            throw new IllegalStateException();
        }
        this.tx = new TransactionImpl(this.context, this.conn, (Handler<Void>)((Handler)v -> {
            this.tx = null;
            if (closeOnEnd) {
                this.close();
            }
        }));
        return this.tx;
    }

    @Override
    public abstract void handleNotification(int var1, String var2, String var3);

    @Override
    public void close() {
        if (this.context == Vertx.currentContext()) {
            if (this.tx != null) {
                this.tx.rollback((Handler<AsyncResult<Void>>)((Handler)ar -> this.conn.close(this)));
                this.tx = null;
            } else {
                this.conn.close(this);
            }
        } else {
            this.context.runOnContext(v -> this.close());
        }
    }
}

