/*
 * Decompiled with CFR 0.152.
 */
package io.vertx.sqlclient.impl;

import io.vertx.core.AsyncResult;
import io.vertx.core.Handler;
import io.vertx.sqlclient.Row;
import io.vertx.sqlclient.SqlResult;
import io.vertx.sqlclient.Tuple;
import io.vertx.sqlclient.impl.PreparedStatement;
import io.vertx.sqlclient.impl.SqlResultBase;
import io.vertx.sqlclient.impl.SqlResultHandler;
import io.vertx.sqlclient.impl.command.ExtendedQueryCommand;
import io.vertx.sqlclient.impl.command.SimpleQueryCommand;
import java.util.List;
import java.util.function.Function;
import java.util.stream.Collector;

class SqlResultBuilder<T, R extends SqlResultBase<T, R>, L extends SqlResult<T>> {
    private final Function<T, R> factory;
    private final Collector<Row, ?, T> collector;

    public SqlResultBuilder(Function<T, R> factory, Collector<Row, ?, T> collector) {
        this.factory = factory;
        this.collector = collector;
    }

    SqlResultHandler<T, R, L> createHandler(Handler<AsyncResult<L>> resultHandler) {
        return new SqlResultHandler<T, R, L>(this.factory, resultHandler);
    }

    SimpleQueryCommand<T> createSimpleQuery(String sql, boolean singleton, boolean autoCommit, SqlResultHandler<T, R, L> handler) {
        return new SimpleQueryCommand<T>(sql, singleton, autoCommit, this.collector, handler);
    }

    ExtendedQueryCommand<T> createExtendedQuery(String sql, Tuple args, boolean autoCommit, SqlResultHandler<T, R, L> handler) {
        return ExtendedQueryCommand.createQuery(sql, null, args, autoCommit, this.collector, handler);
    }

    ExtendedQueryCommand<T> createExtendedQuery(PreparedStatement preparedStatement, Tuple args, int fetch, String cursorId, boolean suspended, boolean autoCommit, SqlResultHandler<T, R, L> handler) {
        return ExtendedQueryCommand.createQuery(preparedStatement.sql(), preparedStatement, args, fetch, cursorId, suspended, autoCommit, this.collector, handler);
    }

    ExtendedQueryCommand<T> createBatchCommand(PreparedStatement preparedStatement, List<Tuple> argsList, boolean autoCommit, SqlResultHandler<T, R, L> handler) {
        return ExtendedQueryCommand.createBatch(preparedStatement.sql(), preparedStatement, argsList, autoCommit, this.collector, handler);
    }

    ExtendedQueryCommand<T> createBatchCommand(String sql, List<Tuple> argsList, boolean autoCommit, SqlResultHandler<T, R, L> handler) {
        return ExtendedQueryCommand.createBatch(sql, null, argsList, autoCommit, this.collector, handler);
    }
}

