/*
 * Decompiled with CFR 0.152.
 */
package io.vertx.sqlclient.impl;

import io.vertx.core.AsyncResult;
import io.vertx.core.Context;
import io.vertx.core.Handler;
import io.vertx.core.Vertx;
import io.vertx.core.VertxException;
import io.vertx.sqlclient.Transaction;
import io.vertx.sqlclient.impl.Connection;
import io.vertx.sqlclient.impl.QueryResultHandler;
import io.vertx.sqlclient.impl.SqlConnectionBase;
import io.vertx.sqlclient.impl.command.CommandBase;
import io.vertx.sqlclient.impl.command.CommandResponse;
import io.vertx.sqlclient.impl.command.QueryCommandBase;
import io.vertx.sqlclient.impl.command.SimpleQueryCommand;
import java.util.ArrayDeque;
import java.util.Deque;

public class TransactionImpl
extends SqlConnectionBase<TransactionImpl>
implements Transaction {
    private static final int ST_BEGIN = 0;
    private static final int ST_PENDING = 1;
    private static final int ST_PROCESSING = 2;
    private static final int ST_COMPLETED = 3;
    private final Handler<Void> disposeHandler;
    private final Deque<CommandBase<?>> pending = new ArrayDeque();
    private Handler<Void> abortHandler;
    private int status = 0;

    public TransactionImpl(Context context, Connection conn, Handler<Void> disposeHandler) {
        super(context, conn);
        this.disposeHandler = disposeHandler;
        this.doSchedule(this.wrapCommandHandler(this.createQueryCommand("BEGIN", this::afterBegin)));
    }

    private void doSchedule(CommandBase<?> cmd) {
        if (this.context == Vertx.currentContext()) {
            this.conn.schedule(cmd);
        } else {
            this.context.runOnContext(v -> this.conn.schedule(cmd));
        }
    }

    private synchronized void afterBegin(AsyncResult<?> ar) {
        this.status = ar.succeeded() ? 1 : 3;
        this.checkPending();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void checkPending() {
        while (true) {
            CommandBase<?> cmd;
            TransactionImpl transactionImpl = this;
            synchronized (transactionImpl) {
                switch (this.status) {
                    case 1: {
                        cmd = this.pending.poll();
                        if (cmd != null) {
                            this.status = 2;
                            this.doSchedule(cmd);
                        }
                        return;
                    }
                    case 3: {
                        cmd = this.pending.poll();
                        if (cmd != null) break;
                        return;
                    }
                    default: {
                        return;
                    }
                }
            }
            VertxException err = new VertxException("Transaction already completed", false);
            cmd.fail((Throwable)err);
        }
    }

    @Override
    public <R> void schedule(CommandBase<R> cmd, Handler<? super CommandResponse<R>> handler) {
        cmd.handler = handler;
        this.schedule(cmd);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void schedule(CommandBase<?> cmd) {
        this.wrapCommandHandler(cmd);
        TransactionImpl transactionImpl = this;
        synchronized (transactionImpl) {
            this.pending.add(cmd);
        }
        this.checkPending();
    }

    @Override
    public void commit() {
        this.commit(null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void commit(Handler<AsyncResult<Void>> handler) {
        TransactionImpl transactionImpl = this;
        synchronized (transactionImpl) {
            this.pending.add(this.createQueryCommand("COMMIT", ar -> {
                this.tryComplete();
                if (handler != null) {
                    handler.handle((Object)ar.mapEmpty());
                }
            }));
        }
        this.checkPending();
    }

    @Override
    public void rollback() {
        this.rollback(null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void rollback(Handler<AsyncResult<Void>> completionHandler) {
        TransactionImpl transactionImpl = this;
        synchronized (transactionImpl) {
            CommandBase<?> cmd = this.createQueryCommand("ROLLBACK", ar -> {
                if (this.tryComplete()) {
                    Handler<Void> handler;
                    TransactionImpl transactionImpl = this;
                    synchronized (transactionImpl) {
                        handler = this.abortHandler;
                    }
                    if (handler != null) {
                        handler.handle(null);
                    }
                }
                if (completionHandler != null) {
                    completionHandler.handle((Object)ar.mapEmpty());
                }
            });
            this.pending.addFirst(cmd);
        }
        this.checkPending();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean tryComplete() {
        TransactionImpl transactionImpl = this;
        synchronized (transactionImpl) {
            if (this.status == 3) {
                return false;
            }
            this.status = 3;
        }
        this.disposeHandler.handle(null);
        this.checkPending();
        return true;
    }

    @Override
    public void close() {
        this.rollback();
    }

    @Override
    public synchronized Transaction abortHandler(Handler<Void> handler) {
        this.abortHandler = handler;
        return this;
    }

    private <T> CommandBase<T> wrapCommandHandler(CommandBase<T> cmd) {
        Handler handler = cmd.handler;
        cmd.handler = ar -> {
            TransactionImpl transactionImpl = this;
            synchronized (transactionImpl) {
                if (this.status == 2) {
                    this.status = 1;
                }
            }
            if (ar.toAsyncResult().failed()) {
                this.rollback((Handler<AsyncResult<Void>>)((Handler)a -> handler.handle(ar)));
            } else {
                handler.handle(ar);
                this.checkPending();
            }
        };
        return cmd;
    }

    private CommandBase<?> createQueryCommand(String sql, Handler<AsyncResult<?>> handler) {
        SimpleQueryCommand<Void> cmd = new SimpleQueryCommand<Void>(sql, false, this.autoCommit(), QueryCommandBase.NULL_COLLECTOR, QueryResultHandler.NOOP_HANDLER);
        cmd.handler = handler;
        return cmd;
    }

    @Override
    boolean autoCommit() {
        return false;
    }
}

