/*
 * Decompiled with CFR 0.152.
 */
package io.vertx.sqlclient.impl;

import io.vertx.core.AsyncResult;
import io.vertx.core.Future;
import io.vertx.core.Handler;
import io.vertx.sqlclient.Cursor;
import io.vertx.sqlclient.Row;
import io.vertx.sqlclient.RowSet;
import io.vertx.sqlclient.impl.Connection;
import io.vertx.sqlclient.impl.PreparedStatement;
import io.vertx.sqlclient.impl.PreparedStatementImpl;
import io.vertx.sqlclient.impl.RowSetImpl;
import io.vertx.sqlclient.impl.SqlResultBuilder;
import io.vertx.sqlclient.impl.SqlResultHandler;
import io.vertx.sqlclient.impl.TupleInternal;
import io.vertx.sqlclient.impl.command.ExtendedQueryCommand;
import java.util.UUID;

public class CursorImpl
implements Cursor {
    private final PreparedStatementImpl ps;
    private final Connection conn;
    private final boolean autoCommit;
    private final TupleInternal params;
    private String id;
    private boolean closed;
    private SqlResultHandler<RowSet<Row>, RowSetImpl<Row>, RowSet<Row>> result;

    CursorImpl(PreparedStatementImpl ps, Connection conn, boolean autoCommit, TupleInternal params) {
        this.ps = ps;
        this.conn = conn;
        this.autoCommit = autoCommit;
        this.params = params;
    }

    @Override
    public synchronized boolean hasMore() {
        if (this.result == null) {
            throw new IllegalStateException("No current cursor read");
        }
        return this.result.isSuspended();
    }

    @Override
    public synchronized void read(int count, Handler<AsyncResult<RowSet<Row>>> handler) {
        this.ps.withPreparedStatement(this.params, (Handler<AsyncResult<PreparedStatement>>)((Handler)ar -> {
            if (ar.succeeded()) {
                ExtendedQueryCommand<RowSet<Row>> cmd;
                PreparedStatement preparedStatement = (PreparedStatement)ar.result();
                SqlResultBuilder builder = new SqlResultBuilder(RowSetImpl.FACTORY, RowSetImpl.COLLECTOR);
                SqlResultHandler resultHandler = builder.createHandler(handler);
                if (this.id == null) {
                    String msg = preparedStatement.prepare(this.params);
                    if (msg != null) {
                        handler.handle((Object)Future.failedFuture((String)msg));
                        return;
                    }
                    this.id = UUID.randomUUID().toString();
                    cmd = builder.createExtendedQuery(preparedStatement, this.params, count, this.id, false, this.autoCommit, resultHandler);
                } else if (this.result.isSuspended()) {
                    cmd = builder.createExtendedQuery(preparedStatement, this.params, count, this.id, true, this.autoCommit, resultHandler);
                } else {
                    throw new IllegalStateException();
                }
                this.result = resultHandler;
                this.conn.schedule(cmd, resultHandler);
            } else {
                handler.handle((Object)Future.failedFuture((Throwable)ar.cause()));
            }
        }));
    }

    @Override
    public synchronized boolean isClosed() {
        return this.closed;
    }

    @Override
    public synchronized void close(Handler<AsyncResult<Void>> completionHandler) {
        if (!this.closed) {
            this.closed = true;
            if (this.id == null) {
                completionHandler.handle((Object)Future.succeededFuture());
            } else {
                String id = this.id;
                this.id = null;
                this.result = null;
                this.ps.closeCursor(id, completionHandler);
            }
        }
    }
}

