/*
 * Decompiled with CFR 0.152.
 */
package io.vertx.sqlclient;

import io.vertx.codegen.annotations.GenIgnore;
import io.vertx.codegen.annotations.VertxGen;
import io.vertx.core.buffer.Buffer;
import io.vertx.core.json.JsonArray;
import io.vertx.core.json.JsonObject;
import io.vertx.sqlclient.Tuple;
import io.vertx.sqlclient.impl.Utils;
import java.math.BigDecimal;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.time.LocalTime;
import java.time.OffsetDateTime;
import java.time.OffsetTime;
import java.time.temporal.Temporal;
import java.util.UUID;

@VertxGen
public interface Row
extends Tuple {
    public String getColumnName(int var1);

    public int getColumnIndex(String var1);

    default public Object getValue(String name) {
        int pos = this.getColumnIndex(name);
        return pos == -1 ? null : this.getValue(pos);
    }

    default public Boolean getBoolean(String name) {
        int pos = this.getColumnIndex(name);
        return pos == -1 ? null : this.getBoolean(pos);
    }

    default public Short getShort(String name) {
        int pos = this.getColumnIndex(name);
        return pos == -1 ? null : this.getShort(pos);
    }

    default public Integer getInteger(String name) {
        int pos = this.getColumnIndex(name);
        return pos == -1 ? null : this.getInteger(pos);
    }

    default public Long getLong(String name) {
        int pos = this.getColumnIndex(name);
        return pos == -1 ? null : this.getLong(pos);
    }

    default public Float getFloat(String name) {
        int pos = this.getColumnIndex(name);
        return pos == -1 ? null : this.getFloat(pos);
    }

    default public Double getDouble(String name) {
        int pos = this.getColumnIndex(name);
        return pos == -1 ? null : this.getDouble(pos);
    }

    default public String getString(String name) {
        int pos = this.getColumnIndex(name);
        return pos == -1 ? null : this.getString(pos);
    }

    default public JsonObject getJsonObject(String name) {
        int pos = this.getColumnIndex(name);
        return pos == -1 ? null : this.getJsonObject(pos);
    }

    default public JsonArray getJsonArray(String name) {
        int pos = this.getColumnIndex(name);
        return pos == -1 ? null : this.getJsonArray(pos);
    }

    @GenIgnore(value={"permitted-type"})
    default public Temporal getTemporal(String name) {
        int pos = this.getColumnIndex(name);
        return pos == -1 ? null : this.getTemporal(pos);
    }

    @GenIgnore(value={"permitted-type"})
    default public LocalDate getLocalDate(String name) {
        int pos = this.getColumnIndex(name);
        return pos == -1 ? null : this.getLocalDate(pos);
    }

    @GenIgnore(value={"permitted-type"})
    default public LocalTime getLocalTime(String name) {
        int pos = this.getColumnIndex(name);
        return pos == -1 ? null : this.getLocalTime(pos);
    }

    @GenIgnore(value={"permitted-type"})
    default public LocalDateTime getLocalDateTime(String name) {
        int pos = this.getColumnIndex(name);
        return pos == -1 ? null : this.getLocalDateTime(pos);
    }

    @GenIgnore(value={"permitted-type"})
    default public OffsetTime getOffsetTime(String name) {
        int pos = this.getColumnIndex(name);
        return pos == -1 ? null : this.getOffsetTime(pos);
    }

    @GenIgnore(value={"permitted-type"})
    default public OffsetDateTime getOffsetDateTime(String name) {
        int pos = this.getColumnIndex(name);
        return pos == -1 ? null : this.getOffsetDateTime(pos);
    }

    default public Buffer getBuffer(String name) {
        int pos = this.getColumnIndex(name);
        return pos == -1 ? null : this.getBuffer(pos);
    }

    @GenIgnore(value={"permitted-type"})
    default public UUID getUUID(String name) {
        int pos = this.getColumnIndex(name);
        return pos == -1 ? null : this.getUUID(pos);
    }

    @GenIgnore(value={"permitted-type"})
    default public BigDecimal getBigDecimal(String name) {
        int pos = this.getColumnIndex(name);
        return pos == -1 ? null : this.getBigDecimal(pos);
    }

    @GenIgnore(value={"permitted-type"})
    default public Boolean[] getBooleanArray(String name) {
        int pos = this.getColumnIndex(name);
        return pos == -1 ? null : this.getBooleanArray(pos);
    }

    @GenIgnore(value={"permitted-type"})
    default public Short[] getShortArray(String name) {
        int pos = this.getColumnIndex(name);
        return pos == -1 ? null : this.getShortArray(pos);
    }

    @GenIgnore(value={"permitted-type"})
    default public Integer[] getIntegerArray(String name) {
        int pos = this.getColumnIndex(name);
        return pos == -1 ? null : this.getIntegerArray(pos);
    }

    @GenIgnore(value={"permitted-type"})
    default public Long[] getLongArray(String name) {
        int pos = this.getColumnIndex(name);
        return pos == -1 ? null : this.getLongArray(pos);
    }

    @GenIgnore(value={"permitted-type"})
    default public Float[] getFloatArray(String name) {
        int pos = this.getColumnIndex(name);
        return pos == -1 ? null : this.getFloatArray(pos);
    }

    @GenIgnore(value={"permitted-type"})
    default public Double[] getDoubleArray(String name) {
        int pos = this.getColumnIndex(name);
        return pos == -1 ? null : this.getDoubleArray(pos);
    }

    @GenIgnore(value={"permitted-type"})
    default public String[] getStringArray(String name) {
        int pos = this.getColumnIndex(name);
        return pos == -1 ? null : this.getStringArray(pos);
    }

    @GenIgnore(value={"permitted-type"})
    default public JsonObject[] getJsonObjectArray(String name) {
        int pos = this.getColumnIndex(name);
        return pos == -1 ? null : this.getJsonObjectArray(pos);
    }

    @GenIgnore(value={"permitted-type"})
    default public JsonArray[] getJsonArrayArray(String name) {
        int pos = this.getColumnIndex(name);
        return pos == -1 ? null : this.getJsonArrayArray(pos);
    }

    @GenIgnore(value={"permitted-type"})
    default public Temporal[] getTemporalArray(String name) {
        int pos = this.getColumnIndex(name);
        return pos == -1 ? null : this.getTemporalArray(pos);
    }

    @GenIgnore(value={"permitted-type"})
    default public LocalDate[] getLocalDateArray(String name) {
        int pos = this.getColumnIndex(name);
        return pos == -1 ? null : this.getLocalDateArray(pos);
    }

    @GenIgnore(value={"permitted-type"})
    default public LocalTime[] getLocalTimeArray(String name) {
        int pos = this.getColumnIndex(name);
        return pos == -1 ? null : this.getLocalTimeArray(pos);
    }

    @GenIgnore(value={"permitted-type"})
    default public LocalDateTime[] getLocalDateTimeArray(String name) {
        int pos = this.getColumnIndex(name);
        return pos == -1 ? null : this.getLocalDateTimeArray(pos);
    }

    @GenIgnore(value={"permitted-type"})
    default public OffsetTime[] getOffsetTimeArray(String name) {
        int pos = this.getColumnIndex(name);
        return pos == -1 ? null : this.getOffsetTimeArray(pos);
    }

    @GenIgnore(value={"permitted-type"})
    default public OffsetDateTime[] getOffsetDateTimeArray(String name) {
        int pos = this.getColumnIndex(name);
        return pos == -1 ? null : this.getOffsetDateTimeArray(pos);
    }

    @GenIgnore
    default public Buffer[] getBufferArray(String name) {
        int pos = this.getColumnIndex(name);
        return pos == -1 ? null : this.getBufferArray(pos);
    }

    @GenIgnore(value={"permitted-type"})
    default public UUID[] getUUIDArray(String name) {
        int pos = this.getColumnIndex(name);
        return pos == -1 ? null : this.getUUIDArray(pos);
    }

    @GenIgnore(value={"permitted-type"})
    default public BigDecimal[] getBigDecimalArray(String name) {
        int pos = this.getColumnIndex(name);
        return pos == -1 ? null : this.getBigDecimalArray(pos);
    }

    default public <T> T get(Class<T> type, String name) {
        int pos = this.getColumnIndex(name);
        return pos == -1 ? null : (T)this.get(type, pos);
    }

    default public JsonObject toJson() {
        JsonObject json = new JsonObject();
        int size = this.size();
        for (int pos = 0; pos < size; ++pos) {
            String name = this.getColumnName(pos);
            Object value = this.getValue(pos);
            json.put(name, Utils.toJson(value));
        }
        return json;
    }
}

