/*
 * Decompiled with CFR 0.152.
 */
package io.vertx.sqlclient;

import io.netty.buffer.ByteBuf;
import io.vertx.codegen.annotations.Fluent;
import io.vertx.codegen.annotations.GenIgnore;
import io.vertx.codegen.annotations.VertxGen;
import io.vertx.core.buffer.Buffer;
import io.vertx.core.json.JsonArray;
import io.vertx.core.json.JsonObject;
import io.vertx.sqlclient.impl.ArrayTuple;
import io.vertx.sqlclient.impl.ListTuple;
import java.math.BigDecimal;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.time.LocalTime;
import java.time.OffsetDateTime;
import java.time.OffsetTime;
import java.time.temporal.Temporal;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.UUID;

@VertxGen
public interface Tuple {
    public static final Object JSON_NULL = new Object();

    public static Tuple tuple() {
        return new ArrayTuple(10);
    }

    public static Tuple wrap(List<Object> list) {
        return new ListTuple(list);
    }

    @GenIgnore(value={"permitted-type"})
    public static Tuple wrap(Object ... array) {
        return new ListTuple(Arrays.asList(array));
    }

    public static Tuple of(Object elt1) {
        ArrayTuple tuple = new ArrayTuple(1);
        tuple.addValue(elt1);
        return tuple;
    }

    public static Tuple of(Object elt1, Object elt2) {
        ArrayTuple tuple = new ArrayTuple(2);
        tuple.addValue(elt1);
        tuple.addValue(elt2);
        return tuple;
    }

    public static Tuple of(Object elt1, Object elt2, Object elt3) {
        ArrayTuple tuple = new ArrayTuple(3);
        tuple.addValue(elt1);
        tuple.addValue(elt2);
        tuple.addValue(elt3);
        return tuple;
    }

    public static Tuple of(Object elt1, Object elt2, Object elt3, Object elt4) {
        ArrayTuple tuple = new ArrayTuple(4);
        tuple.addValue(elt1);
        tuple.addValue(elt2);
        tuple.addValue(elt3);
        tuple.addValue(elt4);
        return tuple;
    }

    public static Tuple of(Object elt1, Object elt2, Object elt3, Object elt4, Object elt5) {
        ArrayTuple tuple = new ArrayTuple(5);
        tuple.addValue(elt1);
        tuple.addValue(elt2);
        tuple.addValue(elt3);
        tuple.addValue(elt4);
        tuple.addValue(elt5);
        return tuple;
    }

    public static Tuple of(Object elt1, Object elt2, Object elt3, Object elt4, Object elt5, Object elt6) {
        ArrayTuple tuple = new ArrayTuple(6);
        tuple.addValue(elt1);
        tuple.addValue(elt2);
        tuple.addValue(elt3);
        tuple.addValue(elt4);
        tuple.addValue(elt5);
        tuple.addValue(elt6);
        return tuple;
    }

    @GenIgnore
    public static Tuple of(Object elt1, Object ... elts) {
        ArrayTuple tuple = new ArrayTuple(1 + elts.length);
        tuple.addValue(elt1);
        for (Object elt : elts) {
            tuple.addValue(elt);
        }
        return tuple;
    }

    public static Tuple tuple(List<Object> elements) {
        return new ArrayTuple(elements);
    }

    public Object getValue(int var1);

    default public Boolean getBoolean(int pos) {
        Object val = this.getValue(pos);
        if (val instanceof Boolean) {
            return (Boolean)val;
        }
        return null;
    }

    default public Short getShort(int pos) {
        Object val = this.getValue(pos);
        if (val instanceof Short) {
            return (Short)val;
        }
        if (val instanceof Number) {
            return ((Number)val).shortValue();
        }
        return null;
    }

    default public Integer getInteger(int pos) {
        Object val = this.getValue(pos);
        if (val instanceof Integer) {
            return (Integer)val;
        }
        if (val instanceof Number) {
            return ((Number)val).intValue();
        }
        return null;
    }

    default public Long getLong(int pos) {
        Object val = this.getValue(pos);
        if (val instanceof Long) {
            return (Long)val;
        }
        if (val instanceof Number) {
            return ((Number)val).longValue();
        }
        return null;
    }

    default public Float getFloat(int pos) {
        Object val = this.getValue(pos);
        if (val instanceof Float) {
            return (Float)val;
        }
        if (val instanceof Number) {
            return Float.valueOf(((Number)val).floatValue());
        }
        return null;
    }

    default public Double getDouble(int pos) {
        Object val = this.getValue(pos);
        if (val instanceof Double) {
            return (Double)val;
        }
        if (val instanceof Number) {
            return ((Number)val).doubleValue();
        }
        return null;
    }

    default public String getString(int pos) {
        Object val = this.getValue(pos);
        if (val instanceof String) {
            return (String)val;
        }
        return null;
    }

    default public JsonObject getJsonObject(int pos) {
        Object val = this.getValue(pos);
        if (val instanceof JsonObject) {
            return (JsonObject)val;
        }
        return null;
    }

    default public JsonArray getJsonArray(int pos) {
        Object val = this.getValue(pos);
        if (val instanceof JsonArray) {
            return (JsonArray)val;
        }
        return null;
    }

    @GenIgnore(value={"permitted-type"})
    default public Temporal getTemporal(int pos) {
        Object val = this.getValue(pos);
        if (val instanceof Temporal) {
            return (Temporal)val;
        }
        return null;
    }

    @GenIgnore(value={"permitted-type"})
    default public LocalDate getLocalDate(int pos) {
        Object val = this.getValue(pos);
        if (val instanceof LocalDate) {
            return (LocalDate)val;
        }
        if (val instanceof LocalDateTime) {
            return ((LocalDateTime)val).toLocalDate();
        }
        return null;
    }

    @GenIgnore(value={"permitted-type"})
    default public LocalTime getLocalTime(int pos) {
        Object val = this.getValue(pos);
        if (val instanceof LocalTime) {
            return (LocalTime)val;
        }
        if (val instanceof LocalDateTime) {
            return ((LocalDateTime)val).toLocalTime();
        }
        return null;
    }

    @GenIgnore(value={"permitted-type"})
    default public LocalDateTime getLocalDateTime(int pos) {
        Object val = this.getValue(pos);
        if (val instanceof LocalDateTime) {
            return (LocalDateTime)val;
        }
        return null;
    }

    @GenIgnore(value={"permitted-type"})
    default public OffsetTime getOffsetTime(int pos) {
        Object val = this.getValue(pos);
        if (val instanceof OffsetTime) {
            return (OffsetTime)val;
        }
        if (val instanceof OffsetDateTime) {
            return ((OffsetDateTime)val).toOffsetTime();
        }
        return null;
    }

    @GenIgnore(value={"permitted-type"})
    default public OffsetDateTime getOffsetDateTime(int pos) {
        Object val = this.getValue(pos);
        if (val instanceof OffsetDateTime) {
            return (OffsetDateTime)val;
        }
        return null;
    }

    default public Buffer getBuffer(int pos) {
        Object val = this.getValue(pos);
        if (val instanceof Buffer) {
            return (Buffer)val;
        }
        if (val instanceof ByteBuf) {
            return Buffer.buffer((ByteBuf)((ByteBuf)val));
        }
        if (val instanceof byte[]) {
            return Buffer.buffer((byte[])((byte[])val));
        }
        return null;
    }

    @GenIgnore(value={"permitted-type"})
    default public UUID getUUID(int pos) {
        Object val = this.getValue(pos);
        if (val instanceof UUID) {
            return (UUID)val;
        }
        if (val instanceof String) {
            return UUID.fromString((String)val);
        }
        return null;
    }

    @GenIgnore(value={"permitted-type"})
    default public BigDecimal getBigDecimal(int pos) {
        Object val = this.getValue(pos);
        if (val instanceof BigDecimal) {
            return (BigDecimal)val;
        }
        if (val instanceof Number) {
            return new BigDecimal(val.toString());
        }
        return null;
    }

    @GenIgnore(value={"permitted-type"})
    default public Boolean[] getBooleanArray(int pos) {
        Object val = this.getValue(pos);
        if (val instanceof Boolean[]) {
            return (Boolean[])val;
        }
        if (val != null && val.getClass() == Object[].class) {
            Object[] array = (Object[])val;
            Boolean[] booleanArray = new Boolean[array.length];
            for (int i = 0; i < array.length; ++i) {
                booleanArray[i] = (Boolean)array[i];
            }
            return booleanArray;
        }
        return null;
    }

    @GenIgnore(value={"permitted-type"})
    default public Short[] getShortArray(int pos) {
        Object val = this.getValue(pos);
        if (val instanceof Short[]) {
            return (Short[])val;
        }
        if (val instanceof Number[]) {
            Number[] a = (Number[])val;
            int len = a.length;
            Short[] arr = new Short[len];
            for (int i = 0; i < len; ++i) {
                Number elt = a[i];
                if (elt == null) continue;
                arr[i] = elt.shortValue();
            }
            return arr;
        }
        if (val != null && val.getClass() == Object[].class) {
            Object[] array = (Object[])val;
            Short[] shortArray = new Short[array.length];
            for (int i = 0; i < array.length; ++i) {
                shortArray[i] = ((Number)array[i]).shortValue();
            }
            return shortArray;
        }
        return null;
    }

    @GenIgnore(value={"permitted-type"})
    default public Integer[] getIntegerArray(int pos) {
        Object val = this.getValue(pos);
        if (val instanceof Integer[]) {
            return (Integer[])val;
        }
        if (val instanceof Number[]) {
            Number[] a = (Number[])val;
            int len = a.length;
            Integer[] arr = new Integer[len];
            for (int i = 0; i < len; ++i) {
                Number elt = a[i];
                if (elt == null) continue;
                arr[i] = elt.intValue();
            }
            return arr;
        }
        if (val != null && val.getClass() == Object[].class) {
            Object[] array = (Object[])val;
            Integer[] integerArray = new Integer[array.length];
            for (int i = 0; i < array.length; ++i) {
                integerArray[i] = ((Number)array[i]).intValue();
            }
            return integerArray;
        }
        return null;
    }

    @GenIgnore(value={"permitted-type"})
    default public Long[] getLongArray(int pos) {
        Object val = this.getValue(pos);
        if (val instanceof Long[]) {
            return (Long[])val;
        }
        if (val instanceof Number[]) {
            Number[] a = (Number[])val;
            int len = a.length;
            Long[] arr = new Long[len];
            for (int i = 0; i < len; ++i) {
                Number elt = a[i];
                if (elt == null) continue;
                arr[i] = elt.longValue();
            }
            return arr;
        }
        if (val != null && val.getClass() == Object[].class) {
            Object[] array = (Object[])val;
            Long[] longArray = new Long[array.length];
            for (int i = 0; i < array.length; ++i) {
                longArray[i] = ((Number)array[i]).longValue();
            }
            return longArray;
        }
        return null;
    }

    @GenIgnore(value={"permitted-type"})
    default public Float[] getFloatArray(int pos) {
        Object val = this.getValue(pos);
        if (val instanceof Float[]) {
            return (Float[])val;
        }
        if (val instanceof Number[]) {
            Number[] a = (Number[])val;
            int len = a.length;
            Float[] arr = new Float[len];
            for (int i = 0; i < len; ++i) {
                Number elt = a[i];
                if (elt == null) continue;
                arr[i] = Float.valueOf(elt.floatValue());
            }
            return arr;
        }
        if (val != null && val.getClass() == Object[].class) {
            Object[] array = (Object[])val;
            Float[] floatArray = new Float[array.length];
            for (int i = 0; i < array.length; ++i) {
                floatArray[i] = Float.valueOf(((Number)array[i]).floatValue());
            }
            return floatArray;
        }
        return null;
    }

    @GenIgnore(value={"permitted-type"})
    default public Double[] getDoubleArray(int pos) {
        Object val = this.getValue(pos);
        if (val instanceof Double[]) {
            return (Double[])val;
        }
        if (val instanceof Number[]) {
            Number[] a = (Number[])val;
            int len = a.length;
            Double[] arr = new Double[len];
            for (int i = 0; i < len; ++i) {
                Number elt = a[i];
                if (elt == null) continue;
                arr[i] = elt.doubleValue();
            }
            return arr;
        }
        if (val != null && val.getClass() == Object[].class) {
            Object[] array = (Object[])val;
            Double[] doubleArray = new Double[array.length];
            for (int i = 0; i < array.length; ++i) {
                doubleArray[i] = ((Number)array[i]).doubleValue();
            }
            return doubleArray;
        }
        return null;
    }

    @GenIgnore(value={"permitted-type"})
    default public String[] getStringArray(int pos) {
        Object val = this.getValue(pos);
        if (val instanceof String[]) {
            return (String[])val;
        }
        if (val != null && val.getClass() == Object[].class) {
            Object[] array = (Object[])val;
            String[] stringArray = new String[array.length];
            for (int i = 0; i < array.length; ++i) {
                stringArray[i] = (String)array[i];
            }
            return stringArray;
        }
        return null;
    }

    @GenIgnore(value={"permitted-type"})
    default public JsonObject[] getJsonObjectArray(int pos) {
        Object val = this.getValue(pos);
        if (val != null && val.getClass() == Object[].class) {
            Object[] array = (Object[])val;
            JsonObject[] jsonObjectArray = new JsonObject[array.length];
            for (int i = 0; i < array.length; ++i) {
                jsonObjectArray[i] = (JsonObject)array[i];
            }
            return jsonObjectArray;
        }
        return null;
    }

    @GenIgnore(value={"permitted-type"})
    default public JsonArray[] getJsonArrayArray(int pos) {
        Object val = this.getValue(pos);
        if (val != null && val.getClass() == Object[].class) {
            Object[] array = (Object[])val;
            JsonArray[] jsonObjectArray = new JsonArray[array.length];
            for (int i = 0; i < array.length; ++i) {
                jsonObjectArray[i] = (JsonArray)array[i];
            }
            return jsonObjectArray;
        }
        return null;
    }

    @GenIgnore(value={"permitted-type"})
    default public Temporal[] getTemporalArray(int pos) {
        Object val = this.getValue(pos);
        if (val instanceof Temporal[]) {
            return (Temporal[])val;
        }
        return null;
    }

    @GenIgnore(value={"permitted-type"})
    default public LocalDate[] getLocalDateArray(int pos) {
        Object val = this.getValue(pos);
        if (val instanceof LocalDate[]) {
            return (LocalDate[])val;
        }
        if (val instanceof LocalDateTime[]) {
            LocalDateTime[] a = (LocalDateTime[])val;
            int len = a.length;
            LocalDate[] arr = new LocalDate[len];
            for (int i = 0; i < len; ++i) {
                LocalDateTime elt = a[i];
                if (elt == null) continue;
                arr[i] = elt.toLocalDate();
            }
            return arr;
        }
        return null;
    }

    @GenIgnore(value={"permitted-type"})
    default public LocalTime[] getLocalTimeArray(int pos) {
        Object val = this.getValue(pos);
        if (val instanceof LocalTime[]) {
            return (LocalTime[])val;
        }
        if (val instanceof LocalDateTime[]) {
            LocalDateTime[] a = (LocalDateTime[])val;
            int len = a.length;
            LocalTime[] arr = new LocalTime[len];
            for (int i = 0; i < len; ++i) {
                LocalDateTime elt = a[i];
                if (elt == null) continue;
                arr[i] = elt.toLocalTime();
            }
            return arr;
        }
        return null;
    }

    @GenIgnore(value={"permitted-type"})
    default public LocalDateTime[] getLocalDateTimeArray(int pos) {
        Object val = this.getValue(pos);
        if (val instanceof LocalDateTime[]) {
            return (LocalDateTime[])val;
        }
        return null;
    }

    @GenIgnore(value={"permitted-type"})
    default public OffsetTime[] getOffsetTimeArray(int pos) {
        Object val = this.getValue(pos);
        if (val instanceof OffsetTime[]) {
            return (OffsetTime[])val;
        }
        if (val instanceof OffsetDateTime[]) {
            OffsetDateTime[] a = (OffsetDateTime[])val;
            int len = a.length;
            OffsetTime[] arr = new OffsetTime[len];
            for (int i = 0; i < len; ++i) {
                OffsetDateTime elt = a[i];
                if (elt == null) continue;
                arr[i] = elt.toOffsetTime();
            }
            return arr;
        }
        return null;
    }

    @GenIgnore(value={"permitted-type"})
    default public OffsetDateTime[] getOffsetDateTimeArray(int pos) {
        Object val = this.getValue(pos);
        if (val instanceof OffsetDateTime[]) {
            return (OffsetDateTime[])val;
        }
        return null;
    }

    @GenIgnore
    default public Buffer[] getBufferArray(int pos) {
        Object val = this.getValue(pos);
        if (val instanceof Buffer[]) {
            return (Buffer[])val;
        }
        return null;
    }

    @GenIgnore(value={"permitted-type"})
    default public UUID[] getUUIDArray(int pos) {
        Object val = this.getValue(pos);
        if (val instanceof UUID[]) {
            return (UUID[])val;
        }
        return null;
    }

    @GenIgnore(value={"permitted-type"})
    default public BigDecimal[] getBigDecimalArray(int pos) {
        Object val = this.getValue(pos);
        if (val instanceof BigDecimal[]) {
            return (BigDecimal[])val;
        }
        return null;
    }

    @Fluent
    public Tuple addValue(Object var1);

    @Fluent
    default public Tuple addBoolean(Boolean value) {
        return this.addValue(value);
    }

    @Fluent
    default public Tuple addShort(Short value) {
        return this.addValue(value);
    }

    @Fluent
    default public Tuple addInteger(Integer value) {
        return this.addValue(value);
    }

    @Fluent
    default public Tuple addLong(Long value) {
        return this.addValue(value);
    }

    @Fluent
    default public Tuple addFloat(Float value) {
        return this.addValue(value);
    }

    @Fluent
    default public Tuple addDouble(Double value) {
        return this.addValue(value);
    }

    @Fluent
    default public Tuple addString(String value) {
        return this.addValue(value);
    }

    @Fluent
    default public Tuple addJsonObject(JsonObject value) {
        return this.addValue(value);
    }

    @Fluent
    default public Tuple addJsonArray(JsonArray value) {
        return this.addValue(value);
    }

    @GenIgnore(value={"permitted-type"})
    default public Tuple addTemporal(Temporal value) {
        return this.addValue(value);
    }

    @GenIgnore(value={"permitted-type"})
    default public Tuple addLocalDate(LocalDate value) {
        return this.addValue(value);
    }

    @GenIgnore(value={"permitted-type"})
    default public Tuple addLocalTime(LocalTime value) {
        return this.addValue(value);
    }

    @GenIgnore(value={"permitted-type"})
    default public Tuple addLocalDateTime(LocalDateTime value) {
        return this.addValue(value);
    }

    @GenIgnore(value={"permitted-type"})
    default public Tuple addOffsetTime(OffsetTime value) {
        return this.addValue(value);
    }

    @GenIgnore(value={"permitted-type"})
    default public Tuple addOffsetDateTime(OffsetDateTime value) {
        return this.addValue(value);
    }

    @Fluent
    default public Tuple addBuffer(Buffer value) {
        return this.addValue(value);
    }

    @GenIgnore(value={"permitted-type"})
    default public Tuple addUUID(UUID value) {
        return this.addValue(value);
    }

    @GenIgnore(value={"permitted-type"})
    default public Tuple addBigDecimal(BigDecimal value) {
        return this.addValue(value);
    }

    @GenIgnore(value={"permitted-type"})
    default public Tuple addBooleanArray(Boolean[] value) {
        return this.addValue(value);
    }

    @GenIgnore(value={"permitted-type"})
    default public Tuple addShortArray(Short[] value) {
        return this.addValue(value);
    }

    @GenIgnore(value={"permitted-type"})
    default public Tuple addIntegerArray(Integer[] value) {
        return this.addValue(value);
    }

    @GenIgnore(value={"permitted-type"})
    default public Tuple addLongArray(Long[] value) {
        return this.addValue(value);
    }

    @GenIgnore(value={"permitted-type"})
    default public Tuple addFloatArray(Float[] value) {
        return this.addValue(value);
    }

    @GenIgnore(value={"permitted-type"})
    default public Tuple addDoubleArray(Double[] value) {
        return this.addValue(value);
    }

    @GenIgnore(value={"permitted-type"})
    default public Tuple addStringArray(String[] value) {
        return this.addValue(value);
    }

    @GenIgnore(value={"permitted-type"})
    default public Tuple addJsonObjectArray(JsonObject[] value) {
        return this.addValue(value);
    }

    @GenIgnore(value={"permitted-type"})
    default public Tuple addJsonArrayArray(JsonArray[] value) {
        return this.addValue(value);
    }

    @GenIgnore(value={"permitted-type"})
    default public Tuple addTemporalArray(Temporal[] value) {
        return this.addValue(value);
    }

    @GenIgnore(value={"permitted-type"})
    default public Tuple addLocalDateArray(LocalDate[] value) {
        return this.addValue(value);
    }

    @GenIgnore(value={"permitted-type"})
    default public Tuple addLocalTimeArray(LocalTime[] value) {
        return this.addValue(value);
    }

    @GenIgnore(value={"permitted-type"})
    default public Tuple addLocalDateTimeArray(LocalDateTime[] value) {
        return this.addValue(value);
    }

    @GenIgnore(value={"permitted-type"})
    default public Tuple addOffsetTimeArray(OffsetTime[] value) {
        return this.addValue(value);
    }

    @GenIgnore(value={"permitted-type"})
    default public Tuple addOffsetDateTimeArray(OffsetDateTime[] value) {
        return this.addValue(value);
    }

    @GenIgnore
    default public Tuple addBufferArray(Buffer[] value) {
        return this.addValue(value);
    }

    @GenIgnore(value={"permitted-type"})
    default public Tuple addUUIDArray(UUID[] value) {
        return this.addValue(value);
    }

    @GenIgnore(value={"permitted-type"})
    default public Tuple addBigDecimalArray(BigDecimal[] value) {
        return this.addValue(value);
    }

    default public <T> T get(Class<T> type, int position) {
        if (type == null) {
            throw new IllegalArgumentException("Accessor type can not be null");
        }
        Object value = this.getValue(position);
        if (value != null && type.isAssignableFrom(value.getClass())) {
            return type.cast(value);
        }
        return null;
    }

    public int size();

    public void clear();

    @GenIgnore
    default public List<Class<?>> types() {
        int len = this.size();
        ArrayList types = new ArrayList();
        for (int i = 0; i < len; ++i) {
            Object param = this.getValue(i);
            if (param == null) {
                types.add(Object.class);
                continue;
            }
            types.add(param.getClass());
        }
        return types;
    }

    default public String deepToString() {
        StringBuilder sb = new StringBuilder();
        sb.append("[");
        int size = this.size();
        for (int i = 0; i < size; ++i) {
            sb.append(this.getValue(i));
            if (i + 1 >= size) continue;
            sb.append(",");
        }
        sb.append("]");
        return sb.toString();
    }
}

