/*
 * Decompiled with CFR 0.152.
 */
package io.vertx.sqlclient.impl;

import io.vertx.core.AsyncResult;
import io.vertx.core.Closeable;
import io.vertx.core.Context;
import io.vertx.core.Future;
import io.vertx.core.Handler;
import io.vertx.core.Promise;
import io.vertx.core.impl.CloseFuture;
import io.vertx.core.impl.ContextInternal;
import io.vertx.core.impl.VertxInternal;
import io.vertx.core.impl.future.PromiseInternal;
import io.vertx.core.spi.metrics.ClientMetrics;
import io.vertx.sqlclient.Pool;
import io.vertx.sqlclient.PoolOptions;
import io.vertx.sqlclient.SqlConnection;
import io.vertx.sqlclient.impl.Connection;
import io.vertx.sqlclient.impl.ConnectionFactory;
import io.vertx.sqlclient.impl.SqlClientBase;
import io.vertx.sqlclient.impl.SqlConnectionImpl;
import io.vertx.sqlclient.impl.command.CommandBase;
import io.vertx.sqlclient.impl.pool.ConnectionPool;
import io.vertx.sqlclient.impl.tracing.QueryTracer;

public abstract class PoolBase<P extends Pool>
extends SqlClientBase<P>
implements Pool,
Closeable {
    private final ContextInternal context;
    private final VertxInternal vertx;
    private final ConnectionFactory factory;
    private final ConnectionPool pool;
    private final CloseFuture closeFuture;

    public PoolBase(ContextInternal context, ConnectionFactory factory, QueryTracer tracer, ClientMetrics metrics, PoolOptions poolOptions) {
        super(tracer, metrics);
        this.context = context;
        this.vertx = context.owner();
        this.factory = factory;
        this.pool = new ConnectionPool(factory, (Context)context, poolOptions.getMaxSize(), poolOptions.getMaxWaitQueueSize());
        this.closeFuture = new CloseFuture((Closeable)this);
    }

    public CloseFuture closeFuture() {
        return this.closeFuture;
    }

    @Override
    protected <T> PromiseInternal<T> promise() {
        return this.vertx.promise();
    }

    @Override
    protected <T> PromiseInternal<T> promise(Handler<AsyncResult<T>> handler) {
        return this.vertx.promise(handler);
    }

    public abstract void connect(Handler<AsyncResult<Connection>> var1);

    @Override
    public void getConnection(Handler<AsyncResult<SqlConnection>> handler) {
        Future<SqlConnection> fut = this.getConnection();
        if (handler != null) {
            fut.onComplete(handler);
        }
    }

    @Override
    public Future<SqlConnection> getConnection() {
        ContextInternal current = this.vertx.getOrCreateContext();
        Object metric = this.metrics != null ? this.metrics.enqueueRequest() : null;
        PromiseInternal promise = current.promise();
        this.acquire((Handler<AsyncResult<Connection>>)promise);
        if (this.metrics != null) {
            promise.future().onComplete(ar -> this.metrics.dequeueRequest(metric));
        }
        return promise.future().map(conn -> {
            SqlConnectionImpl wrapper = this.wrap(current, (Connection)conn);
            conn.init(wrapper);
            return wrapper;
        });
    }

    @Override
    public <R> void schedule(final CommandBase<R> cmd, final Promise<R> promise) {
        final Object metric = this.metrics != null ? this.metrics.enqueueRequest() : null;
        this.acquire(new CommandWaiter(){

            @Override
            protected void onSuccess(Connection conn) {
                if (PoolBase.this.metrics != null) {
                    PoolBase.this.metrics.dequeueRequest(metric);
                }
                conn.schedule(cmd, promise);
                promise.future().onComplete(ar -> conn.close(this, (Promise<Void>)Promise.promise()));
            }

            @Override
            protected void onFailure(Throwable cause) {
                if (PoolBase.this.metrics != null) {
                    PoolBase.this.metrics.dequeueRequest(metric);
                }
                promise.fail(cause);
            }
        });
    }

    private void acquire(Handler<AsyncResult<Connection>> completionHandler) {
        this.pool.acquire(completionHandler);
    }

    protected abstract SqlConnectionImpl wrap(ContextInternal var1, Connection var2);

    public void close(Promise<Void> completion) {
        this.doClose().onComplete(completion);
    }

    @Override
    public Future<Void> close() {
        PromiseInternal promise = this.vertx.promise();
        this.closeFuture.close((Promise)promise);
        return promise.future();
    }

    @Override
    public void close(Handler<AsyncResult<Void>> handler) {
        this.closeFuture.close((Promise)this.vertx.promise(handler));
    }

    private Future<Void> doClose() {
        return this.pool.close().flatMap(v -> {
            PromiseInternal promise = this.context.promise();
            this.factory.close((Promise<Void>)promise);
            return promise;
        }).onComplete(v -> {
            if (this.metrics != null) {
                this.metrics.close();
            }
        });
    }

    private static abstract class CommandWaiter
    implements Connection.Holder,
    Handler<AsyncResult<Connection>> {
        private CommandWaiter() {
        }

        protected abstract void onSuccess(Connection var1);

        protected abstract void onFailure(Throwable var1);

        @Override
        public void handleEvent(Object event) {
        }

        public void handle(AsyncResult<Connection> ar) {
            if (ar.succeeded()) {
                Connection conn = (Connection)ar.result();
                conn.init(this);
                this.onSuccess(conn);
            } else {
                this.onFailure(ar.cause());
            }
        }

        @Override
        public void handleClosed() {
        }

        @Override
        public void handleException(Throwable err) {
        }
    }
}

