/*
 * Decompiled with CFR 0.152.
 */
package io.vertx.sqlclient.impl;

import io.vertx.core.AsyncResult;
import io.vertx.core.Future;
import io.vertx.core.Handler;
import io.vertx.core.impl.ContextInternal;
import io.vertx.sqlclient.Cursor;
import io.vertx.sqlclient.Row;
import io.vertx.sqlclient.RowSet;
import io.vertx.sqlclient.RowStream;
import io.vertx.sqlclient.Tuple;
import io.vertx.sqlclient.impl.PreparedStatementImpl;
import io.vertx.sqlclient.impl.RowStreamInternal;
import java.util.Iterator;

public class RowStreamImpl
implements RowStreamInternal,
Handler<AsyncResult<RowSet<Row>>> {
    private final PreparedStatementImpl ps;
    private final ContextInternal context;
    private final int fetch;
    private final Tuple params;
    private Handler<Void> endHandler;
    private Handler<Row> rowHandler;
    private Handler<Throwable> exceptionHandler;
    private long demand;
    private boolean emitting;
    private Cursor cursor;
    private Iterator<Row> result;

    RowStreamImpl(PreparedStatementImpl ps, ContextInternal context, int fetch, Tuple params) {
        this.ps = ps;
        this.context = context;
        this.fetch = fetch;
        this.params = params;
        this.demand = Long.MAX_VALUE;
    }

    @Override
    public synchronized Cursor cursor() {
        return this.cursor;
    }

    @Override
    public synchronized RowStream<Row> exceptionHandler(Handler<Throwable> handler) {
        this.exceptionHandler = handler;
        return this;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public RowStream<Row> handler(Handler<Row> handler) {
        Cursor c;
        RowStreamImpl rowStreamImpl = this;
        synchronized (rowStreamImpl) {
            if (handler != null) {
                if (this.cursor != null) {
                    throw new UnsupportedOperationException("Handle me gracefully");
                }
            } else {
                if (this.cursor != null) {
                    this.cursor.close();
                    this.cursor = null;
                    this.result = null;
                } else {
                    this.rowHandler = null;
                }
                return this;
            }
            this.rowHandler = handler;
            c = this.cursor = this.ps.cursor(this.params);
        }
        c.read(this.fetch, this);
        return this;
    }

    @Override
    public synchronized RowStream<Row> pause() {
        this.demand = 0L;
        return this;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public RowStream<Row> fetch(long amount) {
        if (amount < 0L) {
            throw new IllegalArgumentException("Invalid fetch amount " + amount);
        }
        RowStreamImpl rowStreamImpl = this;
        synchronized (rowStreamImpl) {
            this.demand += amount;
            if (this.demand < 0L) {
                this.demand = Long.MAX_VALUE;
            }
            if (this.cursor == null) {
                return this;
            }
        }
        this.checkPending();
        return this;
    }

    @Override
    public RowStream<Row> resume() {
        return this.fetch(Long.MAX_VALUE);
    }

    @Override
    public synchronized RowStream<Row> endHandler(Handler<Void> handler) {
        this.endHandler = handler;
        return this;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void handle(AsyncResult<RowSet<Row>> ar) {
        if (ar.failed()) {
            Handler<Throwable> handler;
            RowStreamImpl rowStreamImpl = this;
            synchronized (rowStreamImpl) {
                this.cursor = null;
                handler = this.exceptionHandler;
            }
            if (handler != null) {
                handler.handle((Object)ar.cause());
            }
        } else {
            Iterator it = ((RowSet)ar.result()).iterator();
            if (it.hasNext()) {
                this.result = it;
            }
            this.checkPending();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Future<Void> close() {
        Cursor c;
        RowStreamImpl rowStreamImpl = this;
        synchronized (rowStreamImpl) {
            c = this.cursor;
            this.cursor = null;
        }
        if (c != null) {
            return c.close();
        }
        return this.context.succeededFuture();
    }

    @Override
    public void close(Handler<AsyncResult<Void>> completionHandler) {
        Future<Void> fut = this.close();
        if (completionHandler != null) {
            fut.onComplete(completionHandler);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void checkPending() {
        RowStreamImpl rowStreamImpl = this;
        synchronized (rowStreamImpl) {
            if (this.emitting) {
                return;
            }
            this.emitting = true;
        }
        while (true) {
            rowStreamImpl = this;
            synchronized (rowStreamImpl) {
                Row event;
                Object handler;
                if (this.demand == 0L) {
                    this.emitting = false;
                    break;
                }
                if (this.result != null) {
                    handler = this.rowHandler;
                    event = this.result.next();
                    if (this.demand != Long.MAX_VALUE) {
                        --this.demand;
                    }
                    if (!this.result.hasNext()) {
                        this.result = null;
                    }
                } else {
                    this.emitting = false;
                    if (this.cursor == null) {
                        break;
                    }
                    if (this.cursor.hasMore()) {
                        this.cursor.read(this.fetch, this);
                        break;
                    }
                    this.cursor.close();
                    this.cursor = null;
                    handler = this.endHandler;
                    event = null;
                }
                if (handler != null) {
                    handler.handle((Object)event);
                }
            }
        }
    }
}

