/*
 * Decompiled with CFR 0.152.
 */
package io.vertx.sqlclient.impl;

import io.vertx.core.AsyncResult;
import io.vertx.core.Future;
import io.vertx.core.Handler;
import io.vertx.core.Promise;
import io.vertx.core.Vertx;
import io.vertx.core.impl.ContextInternal;
import io.vertx.core.impl.future.PromiseInternal;
import io.vertx.core.spi.metrics.ClientMetrics;
import io.vertx.sqlclient.SqlConnection;
import io.vertx.sqlclient.Transaction;
import io.vertx.sqlclient.impl.Connection;
import io.vertx.sqlclient.impl.SqlConnectionBase;
import io.vertx.sqlclient.impl.TransactionImpl;
import io.vertx.sqlclient.impl.command.CommandBase;
import io.vertx.sqlclient.impl.tracing.QueryTracer;
import io.vertx.sqlclient.spi.DatabaseMetadata;

public class SqlConnectionImpl<C extends SqlConnection>
extends SqlConnectionBase<C>
implements SqlConnection,
Connection.Holder {
    private volatile Handler<Throwable> exceptionHandler;
    private volatile Handler<Void> closeHandler;
    private TransactionImpl tx;

    public SqlConnectionImpl(ContextInternal context, Connection conn, QueryTracer tracer, ClientMetrics metrics) {
        super(context, conn, tracer, metrics);
    }

    @Override
    protected <T> PromiseInternal<T> promise() {
        return this.context.promise();
    }

    @Override
    protected <T> PromiseInternal<T> promise(Handler<AsyncResult<T>> handler) {
        return this.context.promise(handler);
    }

    @Override
    public void handleClosed() {
        Handler<Void> handler = this.closeHandler;
        if (handler != null) {
            this.context.runOnContext(handler);
        }
    }

    @Override
    public <R> void schedule(CommandBase<R> cmd, Promise<R> promise) {
        if (this.tx != null) {
            this.tx.schedule(cmd, promise);
        } else {
            this.conn.schedule(cmd, promise);
        }
    }

    @Override
    public void handleException(Throwable err) {
        Handler<Throwable> handler = this.exceptionHandler;
        if (handler != null) {
            this.context.runOnContext(v -> handler.handle((Object)err));
        } else {
            err.printStackTrace();
        }
    }

    @Override
    public boolean isSSL() {
        return this.conn.isSsl();
    }

    @Override
    public DatabaseMetadata databaseMetadata() {
        return this.conn.getDatabaseMetaData();
    }

    public C closeHandler(Handler<Void> handler) {
        this.closeHandler = handler;
        return (C)this;
    }

    public C exceptionHandler(Handler<Throwable> handler) {
        this.exceptionHandler = handler;
        return (C)this;
    }

    @Override
    public Future<Transaction> begin() {
        if (this.tx != null) {
            throw new IllegalStateException();
        }
        this.tx = new TransactionImpl(this.context, this.conn);
        this.tx.completion().onComplete(ar -> {
            this.tx = null;
        });
        return this.tx.begin();
    }

    @Override
    boolean autoCommit() {
        return this.tx == null;
    }

    @Override
    public void begin(Handler<AsyncResult<Transaction>> handler) {
        Future<Transaction> fut = this.begin();
        fut.onComplete(handler);
    }

    @Override
    public void handleEvent(Object event) {
    }

    @Override
    public Future<Void> close() {
        PromiseInternal promise = this.promise();
        this.close((Promise<Void>)promise);
        return promise.future();
    }

    @Override
    public void close(Handler<AsyncResult<Void>> handler) {
        this.close((Promise<Void>)this.promise(handler));
    }

    private void close(Promise<Void> promise) {
        if (this.context == Vertx.currentContext()) {
            if (this.tx != null) {
                this.tx.rollback((Handler<AsyncResult<Void>>)((Handler)ar -> this.conn.close(this, promise)));
                this.tx = null;
            } else {
                this.conn.close(this, promise);
            }
        } else {
            this.context.runOnContext(v -> this.close());
        }
    }
}

