/*
 * Decompiled with CFR 0.152.
 */
package io.vertx.sqlclient.impl;

import io.vertx.core.AsyncResult;
import io.vertx.core.Future;
import io.vertx.core.Handler;
import io.vertx.core.Promise;
import io.vertx.core.VertxException;
import io.vertx.core.impl.ContextInternal;
import io.vertx.core.impl.future.PromiseInternal;
import io.vertx.sqlclient.Transaction;
import io.vertx.sqlclient.TransactionRollbackException;
import io.vertx.sqlclient.impl.Connection;
import io.vertx.sqlclient.impl.command.CommandBase;
import io.vertx.sqlclient.impl.command.TxCommand;
import java.util.ArrayDeque;
import java.util.Deque;

class TransactionImpl
implements Transaction {
    private static final TxCommand<Void> ROLLBACK = new TxCommand<Object>(TxCommand.Kind.ROLLBACK, null);
    private static final TxCommand<Void> COMMIT = new TxCommand<Object>(TxCommand.Kind.COMMIT, null);
    private static final int ST_BEGIN = 0;
    private static final int ST_PENDING = 1;
    private static final int ST_PROCESSING = 2;
    private static final int ST_COMPLETED = 3;
    private final ContextInternal context;
    private final Connection connection;
    private Deque<ScheduledCommand<?>> pending = new ArrayDeque();
    private int status = 0;
    private final Promise<Void> completion;

    TransactionImpl(ContextInternal context, Connection connection) {
        this.context = context;
        this.connection = connection;
        this.completion = context.promise();
    }

    Future<Transaction> begin() {
        PromiseInternal promise = this.context.promise(this::afterBegin);
        ScheduledCommand<TransactionImpl> b = this.doQuery(new TxCommand<TransactionImpl>(TxCommand.Kind.BEGIN, this), (Promise)promise);
        this.doSchedule(b.cmd, b.handler);
        return promise.future();
    }

    private <R> void doSchedule(CommandBase<R> cmd, Handler<AsyncResult<R>> handler) {
        this.connection.schedule(cmd, this.context.promise(handler));
    }

    private <R> void wrapAndSchedule(ScheduledCommand<R> scheduled) {
        CommandBase cmd = scheduled.cmd;
        if (TransactionImpl.isComplete(cmd)) {
            this.status = 3;
            this.doSchedule(cmd, ar -> {
                if (ar.succeeded()) {
                    if (cmd == COMMIT) {
                        this.completion.tryComplete();
                    } else {
                        this.completion.tryFail((Throwable)((Object)TransactionRollbackException.INSTANCE));
                    }
                } else {
                    this.completion.tryFail(ar.cause());
                }
                scheduled.handler.handle(ar);
            });
        } else {
            this.status = 2;
            this.doSchedule(cmd, this.wrap(scheduled.handler));
        }
    }

    private <T> Handler<AsyncResult<T>> wrap(Handler<AsyncResult<T>> handler) {
        return ar -> {
            TransactionImpl transactionImpl = this;
            synchronized (transactionImpl) {
                this.status = 1;
                if (ar.failed()) {
                    ScheduledCommand<?> c;
                    while ((c = this.pending.poll()) != null) {
                        c.handler.handle((Object)Future.failedFuture((String)"Rollback exception"));
                    }
                    this.schedule__(this.doQuery(ROLLBACK, (Promise)this.context.promise(ar2 -> handler.handle(ar))));
                } else {
                    handler.handle(ar);
                    this.checkPending();
                }
            }
        };
    }

    private synchronized void afterBegin(AsyncResult<Transaction> ar) {
        this.status = ar.succeeded() ? 1 : 3;
        this.checkPending();
    }

    private static boolean isComplete(CommandBase<?> cmd) {
        if (cmd instanceof TxCommand) {
            TxCommand txCmd = (TxCommand)cmd;
            return txCmd.kind == TxCommand.Kind.COMMIT || txCmd.kind == TxCommand.Kind.ROLLBACK;
        }
        return false;
    }

    private synchronized void checkPending() {
        switch (this.status) {
            case 0: {
                break;
            }
            case 1: {
                ScheduledCommand<?> cmd = this.pending.poll();
                if (cmd == null) break;
                this.wrapAndSchedule(cmd);
                break;
            }
            case 2: {
                break;
            }
            case 3: {
                ScheduledCommand<?> cmd;
                if (this.pending.size() <= 0) break;
                VertxException err = new VertxException("Transaction already completed");
                while ((cmd = this.pending.poll()) != null) {
                    cmd.cmd.fail((Throwable)err);
                }
                break;
            }
        }
    }

    public <R> void schedule(CommandBase<R> cmd, Promise<R> handler) {
        this.schedule__(cmd, (Handler<AsyncResult<R>>)handler);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public <R> void schedule__(ScheduledCommand<R> b) {
        TransactionImpl transactionImpl = this;
        synchronized (transactionImpl) {
            this.pending.add(b);
        }
        this.checkPending();
    }

    public <R> void schedule__(CommandBase<R> cmd, Handler<AsyncResult<R>> handler) {
        this.schedule__(new ScheduledCommand<R>(cmd, handler));
    }

    @Override
    public Future<Void> commit() {
        switch (this.status) {
            case 0: 
            case 1: 
            case 2: {
                PromiseInternal promise = this.context.promise();
                this.schedule__(this.doQuery(COMMIT, (Promise)promise));
                return promise.future();
            }
            case 3: {
                return this.context.failedFuture("Transaction already completed");
            }
        }
        throw new IllegalStateException();
    }

    @Override
    public void commit(Handler<AsyncResult<Void>> handler) {
        Future<Void> fut = this.commit();
        if (handler != null) {
            fut.onComplete(handler);
        }
    }

    @Override
    public Future<Void> rollback() {
        if (this.status == 3) {
            return this.context.failedFuture("Transaction already completed");
        }
        PromiseInternal promise = this.context.promise();
        this.schedule__(this.doQuery(ROLLBACK, (Promise)promise));
        return promise.future();
    }

    @Override
    public void rollback(Handler<AsyncResult<Void>> handler) {
        Future<Void> fut = this.rollback();
        if (handler != null) {
            fut.onComplete(handler);
        }
    }

    private <R> ScheduledCommand<R> doQuery(TxCommand<R> cmd, Promise<R> handler) {
        return new ScheduledCommand<R>(cmd, handler);
    }

    @Override
    public Future<Void> completion() {
        return this.completion.future();
    }

    static class ScheduledCommand<R> {
        final CommandBase<R> cmd;
        final Handler<AsyncResult<R>> handler;

        ScheduledCommand(CommandBase<R> cmd, Handler<AsyncResult<R>> handler) {
            this.cmd = cmd;
            this.handler = handler;
        }
    }
}

