/*
 * Decompiled with CFR 0.152.
 */
package io.vertx.sqlclient.impl.tracing;

import io.vertx.core.Context;
import io.vertx.core.impl.ContextInternal;
import io.vertx.core.spi.tracing.TagExtractor;
import io.vertx.core.spi.tracing.VertxTracer;
import io.vertx.sqlclient.SqlConnectOptions;
import io.vertx.sqlclient.Tuple;
import io.vertx.sqlclient.impl.tracing.QueryRequest;
import java.util.Collections;
import java.util.List;
import java.util.function.Function;

public class QueryTracer {
    private static final TagExtractor<QueryRequest> REQUEST_TAG_EXTRACTOR = new TagExtractor<QueryRequest>(){
        private final RequestTags[] TAGS = RequestTags.values();

        public int len(QueryRequest obj) {
            return this.TAGS.length;
        }

        public String name(QueryRequest obj, int index) {
            return this.TAGS[index].name;
        }

        public String value(QueryRequest obj, int index) {
            return this.TAGS[index].fn.apply(obj);
        }
    };
    private final VertxTracer tracer;
    private final String address;
    private final String user;
    private final String database;

    public QueryTracer(VertxTracer tracer, String address, String user, String database) {
        this.tracer = tracer;
        this.address = address;
        this.user = user;
        this.database = database;
    }

    public QueryTracer(VertxTracer tracer, SqlConnectOptions options) {
        this(tracer, options.getHost() + ":" + options.getPort(), options.getUser(), options.getDatabase());
    }

    public Object sendRequest(ContextInternal context, String sql) {
        QueryRequest request = new QueryRequest(this, sql, Collections.emptyList());
        return this.tracer.sendRequest((Context)context, (Object)request, "Query", (k, v) -> {}, REQUEST_TAG_EXTRACTOR);
    }

    public Object sendRequest(ContextInternal context, String sql, Tuple tuple) {
        QueryRequest request = new QueryRequest(this, sql, Collections.singletonList(tuple));
        return this.tracer.sendRequest((Context)context, (Object)request, "Query", (k, v) -> {}, REQUEST_TAG_EXTRACTOR);
    }

    public Object sendRequest(ContextInternal context, String sql, List<Tuple> tuples) {
        QueryRequest request = new QueryRequest(this, sql, tuples);
        return this.tracer.sendRequest((Context)context, (Object)request, "Query", (k, v) -> {}, REQUEST_TAG_EXTRACTOR);
    }

    public void receiveResponse(ContextInternal context, Object payload, Object result, Throwable failure) {
        this.tracer.receiveResponse((Context)context, result, payload, failure, TagExtractor.empty());
    }

    static enum RequestTags {
        PEER_ADDRESS("peer.address", q -> QueryTracer.access$200(q.tracer)),
        SPAN_KIND("span.kind", q -> "client"),
        DB_USER("db.user", q -> QueryTracer.access$100(q.tracer)),
        DB_INSTANCE("db.instance", q -> QueryTracer.access$000(q.tracer)),
        DB_STATEMENT("db.statement", QueryRequest::sql),
        DB_TYPE("db.type", q -> "sql");

        final String name;
        final Function<QueryRequest, String> fn;

        private RequestTags(String name, Function<QueryRequest, String> fn) {
            this.name = name;
            this.fn = fn;
        }
    }
}

