/*
 * Decompiled with CFR 0.152.
 */
package io.vertx.sqlclient;

import io.vertx.codegen.annotations.Nullable;
import io.vertx.codegen.annotations.VertxGen;
import io.vertx.core.AsyncResult;
import io.vertx.core.Future;
import io.vertx.core.Handler;
import io.vertx.core.Vertx;
import io.vertx.sqlclient.PoolOptions;
import io.vertx.sqlclient.PreparedQuery;
import io.vertx.sqlclient.Query;
import io.vertx.sqlclient.Row;
import io.vertx.sqlclient.RowSet;
import io.vertx.sqlclient.SqlClient;
import io.vertx.sqlclient.SqlConnectOptions;
import io.vertx.sqlclient.SqlConnection;
import io.vertx.sqlclient.spi.Driver;
import java.util.ArrayList;
import java.util.ServiceConfigurationError;
import java.util.ServiceLoader;
import java.util.function.Function;

@VertxGen
public interface Pool
extends SqlClient {
    public static Pool pool(SqlConnectOptions connectOptions) {
        return Pool.pool(connectOptions, new PoolOptions());
    }

    public static Pool pool(SqlConnectOptions connectOptions, PoolOptions poolOptions) {
        ArrayList<Driver> candidates = new ArrayList<Driver>(1);
        for (Driver d : ServiceLoader.load(Driver.class)) {
            if (!d.acceptsOptions(connectOptions)) continue;
            candidates.add(d);
        }
        if (candidates.size() == 0) {
            throw new ServiceConfigurationError("No implementations of " + Driver.class + " found that accept connection options " + (Object)((Object)connectOptions));
        }
        if (candidates.size() > 1) {
            throw new ServiceConfigurationError("Multiple implementations of " + Driver.class + " found: " + candidates);
        }
        return ((Driver)candidates.get(0)).createPool(connectOptions, poolOptions);
    }

    public static Pool pool(Vertx vertx, SqlConnectOptions connectOptions, PoolOptions poolOptions) {
        ArrayList<Driver> candidates = new ArrayList<Driver>(1);
        for (Driver d : ServiceLoader.load(Driver.class)) {
            if (!d.acceptsOptions(connectOptions)) continue;
            candidates.add(d);
        }
        if (candidates.size() == 0) {
            throw new ServiceConfigurationError("No implementations of " + Driver.class + " found that accept connection options " + (Object)((Object)connectOptions));
        }
        if (candidates.size() > 1) {
            throw new ServiceConfigurationError("Multiple implementations of " + Driver.class + " found: " + candidates);
        }
        return ((Driver)candidates.get(0)).createPool(vertx, connectOptions, poolOptions);
    }

    public void getConnection(Handler<AsyncResult<SqlConnection>> var1);

    public Future<SqlConnection> getConnection();

    @Override
    public Query<RowSet<Row>> query(String var1);

    @Override
    public PreparedQuery<RowSet<Row>> preparedQuery(String var1);

    default public <T> void withTransaction(Function<SqlConnection, Future<@Nullable T>> function, Handler<AsyncResult<@Nullable T>> handler) {
        Future<T> res = this.withTransaction(function);
        if (handler != null) {
            res.onComplete(handler);
        }
    }

    default public <T> Future<@Nullable T> withTransaction(Function<SqlConnection, Future<@Nullable T>> function) {
        return this.getConnection().flatMap(conn -> conn.begin().flatMap(tx -> ((Future)function.apply((SqlConnection)conn)).compose(res -> tx.commit().flatMap(v -> Future.succeededFuture((Object)res)), err -> tx.rollback().compose(v -> Future.failedFuture((Throwable)err), failure -> Future.failedFuture((Throwable)err)))).onComplete(ar -> conn.close()));
    }

    default public <T> void withConnection(Function<SqlConnection, Future<@Nullable T>> function, Handler<AsyncResult<@Nullable T>> handler) {
        Future<T> res = this.withConnection(function);
        if (handler != null) {
            res.onComplete(handler);
        }
    }

    default public <T> Future<@Nullable T> withConnection(Function<SqlConnection, Future<@Nullable T>> function) {
        return this.getConnection().flatMap(conn -> ((Future)function.apply((SqlConnection)conn)).onComplete(ar -> conn.close()));
    }

    @Override
    public void close(Handler<AsyncResult<Void>> var1);
}

