/*
 * Decompiled with CFR 0.152.
 */
package io.vertx.sqlclient;

import io.vertx.codegen.annotations.DataObject;
import io.vertx.core.json.JsonObject;
import io.vertx.sqlclient.PoolOptionsConverter;
import java.util.Map;

@DataObject(generateConverter=true)
public class PoolOptions {
    public static final int DEFAULT_MAX_SIZE = 4;
    public static final int DEFAULT_MAX_WAIT_QUEUE_SIZE = -1;
    private int maxSize = 4;
    private int maxWaitQueueSize = -1;

    public PoolOptions() {
    }

    public PoolOptions(JsonObject json) {
        PoolOptionsConverter.fromJson((Iterable<Map.Entry<String, Object>>)json, this);
    }

    public PoolOptions(PoolOptions other) {
        this.maxSize = other.maxSize;
        this.maxWaitQueueSize = other.maxWaitQueueSize;
    }

    public int getMaxSize() {
        return this.maxSize;
    }

    public PoolOptions setMaxSize(int maxSize) {
        if (maxSize < 0) {
            throw new IllegalArgumentException("Max size cannot be negative");
        }
        this.maxSize = maxSize;
        return this;
    }

    public int getMaxWaitQueueSize() {
        return this.maxWaitQueueSize;
    }

    public PoolOptions setMaxWaitQueueSize(int maxWaitQueueSize) {
        this.maxWaitQueueSize = maxWaitQueueSize;
        return this;
    }

    public JsonObject toJson() {
        JsonObject json = new JsonObject();
        PoolOptionsConverter.toJson(this, json);
        return json;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof PoolOptions)) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        PoolOptions that = (PoolOptions)o;
        return this.maxSize == that.maxSize;
    }

    public int hashCode() {
        int result = super.hashCode();
        result = 31 * result + this.maxSize;
        return result;
    }
}

