/*
 * Decompiled with CFR 0.152.
 */
package io.vertx.sqlclient.impl;

import io.vertx.core.Promise;
import io.vertx.core.impl.CloseFuture;
import io.vertx.core.impl.EventLoopContext;
import io.vertx.core.impl.future.PromiseInternal;
import io.vertx.core.net.NetClient;
import io.vertx.core.net.NetClientOptions;
import io.vertx.core.net.SocketAddress;
import io.vertx.sqlclient.SqlConnectOptions;
import io.vertx.sqlclient.impl.Connection;
import io.vertx.sqlclient.impl.ConnectionFactory;
import java.util.Collections;
import java.util.Map;
import java.util.function.Predicate;

public abstract class SqlConnectionFactoryBase
implements ConnectionFactory {
    protected final NetClient netClient;
    protected final EventLoopContext context;
    protected final SocketAddress socketAddress;
    protected final String username;
    protected final String password;
    protected final String database;
    protected final Map<String, String> properties;
    protected final boolean cachePreparedStatements;
    protected final int preparedStatementCacheSize;
    protected final Predicate<String> preparedStatementCacheSqlFilter;
    protected final CloseFuture clientCloseFuture = new CloseFuture();
    private final int reconnectAttempts;
    private final long reconnectInterval;

    protected SqlConnectionFactoryBase(EventLoopContext context, SqlConnectOptions options) {
        this.context = context;
        this.socketAddress = options.getSocketAddress();
        this.username = options.getUser();
        this.password = options.getPassword();
        this.database = options.getDatabase();
        this.properties = options.getProperties() == null ? null : Collections.unmodifiableMap(options.getProperties());
        this.cachePreparedStatements = options.getCachePreparedStatements();
        this.preparedStatementCacheSize = options.getPreparedStatementCacheMaxSize();
        this.preparedStatementCacheSqlFilter = options.getPreparedStatementCacheSqlFilter();
        this.reconnectAttempts = options.getReconnectAttempts();
        this.reconnectInterval = options.getReconnectInterval();
        this.initializeConfiguration(options);
        NetClientOptions netClientOptions = new NetClientOptions((NetClientOptions)options);
        this.configureNetClientOptions(netClientOptions);
        netClientOptions.setReconnectAttempts(0);
        this.netClient = context.owner().createNetClient(netClientOptions, this.clientCloseFuture);
    }

    @Override
    public void connect(Promise<Connection> promise) {
        this.context.emit(promise, p -> this.doConnectWithRetry(promise, this.reconnectAttempts));
    }

    @Override
    public void close(Promise<Void> promise) {
        this.clientCloseFuture.close(promise);
    }

    private void doConnectWithRetry(Promise<Connection> promise, int remainingAttempts) {
        PromiseInternal promise0 = this.context.promise();
        promise0.future().onComplete(ar -> {
            if (ar.succeeded()) {
                promise.complete(ar.result());
            } else if (remainingAttempts >= 0) {
                this.context.owner().setTimer(this.reconnectInterval, id -> this.doConnectWithRetry(promise, remainingAttempts - 1));
            } else {
                promise.fail(ar.cause());
            }
        });
        this.doConnectInternal((Promise<Connection>)promise0);
    }

    protected abstract void initializeConfiguration(SqlConnectOptions var1);

    protected abstract void configureNetClientOptions(NetClientOptions var1);

    protected abstract void doConnectInternal(Promise<Connection> var1);
}

