/*
 * Decompiled with CFR 0.152.
 */
package io.vertx.sqlclient.tck;

import io.vertx.ext.unit.Async;
import io.vertx.ext.unit.TestContext;
import io.vertx.sqlclient.Tuple;
import io.vertx.sqlclient.tck.PreparedQueryTestBase;
import org.junit.Test;

public abstract class PreparedQueryCachedTestBase
extends PreparedQueryTestBase {
    @Override
    public void setUp(TestContext ctx) throws Exception {
        super.setUp(ctx);
        this.options.setCachePreparedStatements(true);
    }

    @Test
    public void testConcurrent(TestContext ctx) {
        this.connector.connect(ctx.asyncAssertSuccess(conn -> {
            int i;
            Async[] asyncs = new Async[10];
            for (i = 0; i < 10; ++i) {
                asyncs[i] = ctx.async();
            }
            for (i = 0; i < 10; ++i) {
                Async async = asyncs[i];
                conn.prepare(this.statement("SELECT * FROM Fortune WHERE id=", ""), ctx.asyncAssertSuccess(ps -> ps.query().execute(Tuple.of((Object)1), ctx.asyncAssertSuccess(results -> {
                    ctx.assertEquals((Object)1, (Object)results.size());
                    Tuple row = (Tuple)results.iterator().next();
                    ctx.assertEquals((Object)1, (Object)row.getInteger(0));
                    ctx.assertEquals((Object)"fortune: No such file or directory", (Object)row.getString(1));
                    async.complete();
                }))));
            }
        }));
    }

    @Test
    public void testClosedPreparedStatementEvictedFromCache(TestContext ctx) {
        Async async = ctx.async();
        this.options.setCachePreparedStatements(true);
        this.options.setPreparedStatementCacheMaxSize(1024);
        this.connector.connect(ctx.asyncAssertSuccess(conn -> conn.prepare("SELECT * FROM immutable", ctx.asyncAssertSuccess(preparedStatement1 -> preparedStatement1.query().execute(ctx.asyncAssertSuccess(res1 -> {
            ctx.assertEquals((Object)12, (Object)res1.size());
            preparedStatement1.close();
            this.vertx.setTimer(2000L, id -> conn.prepare("SELECT * FROM immutable", ctx.asyncAssertSuccess(preparedStatement2 -> preparedStatement2.query().execute(ctx.asyncAssertSuccess(res2 -> {
                ctx.assertEquals((Object)12, (Object)res2.size());
                conn.close();
                async.complete();
            })))));
        }))))));
        async.await();
    }

    @Test
    public void testConcurrentClose(TestContext ctx) {
        this.connector.connect(ctx.asyncAssertSuccess(conn -> conn.prepare("SELECT * FROM immutable", ctx.asyncAssertSuccess(preparedStatement1 -> preparedStatement1.query().execute(ctx.asyncAssertSuccess(res1 -> {
            ctx.assertEquals((Object)12, (Object)res1.size());
            preparedStatement1.close();
            conn.prepare("SELECT * FROM immutable", ctx.asyncAssertSuccess(preparedStatement2 -> preparedStatement2.query().execute(ctx.asyncAssertSuccess(res2 -> {
                ctx.assertEquals((Object)12, (Object)res2.size());
                conn.close();
            }))));
        }))))));
    }

    @Test
    public void testSqlLimitDoesNotAffectQuery(TestContext ctx) {
        this.options.setPreparedStatementCacheSqlLimit(1);
        this.connector.connect(ctx.asyncAssertSuccess(conn -> conn.preparedQuery("SELECT * FROM immutable").execute(ctx.asyncAssertSuccess(res -> {
            ctx.assertEquals((Object)12, (Object)res.size());
            conn.close();
        }))));
    }

    @Test
    public void testEvictedStmtClosing(TestContext ctx) {
        this.options.setCachePreparedStatements(true);
        this.options.setPreparedStatementCacheMaxSize(1);
        this.connector.connect(ctx.asyncAssertSuccess(conn -> conn.preparedQuery("SELECT * FROM immutable").execute(ctx.asyncAssertSuccess(res1 -> {
            ctx.assertEquals((Object)12, (Object)res1.size());
            conn.preparedQuery("SELECT * FROM mutable").execute(ctx.asyncAssertSuccess(res2 -> conn.preparedQuery("SELECT * FROM immutable").execute(ctx.asyncAssertSuccess(res3 -> {
                ctx.assertEquals((Object)12, (Object)res1.size());
                conn.close();
            }))));
        }))));
    }
}

