/*
 * Decompiled with CFR 0.152.
 */
package io.vertx.sqlclient.tck;

import io.vertx.core.AsyncResult;
import io.vertx.core.Future;
import io.vertx.core.Handler;
import io.vertx.core.Vertx;
import io.vertx.ext.unit.Async;
import io.vertx.ext.unit.TestContext;
import io.vertx.sqlclient.Pool;
import io.vertx.sqlclient.Row;
import io.vertx.sqlclient.SqlClient;
import io.vertx.sqlclient.SqlConnection;
import io.vertx.sqlclient.Transaction;
import io.vertx.sqlclient.TransactionRollbackException;
import io.vertx.sqlclient.Tuple;
import java.util.concurrent.atomic.AtomicReference;
import java.util.function.Consumer;
import org.junit.After;
import org.junit.Before;
import org.junit.Test;

public abstract class TransactionTestBase {
    protected Pool pool;
    protected Vertx vertx;
    protected Consumer<Handler<AsyncResult<Result>>> connector;

    protected abstract Pool createPool();

    protected synchronized Pool getPool() {
        if (this.pool == null) {
            this.pool = this.createPool();
        }
        return this.pool;
    }

    protected void initConnector() {
        this.connector = handler -> {
            Pool pool = this.getPool();
            pool.getConnection(ar1 -> {
                if (ar1.succeeded()) {
                    SqlConnection conn = (SqlConnection)ar1.result();
                    conn.begin(ar2 -> {
                        if (ar2.succeeded()) {
                            Transaction tx = (Transaction)ar2.result();
                            tx.completion().onComplete(ar3 -> conn.close());
                            handler.handle((Object)Future.succeededFuture((Object)new Result((SqlClient)conn, tx)));
                        } else {
                            conn.close();
                        }
                    });
                } else {
                    handler.handle((Object)ar1.mapEmpty());
                }
            });
        };
    }

    protected abstract Pool nonTxPool();

    protected abstract String statement(String ... var1);

    @Before
    public void setUp(TestContext ctx) throws Exception {
        this.vertx = Vertx.vertx();
        this.initConnector();
        this.cleanTestTable(ctx);
    }

    @After
    public void tearDown(TestContext ctx) {
        this.vertx.close(ctx.asyncAssertSuccess());
    }

    protected void cleanTestTable(TestContext ctx) {
        this.connector.accept((Handler<AsyncResult<Result>>)ctx.asyncAssertSuccess(res -> res.client.query("TRUNCATE TABLE mutable;").execute(ctx.asyncAssertSuccess(result -> res.tx.commit(ctx.asyncAssertSuccess())))));
    }

    @Test
    public void testReleaseConnectionOnCommit(TestContext ctx) {
        Async async = ctx.async();
        this.connector.accept((Handler<AsyncResult<Result>>)ctx.asyncAssertSuccess(res -> res.client.query("UPDATE Fortune SET message = 'Whatever' WHERE id = 9").execute(ctx.asyncAssertSuccess(result -> {
            ctx.assertEquals((Object)1, (Object)result.rowCount());
            res.tx.commit(ctx.asyncAssertSuccess(v1 -> this.pool.getConnection(ctx.asyncAssertSuccess(v2 -> async.complete()))));
        }))));
    }

    @Test
    public void testReleaseConnectionOnRollback(TestContext ctx) {
        Async async = ctx.async();
        this.connector.accept((Handler<AsyncResult<Result>>)ctx.asyncAssertSuccess(res -> {
            res.tx.completion().onComplete(ctx.asyncAssertFailure(err -> ctx.assertEquals((Object)TransactionRollbackException.INSTANCE, err)));
            res.client.query("UPDATE Fortune SET message = 'Whatever' WHERE id = 9").execute(ctx.asyncAssertSuccess(result -> {
                ctx.assertEquals((Object)1, (Object)result.rowCount());
                res.tx.rollback(ctx.asyncAssertSuccess(v1 -> this.pool.getConnection(ctx.asyncAssertSuccess(v2 -> async.complete()))));
            }));
        }));
    }

    @Test
    public void testCommitWithPreparedQuery(TestContext ctx) {
        Async async = ctx.async();
        this.connector.accept((Handler<AsyncResult<Result>>)ctx.asyncAssertSuccess(res -> res.client.preparedQuery(this.statement("INSERT INTO mutable (id, val) VALUES (", ",", ");")).execute(Tuple.of((Object)13, (Object)"test message1"), ctx.asyncAssertSuccess(result -> {
            ctx.assertEquals((Object)1, (Object)result.rowCount());
            res.tx.commit(ctx.asyncAssertSuccess(v1 -> res.client.query("SELECT id, val from mutable where id = 13").execute(ctx.asyncAssertSuccess(rowSet -> {
                ctx.assertEquals((Object)1, (Object)rowSet.size());
                Row row = (Row)rowSet.iterator().next();
                ctx.assertEquals((Object)13, (Object)row.getInteger("id"));
                ctx.assertEquals((Object)"test message1", (Object)row.getString("val"));
                async.complete();
            }))));
        }))));
    }

    @Test
    public void testCommitWithQuery(TestContext ctx) {
        Async async = ctx.async();
        this.connector.accept((Handler<AsyncResult<Result>>)ctx.asyncAssertSuccess(res -> res.client.query("INSERT INTO mutable (id, val) VALUES (14, 'test message2');").execute(ctx.asyncAssertSuccess(result -> {
            ctx.assertEquals((Object)1, (Object)result.rowCount());
            res.tx.commit(ctx.asyncAssertSuccess(v1 -> res.client.query("SELECT id, val from mutable where id = 14").execute(ctx.asyncAssertSuccess(rowSet -> {
                ctx.assertEquals((Object)1, (Object)rowSet.size());
                Row row = (Row)rowSet.iterator().next();
                ctx.assertEquals((Object)14, (Object)row.getInteger("id"));
                ctx.assertEquals((Object)"test message2", (Object)row.getString("val"));
                async.complete();
            }))));
        }))));
    }

    @Test
    public void testRollbackData(TestContext ctx) {
        Async async = ctx.async();
        this.connector.accept((Handler<AsyncResult<Result>>)ctx.asyncAssertSuccess(res -> res.client.query("UPDATE immutable SET message = 'roll me back' WHERE id = 7").execute(ctx.asyncAssertSuccess(result -> {
            ctx.assertEquals((Object)1, (Object)result.rowCount());
            res.tx.rollback(ctx.asyncAssertSuccess(v1 -> res.client.query("SELECT id, message from immutable where id = 7").execute(ctx.asyncAssertSuccess(rowSet -> {
                ctx.assertEquals((Object)1, (Object)rowSet.size());
                Row row = (Row)rowSet.iterator().next();
                ctx.assertEquals((Object)7, (Object)row.getInteger("id"));
                ctx.assertEquals((Object)"Any program that runs right is obsolete.", (Object)row.getString("message"));
                async.complete();
            }))));
        }))));
    }

    @Test
    public void testDelayedCommit(TestContext ctx) {
        Pool nonTxPool = this.nonTxPool();
        Async async = ctx.async();
        this.connector.accept((Handler<AsyncResult<Result>>)ctx.asyncAssertSuccess(res -> res.client.query("INSERT INTO mutable (id, val) VALUES (15, 'wait for it...')").execute(ctx.asyncAssertSuccess(result -> {
            ctx.assertEquals((Object)1, (Object)result.rowCount());
            res.client.query("SELECT id, val from mutable WHERE id = 15").execute(ctx.asyncAssertSuccess(txRows -> {
                ctx.assertEquals((Object)1, (Object)txRows.size());
                Row r = (Row)txRows.iterator().next();
                ctx.assertEquals((Object)15, (Object)r.getInteger("id"));
                ctx.assertEquals((Object)"wait for it...", (Object)r.getString("val"));
                nonTxPool.query("SELECT id, val from mutable WHERE id = 15").execute(ctx.asyncAssertSuccess(notFound -> {
                    ctx.assertEquals((Object)0, (Object)notFound.size());
                    res.tx.commit(ctx.asyncAssertSuccess(nonTxRows -> nonTxPool.query("SELECT id, val from mutable WHERE id = 15").execute(ctx.asyncAssertSuccess(nonTxFound -> {
                        ctx.assertEquals((Object)1, (Object)nonTxFound.size());
                        Row nonTxRow = (Row)nonTxFound.iterator().next();
                        ctx.assertEquals((Object)15, (Object)nonTxRow.getInteger("id"));
                        ctx.assertEquals((Object)"wait for it...", (Object)nonTxRow.getString("val"));
                        async.complete();
                    }))));
                }));
            }));
        }))));
    }

    @Test
    public void testFailureWithPendingQueries(TestContext ctx) {
        Async async = ctx.async();
        this.connector.accept((Handler<AsyncResult<Result>>)ctx.asyncAssertSuccess(res -> {
            res.client.query("SELECT whatever from DOES_NOT_EXIST").execute(ctx.asyncAssertFailure(v -> {}));
            res.client.query("SELECT id, val FROM mutable").execute(ctx.asyncAssertSuccess(err -> res.tx.commit(ctx.asyncAssertSuccess(v -> async.complete()))));
        }));
    }

    @Test
    public void testWithTransactionCommit(TestContext ctx) {
        Async async = ctx.async();
        Pool pool = this.createPool();
        pool.withTransaction(client -> client.query("INSERT INTO mutable (id, val) VALUES (1, 'hello-1')").execute().mapEmpty().flatMap(v -> client.query("INSERT INTO mutable (id, val) VALUES (2, 'hello-2')").execute().mapEmpty())).onComplete(ctx.asyncAssertSuccess(v -> pool.query("SELECT id, val FROM mutable").execute(ctx.asyncAssertSuccess(rows -> {
            ctx.assertEquals((Object)2, (Object)rows.size());
            async.complete();
        }))));
    }

    @Test
    public void testWithTransactionRollback(TestContext ctx) {
        Async async = ctx.async();
        Throwable failure = new Throwable();
        Pool pool = this.createPool();
        pool.withTransaction(client -> client.query("INSERT INTO mutable (id, val) VALUES (1, 'hello-1')").execute().mapEmpty().flatMap(v -> Future.failedFuture((Throwable)failure))).onComplete(ctx.asyncAssertFailure(err -> {
            ctx.assertEquals((Object)failure, err);
            pool.query("SELECT id, val FROM mutable").execute(ctx.asyncAssertSuccess(rows -> {
                ctx.assertEquals((Object)0, (Object)rows.size());
                async.complete();
            }));
        }));
    }

    @Test
    public void testWithTransactionImplicitRollback(TestContext ctx) {
        Async async = ctx.async();
        Pool pool = this.createPool();
        AtomicReference failure = new AtomicReference();
        pool.withTransaction(client -> client.query("INSERT INTO mutable (id, val) VALUES (1, 'hello-1')").execute().mapEmpty().flatMap(v -> client.query("INVALID").execute()).onFailure(failure::set)).onComplete(ctx.asyncAssertFailure(err -> {
            ctx.assertEquals(err, failure.get());
            pool.query("SELECT id, val FROM mutable").execute(ctx.asyncAssertSuccess(rows -> {
                ctx.assertEquals((Object)0, (Object)rows.size());
                async.complete();
            }));
        }));
    }

    protected static class Result {
        public final SqlClient client;
        public final Transaction tx;

        public Result(SqlClient client, Transaction tx) {
            this.client = client;
            this.tx = tx;
        }
    }
}

