/*
 * Decompiled with CFR 0.152.
 */
package io.vertx.sqlclient;

import io.vertx.sqlclient.Row;
import io.vertx.sqlclient.Tuple;
import java.io.Serializable;
import java.lang.invoke.SerializedLambda;
import java.lang.reflect.Array;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Objects;
import java.util.function.BiFunction;
import java.util.function.Consumer;
import java.util.function.Supplier;
import junit.framework.AssertionFailedError;
import org.junit.Assert;

public class ColumnChecker {
    private static List<SerializableBiFunction<Tuple, Integer, ?>> tupleMethods = new ArrayList();
    private static List<SerializableBiFunction<Row, String, ?>> rowMethods = new ArrayList();
    private final List<Method> blackList = new ArrayList<Method>();
    private final List<Consumer<? super Row>> expects = new ArrayList<Consumer<? super Row>>();
    private final int index;
    private final String name;

    public static SerializableBiFunction<Tuple, Integer, Object> getByIndex(Class<?> type) {
        return (tuple, index) -> tuple.get(type, index.intValue());
    }

    public static SerializableBiFunction<Row, String, Object> getByName(Class<?> type) {
        return (row, index) -> {
            int idx = row.getColumnIndex(index);
            return idx == -1 ? null : row.get(type, idx);
        };
    }

    public static SerializableBiFunction<Tuple, Integer, Object> getValuesByIndex(Class<?> type) {
        return (tuple, index) -> tuple.get(Array.newInstance(type, 0).getClass(), index.intValue());
    }

    public static SerializableBiFunction<Row, String, Object> getValuesByName(Class<?> type) {
        return (row, index) -> {
            int idx = row.getColumnIndex(index);
            return idx == -1 ? null : row.get(Array.newInstance(type, 0).getClass(), idx);
        };
    }

    public static void load(Supplier<List<SerializableBiFunction<Tuple, Integer, ?>>> tupleMethodsFactory, Supplier<List<SerializableBiFunction<Row, String, ?>>> rowMethodsFactory) {
        tupleMethods = tupleMethodsFactory.get();
        rowMethods = rowMethodsFactory.get();
    }

    public static ColumnChecker checkColumn(int index, String name) {
        return new ColumnChecker(index, name);
    }

    private ColumnChecker(int index, String name) {
        this.index = index;
        this.name = name;
    }

    public ColumnChecker returnsNull() {
        tupleMethods.forEach(m -> {
            this.blackList.add(m.method());
            this.expects.add(row -> {
                Object v = m.apply(row, this.index);
                Assert.assertNull(v);
            });
        });
        rowMethods.forEach(m -> {
            this.blackList.add(m.method());
            this.expects.add(row -> {
                Object v = m.apply(row, this.name);
                Assert.assertNull(v);
            });
        });
        return this;
    }

    public <R> ColumnChecker returns(Class<R> type, R expected) {
        return this.returns(ColumnChecker.getByIndex(type), ColumnChecker.getByName(type), expected);
    }

    public <R> ColumnChecker returns(Class<R> type, R[] expected) {
        return this.returns(ColumnChecker.getValuesByIndex(type), ColumnChecker.getValuesByName(type), expected);
    }

    public <R> ColumnChecker returns(SerializableBiFunction<Tuple, Integer, R> byIndexGetter, SerializableBiFunction<Row, String, R> byNameGetter, Consumer<R> check) {
        Method byIndexMeth = byIndexGetter.method();
        this.blackList.add(byIndexMeth);
        Method byNameMeth = byNameGetter.method();
        this.blackList.add(byNameMeth);
        this.expects.add(row -> {
            Object actual = byIndexGetter.apply((Integer)row, this.index);
            try {
                check.accept(actual);
            }
            catch (AssertionError cause) {
                AssertionFailedError failure = new AssertionFailedError("Expected that " + byIndexMeth + " would not fail: " + ((Throwable)((Object)cause)).getMessage());
                failure.setStackTrace(failure.getStackTrace());
                throw failure;
            }
            actual = byNameGetter.apply((String)row, this.name);
            try {
                check.accept(actual);
            }
            catch (AssertionError cause) {
                AssertionFailedError failure = new AssertionFailedError("Expected that " + byNameMeth + " would not fail: " + ((Throwable)((Object)cause)).getMessage());
                failure.setStackTrace(failure.getStackTrace());
                throw failure;
            }
        });
        return this;
    }

    public <R> ColumnChecker returns(SerializableBiFunction<Tuple, Integer, R> byIndexGetter, SerializableBiFunction<Row, String, R> byNameGetter, R expected) {
        return this.returns(byIndexGetter, byNameGetter, (R)((Consumer<Object>)actual -> Assert.assertEquals((Object)expected, (Object)actual)));
    }

    public ColumnChecker returns(SerializableBiFunction<Tuple, Integer, Object> byIndexGetter, SerializableBiFunction<Row, String, Object> byNameGetter, Object[] expected) {
        Method byIndexMeth = byIndexGetter.method();
        this.blackList.add(byIndexMeth);
        Method byNameMeth = byNameGetter.method();
        this.blackList.add(byNameMeth);
        this.expects.add(row -> {
            Object[] actual = ColumnChecker.toObjectArray(byIndexGetter.apply((Integer)row, this.index));
            Assert.assertArrayEquals((String)("Expected that " + byIndexMeth + " returns " + Arrays.toString(expected) + " instead of " + Arrays.toString(actual)), (Object[])expected, (Object[])actual);
            actual = ColumnChecker.toObjectArray(byNameGetter.apply((String)row, this.name));
            Assert.assertArrayEquals((String)("Expected that " + byNameMeth + " returns " + Arrays.toString(expected) + " instead of " + Arrays.toString(actual)), (Object[])expected, (Object[])actual);
        });
        return this;
    }

    public ColumnChecker skip(SerializableBiFunction<Tuple, Integer, Object> byIndexGetter, SerializableBiFunction<Row, String, Object> byNameGetter) {
        Method byIndexMeth = byIndexGetter.method();
        this.blackList.add(byIndexMeth);
        Method byNameMeth = byNameGetter.method();
        this.blackList.add(byNameMeth);
        return this;
    }

    public ColumnChecker returns(SerializableBiFunction<Tuple, Integer, Double> byIndexGetter, SerializableBiFunction<Row, String, Double> byNameGetter, double expected, double delta) {
        this.blackList.add(byIndexGetter.method());
        this.blackList.add(byNameGetter.method());
        this.expects.add(row -> {
            Object actual = byIndexGetter.apply((Integer)row, this.index);
            Assert.assertEquals((String)("Expected that " + byIndexGetter.method() + " returns " + expected + " instead of " + actual), (double)expected, (double)((Double)actual), (double)delta);
            actual = byNameGetter.apply((String)row, this.name);
            Assert.assertEquals((String)("Expected that " + byNameGetter.method() + " returns " + expected + " instead of " + actual), (double)expected, (double)((Double)actual), (double)delta);
        });
        return this;
    }

    public ColumnChecker returns(SerializableBiFunction<Tuple, Integer, Float> byIndexGetter, SerializableBiFunction<Row, String, Float> byNameGetter, float expected, float delta) {
        this.blackList.add(byIndexGetter.method());
        this.blackList.add(byNameGetter.method());
        this.expects.add(row -> {
            Object actual = byIndexGetter.apply((Integer)row, this.index);
            Assert.assertEquals((String)("Expected that " + byIndexGetter.method() + " returns " + expected + " instead of " + actual), (float)expected, (float)((Float)actual).floatValue(), (float)delta);
            actual = byNameGetter.apply((String)row, this.name);
            Assert.assertEquals((String)("Expected that " + byNameGetter.method() + " returns " + expected + " instead of " + actual), (float)expected, (float)((Float)actual).floatValue(), (float)delta);
        });
        return this;
    }

    public <R> ColumnChecker fails(SerializableBiFunction<Tuple, Integer, R> byIndexGetter, SerializableBiFunction<Row, String, R> byNameGetter) {
        this.blackList.add(byIndexGetter.method());
        this.blackList.add(byNameGetter.method());
        this.expects.add(row -> {
            try {
                byIndexGetter.apply((Integer)row, this.index);
                Assert.fail((String)("Expected that " + byIndexGetter.method() + " would throw an exception"));
            }
            catch (Exception exception) {
                // empty catch block
            }
            try {
                byNameGetter.apply((String)row, this.name);
                Assert.fail((String)("Expected that " + byNameGetter.method() + " would throw an exception"));
            }
            catch (Exception exception) {
                // empty catch block
            }
        });
        return this;
    }

    public void forRow(Row row) {
        for (SerializableBiFunction<Tuple, Integer, ?> serializableBiFunction : tupleMethods) {
            if (this.blackList.contains(serializableBiFunction.method())) continue;
            try {
                Object v2 = serializableBiFunction.apply((Integer)row, this.index);
                Assert.fail((String)("Was expecting " + serializableBiFunction.method() + " to throw ClassCastException instead of returning " + v2));
            }
            catch (ClassCastException v2) {}
        }
        for (SerializableBiFunction<Object, Object, ?> serializableBiFunction : rowMethods) {
            if (this.blackList.contains(serializableBiFunction.method())) continue;
            try {
                Object v = serializableBiFunction.apply(row, this.name);
                Assert.fail((String)("Was expecting " + serializableBiFunction.method() + " to throw ClassCastException instead of returning " + v));
            }
            catch (ClassCastException classCastException) {}
        }
        for (Consumer consumer : this.expects) {
            consumer.accept(row);
        }
    }

    public static Object[] toObjectArray(Object source) {
        if (source instanceof Object[]) {
            return (Object[])source;
        }
        if (source == null) {
            return new Object[0];
        }
        if (!source.getClass().isArray()) {
            throw new IllegalArgumentException("Source is not an array: " + source);
        }
        int length = Array.getLength(source);
        if (length == 0) {
            return new Object[0];
        }
        Class<?> wrapperType = Array.get(source, 0).getClass();
        Object[] newArray = (Object[])Array.newInstance(wrapperType, length);
        for (int i = 0; i < length; ++i) {
            newArray[i] = Array.get(source, i);
        }
        return newArray;
    }

    public static interface SerializableBiFunction<O, T, R>
    extends BiFunction<O, T, R>,
    Serializable,
    MethodReferenceReflection {
    }

    static interface MethodReferenceReflection {
        default public SerializedLambda serialized() {
            try {
                Method replaceMethod = this.getClass().getDeclaredMethod("writeReplace", new Class[0]);
                replaceMethod.setAccessible(true);
                return (SerializedLambda)replaceMethod.invoke((Object)this, new Object[0]);
            }
            catch (Exception e) {
                throw new RuntimeException(e);
            }
        }

        default public Class getContainingClass() {
            try {
                String className = this.serialized().getImplClass().replaceAll("/", ".");
                return Class.forName(className);
            }
            catch (Exception e) {
                throw new RuntimeException(e);
            }
        }

        default public Method method() {
            SerializedLambda lambda = this.serialized();
            Class containingClass = this.getContainingClass();
            return Arrays.stream(containingClass.getDeclaredMethods()).filter(method -> Objects.equals(method.getName(), lambda.getImplMethodName())).findFirst().orElseThrow(UnableToGuessMethodException::new);
        }

        public static class UnableToGuessMethodException
        extends RuntimeException {
        }
    }
}

