/*
 * Decompiled with CFR 0.152.
 */
package io.vertx.sqlclient.impl;

import io.vertx.sqlclient.impl.HexSequence;
import org.junit.Assert;
import org.junit.Test;

public class HexSequenceTest {
    @Test
    public void testStartValue() {
        HexSequenceTest.assertEquals("0000000", new HexSequence().next());
        HexSequenceTest.assertEquals("0000000", new HexSequence(0L).next());
        HexSequenceTest.assertEquals("000000A", new HexSequence(10L).next());
        HexSequenceTest.assertEquals("000FFFF", new HexSequence(65535L).next());
        HexSequenceTest.assertEquals("00010000", new HexSequence(65536L).next());
        HexSequenceTest.assertEquals("000ABCDEF", new HexSequence(11259375L).next());
    }

    @Test
    public void testSequence() {
        HexSequence seq = new HexSequence();
        HexSequenceTest.assertEquals("0000000", seq.next());
        HexSequenceTest.assertEquals("0000001", seq.next());
        HexSequenceTest.assertEquals("0000002", seq.next());
        HexSequenceTest.assertEquals("0000003", seq.next());
        HexSequenceTest.assertEquals("0000004", seq.next());
        HexSequenceTest.assertEquals("0000005", seq.next());
        HexSequenceTest.assertEquals("0000006", seq.next());
        HexSequenceTest.assertEquals("0000007", seq.next());
        HexSequenceTest.assertEquals("0000008", seq.next());
        HexSequenceTest.assertEquals("0000009", seq.next());
        HexSequenceTest.assertEquals("000000A", seq.next());
        HexSequenceTest.assertEquals("000000B", seq.next());
        HexSequenceTest.assertEquals("000000C", seq.next());
        HexSequenceTest.assertEquals("000000D", seq.next());
        HexSequenceTest.assertEquals("000000E", seq.next());
        HexSequenceTest.assertEquals("000000F", seq.next());
        HexSequenceTest.assertEquals("0000010", seq.next());
        HexSequenceTest.assertEquals("0000011", seq.next());
    }

    @Test
    public void testIncrement() {
        HexSequenceTest.assertIncrement("0000100", 255L);
        HexSequenceTest.assertIncrement("0000F00", 3839L);
        HexSequenceTest.assertIncrement("0001000", 4095L);
        HexSequenceTest.assertIncrement("000A000", 40959L);
        HexSequenceTest.assertIncrement("00010000", 65535L);
        HexSequenceTest.assertIncrement("000100000", 1048575L);
        HexSequenceTest.assertIncrement("0001000000", 0xFFFFFFL);
        HexSequenceTest.assertIncrement("000FFFFFFFFFFFFFFFF", -2L);
        HexSequenceTest.assertIncrement("0000000", -1L);
        HexSequenceTest.assertIncrement("0000000", -1L);
    }

    private static void assertIncrement(String incremented, long start) {
        HexSequence hex = new HexSequence(start);
        hex.next();
        HexSequenceTest.assertEquals(incremented, hex.next());
    }

    private static void assertEquals(String expected, byte[] actual) {
        Assert.assertEquals((Object)(expected + "\u0000"), (Object)new String(actual));
    }
}

