/*
 * Decompiled with CFR 0.152.
 */
package io.vertx.sqlclient.impl;

import io.vertx.core.buffer.Buffer;
import io.vertx.core.json.JsonArray;
import io.vertx.core.json.JsonObject;
import io.vertx.sqlclient.Tuple;
import io.vertx.sqlclient.data.NullValue;
import java.math.BigDecimal;
import java.time.Instant;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.time.LocalTime;
import java.time.OffsetDateTime;
import java.time.OffsetTime;
import java.time.ZoneOffset;
import java.time.temporal.Temporal;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.UUID;
import java.util.function.BiFunction;
import java.util.function.Consumer;
import java.util.function.Function;
import org.junit.Assert;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.junit.runners.Parameterized;

@RunWith(value=Parameterized.class)
public class TupleTest {
    private TupleKind kind;
    private final LocalTime localTime = LocalTime.parse("19:35:58.237666");
    private final OffsetTime offsetTime = OffsetTime.of(this.localTime, ZoneOffset.UTC);
    private final LocalDate localDate = LocalDate.parse("2017-05-14");
    private final LocalDateTime localDateTime = LocalDateTime.of(this.localDate, this.localTime);
    private final OffsetDateTime offsetDateTime = OffsetDateTime.of(this.localDateTime, ZoneOffset.UTC);
    private final JsonObject jsonObject = new JsonObject().put("msg", (Object)"hello");
    private final JsonArray jsonArray = new JsonArray().add((Object)1).add((Object)2);
    private final List<Number> numbers = Arrays.asList((short)3, 4, 5L, Float.valueOf(6.0f), 7.0);

    @Parameterized.Parameters
    public static Collection<Object[]> data() {
        return Arrays.asList({TupleKind.ELEMENTS}, {TupleKind.LIST}, {TupleKind.WRAP_LIST}, {TupleKind.WRAP_ARRAY});
    }

    public TupleTest(TupleKind kind) {
        this.kind = kind;
    }

    public Tuple tuple() {
        return this.kind.tuple();
    }

    public Tuple of(Object ... elements) {
        return this.kind.of(elements);
    }

    @Test
    public void testNumbers() {
        Tuple tuple = this.of((byte)127, (short)4000, 1000000, 1000000000L, Float.valueOf(4.5f), 4.5);
        Assert.assertEquals((long)127L, (long)tuple.getShort(0).shortValue());
        Assert.assertEquals((long)4000L, (long)tuple.getShort(1).shortValue());
        Assert.assertEquals((long)4L, (long)tuple.getShort(4).shortValue());
        Assert.assertEquals((long)4L, (long)tuple.getShort(5).shortValue());
        Assert.assertEquals((long)127L, (long)tuple.getInteger(0).intValue());
        Assert.assertEquals((long)4000L, (long)tuple.getInteger(1).intValue());
        Assert.assertEquals((long)1000000L, (long)tuple.getInteger(2).intValue());
        Assert.assertEquals((long)1000000000L, (long)tuple.getInteger(3).intValue());
        Assert.assertEquals((long)4L, (long)tuple.getInteger(4).intValue());
        Assert.assertEquals((long)4L, (long)tuple.getInteger(5).intValue());
        Assert.assertEquals((long)127L, (long)tuple.getLong(0));
        Assert.assertEquals((long)4000L, (long)tuple.getLong(1));
        Assert.assertEquals((long)1000000L, (long)tuple.getLong(2));
        Assert.assertEquals((long)1000000000L, (long)tuple.getLong(3));
        Assert.assertEquals((long)4L, (long)tuple.getLong(4));
        Assert.assertEquals((long)4L, (long)tuple.getLong(5));
        Assert.assertEquals((float)127.0f, (float)tuple.getFloat(0).floatValue(), (float)0.0f);
        Assert.assertEquals((float)4000.0f, (float)tuple.getFloat(1).floatValue(), (float)0.0f);
        Assert.assertEquals((float)1000000.0f, (float)tuple.getFloat(2).floatValue(), (float)0.0f);
        Assert.assertEquals((float)1.0E9f, (float)tuple.getFloat(3).floatValue(), (float)0.0f);
        Assert.assertEquals((double)4.5, (double)tuple.getFloat(4).floatValue(), (double)0.0);
        Assert.assertEquals((double)4.5, (double)tuple.getFloat(5).floatValue(), (double)0.0);
        Assert.assertEquals((double)127.0, (double)tuple.getDouble(0), (double)0.0);
        Assert.assertEquals((double)4000.0, (double)tuple.getDouble(1), (double)0.0);
        Assert.assertEquals((double)1000000.0, (double)tuple.getDouble(2), (double)0.0);
        Assert.assertEquals((double)1.0E9, (double)tuple.getDouble(3), (double)0.0);
        Assert.assertEquals((double)4.5, (double)tuple.getDouble(4), (double)0.0);
        Assert.assertEquals((double)4.5, (double)tuple.getDouble(5), (double)0.0);
        this.testNumber(Number::shortValue, Tuple::getShort, Tuple::getArrayOfShorts);
        this.testNumber(Number::intValue, Tuple::getInteger, Tuple::getArrayOfIntegers);
        this.testNumber(Number::longValue, Tuple::getLong, Tuple::getArrayOfLongs);
        this.testNumber(Number::floatValue, Tuple::getFloat, Tuple::getArrayOfFloats);
        this.testNumber(Number::doubleValue, Tuple::getDouble, Tuple::getArrayOfDoubles);
    }

    private <T extends Number> void testNumber(Function<Number, T> f, BiFunction<Tuple, Integer, T> abc, BiFunction<Tuple, Integer, T[]> def) {
        Tuple tuple;
        for (Number number : this.numbers) {
            tuple = this.of(number);
            Assert.assertEquals(f.apply(number), abc.apply(tuple, 0));
        }
        tuple = this.of(new Object[]{this.numbers.toArray(new Object[0])});
        Number[] array = (Number[])def.apply(tuple, 0);
        Assert.assertEquals((long)5L, (long)array.length);
        for (int i = 0; i < array.length; ++i) {
            Assert.assertEquals(f.apply(this.numbers.get(i)), (Object)array[i]);
        }
    }

    @Test
    public void testAccessors() {
        Tuple tuple = this.tuple();
        tuple.addBoolean(Boolean.valueOf(true));
        tuple.addShort(Short.valueOf((short)123));
        tuple.addInteger(Integer.valueOf(12345));
        tuple.addLong(Long.valueOf(12345678L));
        tuple.addFloat(Float.valueOf(1.23f));
        tuple.addDouble(Double.valueOf(1.23));
        tuple.addString("hello");
        tuple.addBuffer(Buffer.buffer((String)"hello"));
        tuple.addTemporal((Temporal)Instant.MAX);
        tuple.addLocalDate(LocalDate.MAX);
        tuple.addLocalTime(LocalTime.MAX);
        tuple.addLocalDateTime(LocalDateTime.MAX);
        tuple.addOffsetTime(OffsetTime.MAX);
        tuple.addOffsetDateTime(OffsetDateTime.MAX);
        UUID uuid = UUID.randomUUID();
        tuple.addUUID(uuid);
        tuple.addBigDecimal(BigDecimal.ZERO);
        Assert.assertEquals((Object)true, (Object)tuple.getBoolean(0));
        Assert.assertEquals((Object)true, (Object)tuple.getValue(0));
        Assert.assertEquals((Object)true, (Object)tuple.get(Boolean.class, 0));
        Assert.assertEquals((long)123L, (long)tuple.getShort(1).shortValue());
        Assert.assertEquals((long)123L, (long)((Short)tuple.getValue(1)).shortValue());
        Assert.assertEquals((long)123L, (long)((Short)tuple.get(Short.class, 1)).shortValue());
        Assert.assertEquals((long)12345L, (long)tuple.getInteger(2).intValue());
        Assert.assertEquals((long)12345L, (long)((Integer)tuple.getValue(2)).intValue());
        Assert.assertEquals((long)12345L, (long)((Integer)tuple.get(Integer.class, 2)).intValue());
        Assert.assertEquals((long)12345678L, (long)tuple.getLong(3));
        Assert.assertEquals((long)12345678L, (long)((Long)tuple.getValue(3)));
        Assert.assertEquals((long)12345678L, (long)((Long)tuple.get(Long.class, 3)));
        Assert.assertEquals((float)1.23f, (float)tuple.getFloat(4).floatValue(), (float)0.0f);
        Assert.assertEquals((float)1.23f, (float)((Float)tuple.getValue(4)).floatValue(), (float)0.0f);
        Assert.assertEquals((float)1.23f, (float)((Float)tuple.get(Float.class, 4)).floatValue(), (float)0.0f);
        Assert.assertEquals((double)1.23, (double)tuple.getDouble(5), (double)0.0);
        Assert.assertEquals((double)1.23, (double)((Double)tuple.getValue(5)), (double)0.0);
        Assert.assertEquals((double)1.23, (double)((Double)tuple.get(Double.class, 5)), (double)0.0);
        Assert.assertEquals((Object)"hello", (Object)tuple.getString(6));
        Assert.assertEquals((Object)"hello", (Object)tuple.getValue(6));
        Assert.assertEquals((Object)"hello", (Object)tuple.get(String.class, 6));
        Assert.assertEquals((Object)Buffer.buffer((String)"hello"), (Object)tuple.getBuffer(7));
        Assert.assertEquals((Object)Buffer.buffer((String)"hello"), (Object)tuple.getValue(7));
        Assert.assertEquals((Object)Buffer.buffer((String)"hello"), (Object)tuple.get(Buffer.class, 7));
        Assert.assertEquals((Object)Instant.MAX, (Object)tuple.getTemporal(8));
        Assert.assertEquals((Object)Instant.MAX, (Object)tuple.getValue(8));
        Assert.assertEquals((Object)Instant.MAX, (Object)tuple.get(Temporal.class, 8));
        Assert.assertEquals((Object)LocalDate.MAX, (Object)tuple.getLocalDate(9));
        Assert.assertEquals((Object)LocalDate.MAX, (Object)tuple.getValue(9));
        Assert.assertEquals((Object)LocalDate.MAX, (Object)tuple.get(LocalDate.class, 9));
        Assert.assertEquals((Object)LocalTime.MAX, (Object)tuple.getLocalTime(10));
        Assert.assertEquals((Object)LocalTime.MAX, (Object)tuple.getValue(10));
        Assert.assertEquals((Object)LocalTime.MAX, (Object)tuple.get(LocalTime.class, 10));
        Assert.assertEquals((Object)LocalDateTime.MAX, (Object)tuple.getLocalDateTime(11));
        Assert.assertEquals((Object)LocalDateTime.MAX, (Object)tuple.getValue(11));
        Assert.assertEquals((Object)LocalDateTime.MAX, (Object)tuple.get(LocalDateTime.class, 11));
        Assert.assertEquals((Object)OffsetTime.MAX, (Object)tuple.getOffsetTime(12));
        Assert.assertEquals((Object)OffsetTime.MAX, (Object)tuple.getValue(12));
        Assert.assertEquals((Object)OffsetTime.MAX, (Object)tuple.get(OffsetTime.class, 12));
        Assert.assertEquals((Object)OffsetDateTime.MAX, (Object)tuple.getOffsetDateTime(13));
        Assert.assertEquals((Object)OffsetDateTime.MAX, (Object)tuple.getValue(13));
        Assert.assertEquals((Object)OffsetDateTime.MAX, (Object)tuple.get(OffsetDateTime.class, 13));
        Assert.assertEquals((Object)uuid, (Object)tuple.getUUID(14));
        Assert.assertEquals((Object)uuid, (Object)tuple.getValue(14));
        Assert.assertEquals((Object)uuid, (Object)tuple.get(UUID.class, 14));
        Assert.assertEquals((Object)BigDecimal.ZERO, (Object)tuple.getBigDecimal(15));
        Assert.assertEquals((Object)BigDecimal.ZERO, (Object)tuple.getValue(15));
        Assert.assertEquals((Object)BigDecimal.ZERO, (Object)tuple.get(BigDecimal.class, 15));
        try {
            tuple.get(String.class, 7);
        }
        catch (IllegalArgumentException e) {
            Assert.assertEquals((Object)"mismatched type [java.lang.String] for the value of type [io.vertx.core.buffer.impl.BufferImpl]", (Object)e.getMessage());
        }
        try {
            tuple.get(null, 1);
        }
        catch (IllegalArgumentException e) {
            Assert.assertEquals((Object)"Accessor type can not be null", (Object)e.getMessage());
        }
    }

    @Test
    public void testArrayAccessors() {
        Object[] booleanArray = new Boolean[]{true};
        Object[] shortArray = new Short[]{(short)123};
        Object[] integerArray = new Integer[]{12345};
        Object[] longArray = new Long[]{12345678L};
        Object[] floatArray = new Float[]{Float.valueOf(1.23f)};
        Object[] doubleArray = new Double[]{1.23};
        Object[] stringArray = new String[]{"hello"};
        Object[] bufferArray = new Buffer[]{Buffer.buffer((String)"hello")};
        Object[] localDateArray = new LocalDate[]{LocalDate.MAX};
        Object[] localTimeArray = new LocalTime[]{LocalTime.MAX};
        Object[] localDateTimeArray = new LocalDateTime[]{LocalDateTime.MAX};
        Object[] offsetTimeArray = new OffsetTime[]{OffsetTime.MAX};
        Object[] offsetDateTimeArray = new OffsetDateTime[]{OffsetDateTime.MAX};
        Object[] uuidArray = new UUID[]{UUID.randomUUID()};
        Tuple tuple = this.tuple();
        tuple.addArrayOfBoolean((Boolean[])booleanArray);
        tuple.addArrayOfShort((Short[])shortArray);
        tuple.addArrayOfInteger((Integer[])integerArray);
        tuple.addArrayOfLong((Long[])longArray);
        tuple.addArrayOfFloat((Float[])floatArray);
        tuple.addArrayOfDouble((Double[])doubleArray);
        tuple.addArrayOfString((String[])stringArray);
        tuple.addArrayOfBuffer((Buffer[])bufferArray);
        tuple.addArrayOfLocalDate((LocalDate[])localDateArray);
        tuple.addArrayOfLocalTime((LocalTime[])localTimeArray);
        tuple.addArrayOfLocalDateTime((LocalDateTime[])localDateTimeArray);
        tuple.addArrayOfOffsetTime((OffsetTime[])offsetTimeArray);
        tuple.addArrayOfOffsetDateTime((OffsetDateTime[])offsetDateTimeArray);
        tuple.addArrayOfUUID((UUID[])uuidArray);
        Assert.assertArrayEquals((Object[])booleanArray, (Object[])tuple.getArrayOfBooleans(0));
        Assert.assertArrayEquals((Object[])booleanArray, (Object[])((Boolean[])tuple.getValue(0)));
        Assert.assertArrayEquals((Object[])booleanArray, (Object[])((Object[])tuple.get(Boolean[].class, 0)));
        Assert.assertArrayEquals((Object[])shortArray, (Object[])tuple.getArrayOfShorts(1));
        Assert.assertArrayEquals((Object[])shortArray, (Object[])((Short[])tuple.getValue(1)));
        Assert.assertArrayEquals((Object[])shortArray, (Object[])((Object[])tuple.get(Short[].class, 1)));
        Assert.assertArrayEquals((Object[])integerArray, (Object[])tuple.getArrayOfIntegers(2));
        Assert.assertArrayEquals((Object[])integerArray, (Object[])((Integer[])tuple.getValue(2)));
        Assert.assertArrayEquals((Object[])integerArray, (Object[])((Object[])tuple.get(Integer[].class, 2)));
        Assert.assertArrayEquals((Object[])longArray, (Object[])tuple.getArrayOfLongs(3));
        Assert.assertArrayEquals((Object[])longArray, (Object[])((Long[])tuple.getValue(3)));
        Assert.assertArrayEquals((Object[])longArray, (Object[])((Long[])tuple.get(Long[].class, 3)));
        Assert.assertArrayEquals((Object[])floatArray, (Object[])tuple.getArrayOfFloats(4));
        Assert.assertArrayEquals((Object[])floatArray, (Object[])((Float[])tuple.getValue(4)));
        Assert.assertArrayEquals((Object[])floatArray, (Object[])((Object[])tuple.get(Float[].class, 4)));
        Assert.assertArrayEquals((Object[])doubleArray, (Object[])tuple.getArrayOfDoubles(5));
        Assert.assertArrayEquals((Object[])doubleArray, (Object[])((Double[])tuple.getValue(5)));
        Assert.assertArrayEquals((Object[])doubleArray, (Object[])((Object[])tuple.get(Double[].class, 5)));
        Assert.assertArrayEquals((Object[])stringArray, (Object[])tuple.getArrayOfStrings(6));
        Assert.assertArrayEquals((Object[])stringArray, (Object[])((String[])tuple.getValue(6)));
        Assert.assertArrayEquals((Object[])stringArray, (Object[])((Object[])tuple.get(String[].class, 6)));
        Assert.assertArrayEquals((Object[])bufferArray, (Object[])tuple.getArrayOfBuffers(7));
        Assert.assertArrayEquals((Object[])bufferArray, (Object[])((Buffer[])tuple.getValue(7)));
        Assert.assertArrayEquals((Object[])bufferArray, (Object[])((Object[])tuple.get(Buffer[].class, 7)));
        Assert.assertArrayEquals((Object[])localDateArray, (Object[])tuple.getArrayOfLocalDates(8));
        Assert.assertArrayEquals((Object[])localDateArray, (Object[])((LocalDate[])tuple.getValue(8)));
        Assert.assertArrayEquals((Object[])localDateArray, (Object[])((Object[])tuple.get(LocalDate[].class, 8)));
        Assert.assertArrayEquals((Object[])localTimeArray, (Object[])tuple.getArrayOfLocalTimes(9));
        Assert.assertArrayEquals((Object[])localTimeArray, (Object[])((LocalTime[])tuple.getValue(9)));
        Assert.assertArrayEquals((Object[])localTimeArray, (Object[])((Object[])tuple.get(LocalTime[].class, 9)));
        Assert.assertArrayEquals((Object[])localDateTimeArray, (Object[])tuple.getArrayOfLocalDateTimes(10));
        Assert.assertArrayEquals((Object[])localDateTimeArray, (Object[])((LocalDateTime[])tuple.getValue(10)));
        Assert.assertArrayEquals((Object[])localDateTimeArray, (Object[])((Object[])tuple.get(LocalDateTime[].class, 10)));
        Assert.assertArrayEquals((Object[])offsetTimeArray, (Object[])tuple.getArrayOfOffsetTimes(11));
        Assert.assertArrayEquals((Object[])offsetTimeArray, (Object[])((Object[])tuple.getValue(11)));
        Assert.assertArrayEquals((Object[])offsetTimeArray, (Object[])((Object[])tuple.get(OffsetTime[].class, 11)));
        Assert.assertArrayEquals((Object[])offsetDateTimeArray, (Object[])tuple.getArrayOfOffsetDateTimes(12));
        Assert.assertArrayEquals((Object[])offsetDateTimeArray, (Object[])((OffsetDateTime[])tuple.getValue(12)));
        Assert.assertArrayEquals((Object[])offsetDateTimeArray, (Object[])((Object[])tuple.get(OffsetDateTime[].class, 12)));
        Assert.assertArrayEquals((Object[])uuidArray, (Object[])tuple.getArrayOfUUIDs(13));
        Assert.assertArrayEquals((Object[])uuidArray, (Object[])((UUID[])tuple.getValue(13)));
        Assert.assertArrayEquals((Object[])uuidArray, (Object[])((Object[])tuple.get(UUID[].class, 13)));
        try {
            tuple.get(Buffer[].class, 10);
        }
        catch (IllegalArgumentException e) {
            Assert.assertEquals((Object)"mismatched array element type [io.vertx.core.buffer.Buffer] for the value of type [[Ljava.time.LocalDateTime;]", (Object)e.getMessage());
        }
        try {
            tuple.get(null, 1);
        }
        catch (IllegalArgumentException e) {
            Assert.assertEquals((Object)"Accessor type can not be null", (Object)e.getMessage());
        }
    }

    @Test
    public void testShortArrayCoercion() {
        Tuple tuple = this.of(new Object[]{new Long[]{5L, null, Long.MAX_VALUE}});
        Short[] res = tuple.getArrayOfShorts(0);
        Assert.assertEquals((long)3L, (long)res.length);
        Assert.assertEquals((long)5L, (long)res[0].shortValue());
        Assert.assertNull((Object)res[1]);
        Assert.assertEquals((long)Long.valueOf(Long.MAX_VALUE).shortValue(), (long)res[2].shortValue());
    }

    @Test
    public void testIntegerArrayCoercion() {
        Tuple tuple = this.of(new Object[]{new Long[]{5L, null, Long.MAX_VALUE}});
        Integer[] res = tuple.getArrayOfIntegers(0);
        Assert.assertEquals((long)3L, (long)res.length);
        Assert.assertEquals((long)5L, (long)res[0].intValue());
        Assert.assertNull((Object)res[1]);
        Assert.assertEquals((long)Long.valueOf(Long.MAX_VALUE).intValue(), (long)res[2].intValue());
    }

    @Test
    public void testLongArrayCoercion() {
        Tuple tuple = this.of(new Object[]{new Integer[]{5, null}});
        Long[] res = tuple.getArrayOfLongs(0);
        Assert.assertEquals((long)2L, (long)res.length);
        Assert.assertEquals((long)5L, (long)res[0]);
        Assert.assertNull((Object)res[1]);
    }

    @Test
    public void testFloatArrayCoercion() {
        Tuple tuple = this.of(new Object[]{new Double[]{5.0, null, Double.MAX_VALUE}});
        Float[] res = tuple.getArrayOfFloats(0);
        Assert.assertEquals((long)3L, (long)res.length);
        Assert.assertEquals((double)5.0, (double)res[0].floatValue(), (double)0.0);
        Assert.assertNull((Object)res[1]);
        Assert.assertEquals((double)Double.valueOf(Double.MAX_VALUE).floatValue(), (double)res[2].floatValue(), (double)0.0);
    }

    @Test
    public void testDoubleArrayCoercion() {
        Tuple tuple = this.of(new Object[]{new Float[]{Float.valueOf(5.0f), null, Float.valueOf(Float.MAX_VALUE)}});
        Double[] res = tuple.getArrayOfDoubles(0);
        Assert.assertEquals((long)3L, (long)res.length);
        Assert.assertEquals((double)5.0, (double)res[0], (double)0.0);
        Assert.assertNull((Object)res[1]);
        Assert.assertEquals((double)3.4028234663852886E38, (double)res[2], (double)0.0);
    }

    @Test
    public void testLocalTimeCoercion() {
        Tuple tuple = this.of(this.localDateTime);
        Assert.assertEquals((Object)this.localTime, (Object)tuple.getLocalTime(0));
        tuple = this.of(new Object[]{new LocalDateTime[]{this.localDateTime}});
        LocalTime[] array = tuple.getArrayOfLocalTimes(0);
        Assert.assertEquals((long)1L, (long)array.length);
        Assert.assertEquals((Object)this.localTime, (Object)array[0]);
    }

    @Test
    public void testLocalDateCoercion() {
        Tuple tuple = this.of(this.localDateTime);
        Assert.assertEquals((Object)this.localDate, (Object)tuple.getLocalDate(0));
        tuple = this.of(new Object[]{new LocalDateTime[]{this.localDateTime}});
        LocalDate[] array = tuple.getArrayOfLocalDates(0);
        Assert.assertEquals((long)1L, (long)array.length);
        Assert.assertEquals((Object)this.localDate, (Object)array[0]);
    }

    @Test
    public void testOffsetTimeCoercion() {
        Tuple tuple = this.of(this.offsetDateTime);
        Assert.assertEquals((Object)this.offsetTime, (Object)tuple.getOffsetTime(0));
        tuple = this.of(new Object[]{new OffsetDateTime[]{this.offsetDateTime}});
        OffsetTime[] array = tuple.getArrayOfOffsetTimes(0);
        Assert.assertEquals((long)1L, (long)array.length);
        Assert.assertEquals((Object)this.offsetTime, (Object)array[0]);
    }

    @Test
    public void testJsonObject() {
        Tuple tuple = this.of(this.jsonObject);
        Assert.assertEquals((Object)this.jsonObject, (Object)tuple.getJsonObject(0));
        tuple = this.of(new Object[]{new Object[]{this.jsonObject}});
        JsonObject[] array = tuple.getArrayOfJsonObjects(0);
        Assert.assertEquals((long)1L, (long)array.length);
        Assert.assertEquals((Object)this.jsonObject, (Object)array[0]);
    }

    @Test
    public void testJsonArray() {
        Tuple tuple = this.of(this.jsonArray);
        Assert.assertEquals((Object)this.jsonArray, (Object)tuple.getJsonArray(0));
        tuple = this.of(new Object[]{new Object[]{this.jsonArray}});
        JsonArray[] array = tuple.getArrayOfJsonArrays(0);
        Assert.assertEquals((long)1L, (long)array.length);
        Assert.assertEquals((Object)this.jsonArray, (Object)array[0]);
    }

    @Test
    public void testString() {
        String expected = "the-string";
        Tuple tuple = this.of(expected);
        Assert.assertEquals((Object)expected, (Object)tuple.getString(0));
        tuple = this.of(new Object[]{new Object[]{expected}});
        String[] array = tuple.getArrayOfStrings(0);
        Assert.assertEquals((long)1L, (long)array.length);
        Assert.assertEquals((Object)expected, (Object)array[0]);
    }

    @Test
    public void testBoolean() {
        Tuple tuple = this.of(true);
        Assert.assertEquals((Object)true, (Object)tuple.getBoolean(0));
        tuple = this.of(new Object[]{new Object[]{true, false}});
        Boolean[] array = tuple.getArrayOfBooleans(0);
        Assert.assertEquals((long)2L, (long)array.length);
        Assert.assertEquals((Object)true, (Object)array[0]);
        Assert.assertEquals((Object)false, (Object)array[1]);
    }

    @Test
    public void testWrapList() {
        ArrayList<Integer> list = new ArrayList<Integer>();
        list.add(1);
        list.add(2);
        list.add(3);
        Tuple tuple = Tuple.wrap(list);
        Assert.assertEquals((long)3L, (long)tuple.size());
    }

    @Test
    public void testFromListMutation() {
        ArrayList<Integer> list = new ArrayList<Integer>();
        list.add(1);
        list.add(2);
        list.add(3);
        Tuple tuple = Tuple.from(list);
        Assert.assertEquals((long)3L, (long)tuple.size());
        list.add(4);
        Assert.assertEquals((long)3L, (long)tuple.size());
    }

    @Test
    public void testFromArrayMutation() {
        Object[] array = new Object[]{1, 2, 3};
        Tuple tuple = Tuple.from((Object[])array);
        Assert.assertEquals((long)3L, (long)tuple.size());
        Assert.assertEquals((Object)1, (Object)tuple.getValue(0));
        Assert.assertEquals((Object)2, (Object)tuple.getValue(1));
        Assert.assertEquals((Object)3, (Object)tuple.getValue(2));
        array[0] = 10;
        Assert.assertEquals((long)3L, (long)tuple.size());
        Assert.assertEquals((Object)1, (Object)tuple.getValue(0));
        Assert.assertEquals((Object)2, (Object)tuple.getValue(1));
        Assert.assertEquals((Object)3, (Object)tuple.getValue(2));
    }

    @Test
    public void testBooleanNullValue() {
        this.testNullValue(Boolean.class, tuple -> tuple.addBoolean(null), (i, tuple) -> tuple.getBoolean(i.intValue()));
    }

    @Test
    public void testShortNullValue() {
        this.testNullValue(Short.class, tuple -> tuple.addShort(null), (i, tuple) -> tuple.getShort(i.intValue()));
    }

    @Test
    public void testIntegerNullValue() {
        this.testNullValue(Integer.class, tuple -> tuple.addInteger(null), (i, tuple) -> tuple.getInteger(i.intValue()));
    }

    @Test
    public void testLongNullValue() {
        this.testNullValue(Long.class, tuple -> tuple.addLong(null), (i, tuple) -> tuple.getLong(i.intValue()));
    }

    @Test
    public void testFloatNullValue() {
        this.testNullValue(Float.class, tuple -> tuple.addFloat(null), (i, tuple) -> tuple.getFloat(i.intValue()));
    }

    @Test
    public void testDoubleNullValue() {
        this.testNullValue(Double.class, tuple -> tuple.addDouble(null), (i, tuple) -> tuple.getDouble(i.intValue()));
    }

    @Test
    public void testStringNullValue() {
        this.testNullValue(String.class, tuple -> tuple.addString(null), (i, tuple) -> tuple.getString(i.intValue()));
    }

    @Test
    public void testJsonObjectNullValue() {
        this.testNullValue(JsonObject.class, tuple -> tuple.addJsonObject(null), (i, tuple) -> tuple.getJsonObject(i.intValue()));
    }

    @Test
    public void testJsonArrayNullValue() {
        this.testNullValue(JsonArray.class, tuple -> tuple.addJsonArray(null), (i, tuple) -> tuple.getJsonArray(i.intValue()));
    }

    @Test
    public void testTemporalNullValue() {
        this.testNullValue(Temporal.class, tuple -> tuple.addTemporal(null), (i, tuple) -> tuple.getTemporal(i.intValue()));
    }

    @Test
    public void testLocalDateNullValue() {
        this.testNullValue(LocalDate.class, tuple -> tuple.addLocalDate(null), (i, tuple) -> tuple.getLocalDate(i.intValue()));
    }

    @Test
    public void testLocalTimeNullValue() {
        this.testNullValue(LocalTime.class, tuple -> tuple.addLocalTime(null), (i, tuple) -> tuple.getLocalTime(i.intValue()));
    }

    @Test
    public void testLocalDateTimeNullValue() {
        this.testNullValue(LocalDateTime.class, tuple -> tuple.addLocalDateTime(null), (i, tuple) -> tuple.getLocalDateTime(i.intValue()));
    }

    @Test
    public void testOffsetTimeNullValue() {
        this.testNullValue(OffsetTime.class, tuple -> tuple.addOffsetTime(null), (i, tuple) -> tuple.getOffsetTime(i.intValue()));
    }

    @Test
    public void testOffsetDateTimeNullValue() {
        this.testNullValue(OffsetDateTime.class, tuple -> tuple.addOffsetDateTime(null), (i, tuple) -> tuple.getOffsetDateTime(i.intValue()));
    }

    @Test
    public void testBufferNullValue() {
        this.testNullValue(Buffer.class, tuple -> tuple.addBuffer(null), (i, tuple) -> tuple.getBuffer(i.intValue()));
    }

    @Test
    public void testUUIDNullValue() {
        this.testNullValue(UUID.class, tuple -> tuple.addUUID(null), (i, tuple) -> tuple.getUUID(i.intValue()));
    }

    @Test
    public void testBigDecimalNullValue() {
        this.testNullValue(BigDecimal.class, tuple -> tuple.addBigDecimal(null), (i, tuple) -> tuple.getBigDecimal(i.intValue()));
    }

    @Test
    public void testArrayOfBooleanNullValue() {
        this.testNullValue(Boolean[].class, tuple -> tuple.addArrayOfBoolean(null), (i, tuple) -> tuple.getArrayOfBooleans(i.intValue()));
    }

    @Test
    public void testArrayOfShortNullValue() {
        this.testNullValue(Short[].class, tuple -> tuple.addArrayOfShort(null), (i, tuple) -> tuple.getArrayOfShorts(i.intValue()));
    }

    @Test
    public void testArrayOfIntegerNullValue() {
        this.testNullValue(Integer[].class, tuple -> tuple.addArrayOfInteger(null), (i, tuple) -> tuple.getArrayOfIntegers(i.intValue()));
    }

    @Test
    public void testArrayOfLongNullValue() {
        this.testNullValue(Long[].class, tuple -> tuple.addArrayOfLong(null), (i, tuple) -> tuple.getArrayOfLongs(i.intValue()));
    }

    @Test
    public void testArrayOfFloatNullValue() {
        this.testNullValue(Float[].class, tuple -> tuple.addArrayOfFloat(null), (i, tuple) -> tuple.getArrayOfFloats(i.intValue()));
    }

    @Test
    public void testArrayOfDoubleNullValue() {
        this.testNullValue(Double[].class, tuple -> tuple.addArrayOfDouble(null), (i, tuple) -> tuple.getArrayOfDoubles(i.intValue()));
    }

    @Test
    public void testArrayOfStringNullValue() {
        this.testNullValue(String[].class, tuple -> tuple.addArrayOfString(null), (i, tuple) -> tuple.getArrayOfStrings(i.intValue()));
    }

    @Test
    public void testArrayOfJsonObjectNullValue() {
        this.testNullValue(JsonObject[].class, tuple -> tuple.addArrayOfJsonObject(null), (i, tuple) -> tuple.getArrayOfJsonObjects(i.intValue()));
    }

    @Test
    public void testArrayOfJsonArrayNullValue() {
        this.testNullValue(JsonArray[].class, tuple -> tuple.addArrayOfJsonArray(null), (i, tuple) -> tuple.getArrayOfJsonArrays(i.intValue()));
    }

    @Test
    public void testArrayOfTemporalNullValue() {
        this.testNullValue(Temporal[].class, tuple -> tuple.addArrayOfTemporal(null), (i, tuple) -> tuple.getArrayOfTemporals(i.intValue()));
    }

    @Test
    public void testArrayOfLocalDateNullValue() {
        this.testNullValue(LocalDate[].class, tuple -> tuple.addArrayOfLocalDate(null), (i, tuple) -> tuple.getArrayOfLocalDates(i.intValue()));
    }

    @Test
    public void testArrayOfLocalTimeNullValue() {
        this.testNullValue(LocalTime[].class, tuple -> tuple.addArrayOfLocalTime(null), (i, tuple) -> tuple.getArrayOfLocalTimes(i.intValue()));
    }

    @Test
    public void testArrayOfLocalDateTimeNullValue() {
        this.testNullValue(LocalDateTime[].class, tuple -> tuple.addArrayOfLocalDateTime(null), (i, tuple) -> tuple.getArrayOfLocalDateTimes(i.intValue()));
    }

    @Test
    public void testArrayOfOffsetTimeNullValue() {
        this.testNullValue(OffsetTime[].class, tuple -> tuple.addArrayOfOffsetTime(null), (i, tuple) -> tuple.getArrayOfOffsetTimes(i.intValue()));
    }

    @Test
    public void testArrayOfOffsetDateTimeNullValue() {
        this.testNullValue(OffsetDateTime[].class, tuple -> tuple.addArrayOfOffsetDateTime(null), (i, tuple) -> tuple.getArrayOfOffsetDateTimes(i.intValue()));
    }

    @Test
    public void testArrayOfBufferNullValue() {
        this.testNullValue(Buffer[].class, tuple -> tuple.addArrayOfBuffer(null), (i, tuple) -> tuple.getArrayOfBuffers(i.intValue()));
    }

    @Test
    public void testArrayOfUUIDNullValue() {
        this.testNullValue(UUID[].class, tuple -> tuple.addArrayOfUUID(null), (i, tuple) -> tuple.getArrayOfUUIDs(i.intValue()));
    }

    @Test
    public void testArrayOfBigDecimalNullValue() {
        this.testNullValue(BigDecimal[].class, tuple -> tuple.addArrayOfBigDecimal(null), (i, tuple) -> tuple.getArrayOfBigDecimals(i.intValue()));
    }

    @Test
    public void testArbitraryClassNullValue() {
        this.testNullValue(LinkedHashSet.class, tuple -> tuple.addValue((Object)NullValue.of(LinkedHashSet.class)), (i, tuple) -> tuple.getValue(i.intValue()));
    }

    private void testNullValue(Class<?> c, Consumer<Tuple> addValue, BiFunction<Integer, Tuple, ?> getValue) {
        Tuple tuple = this.tuple();
        addValue.accept(tuple);
        Assert.assertNull((Object)tuple.getValue(0));
        Assert.assertNull(getValue.apply(0, tuple));
        Assert.assertNull((Object)tuple.get(c, 0));
        Assert.assertSame(c, tuple.types().get(0));
    }

    static enum TupleKind {
        ELEMENTS{

            @Override
            Tuple tuple() {
                return Tuple.tuple();
            }

            @Override
            Tuple of(Object ... elements) {
                if (elements.length == 0) {
                    throw new IllegalArgumentException();
                }
                return Tuple.of((Object)elements[0], (Object[])Arrays.copyOfRange(elements, 1, elements.length));
            }
        }
        ,
        LIST{

            @Override
            Tuple tuple() {
                return Tuple.tuple();
            }

            @Override
            Tuple of(Object ... elements) {
                if (elements.length == 0) {
                    throw new IllegalArgumentException();
                }
                return Tuple.tuple(Arrays.asList(elements));
            }
        }
        ,
        WRAP_LIST{

            @Override
            Tuple tuple() {
                return Tuple.wrap(new ArrayList());
            }

            @Override
            Tuple of(Object ... elements) {
                if (elements.length == 0) {
                    throw new IllegalArgumentException();
                }
                return Tuple.wrap(new ArrayList<Object>(Arrays.asList(elements)));
            }
        }
        ,
        WRAP_ARRAY{

            @Override
            Tuple tuple() {
                return Tuple.wrap(new ArrayList());
            }

            @Override
            Tuple of(Object ... elements) {
                return Tuple.wrap((Object[])elements);
            }
        }
        ,
        FROM_LIST{

            @Override
            Tuple tuple() {
                return Tuple.from(new ArrayList());
            }

            @Override
            Tuple of(Object ... elements) {
                if (elements.length == 0) {
                    throw new IllegalArgumentException();
                }
                return Tuple.from(new ArrayList<Object>(Arrays.asList(elements)));
            }
        }
        ,
        FROM_ARRAY{

            @Override
            Tuple tuple() {
                return Tuple.from((Object[])new Object[0]);
            }

            @Override
            Tuple of(Object ... elements) {
                return Tuple.from((Object[])elements);
            }
        };


        abstract Tuple tuple();

        abstract Tuple of(Object ... var1);
    }
}

