/*
 * Decompiled with CFR 0.152.
 */
package io.vertx.sqlclient.tck;

import io.vertx.core.Vertx;
import io.vertx.ext.unit.TestContext;
import io.vertx.sqlclient.Pool;
import io.vertx.sqlclient.PoolOptions;
import io.vertx.sqlclient.SqlConnectOptions;
import io.vertx.sqlclient.spi.Driver;
import java.util.ArrayList;
import java.util.Collections;
import java.util.ServiceConfigurationError;
import java.util.ServiceLoader;
import org.junit.Assert;
import org.junit.Test;

public abstract class DriverTestBase {
    protected abstract SqlConnectOptions defaultOptions();

    @Test
    public void testServiceLoader(TestContext ctx) {
        ArrayList<Driver> drivers = new ArrayList<Driver>();
        for (Driver d : ServiceLoader.load(Driver.class)) {
            drivers.add(d);
        }
        Assert.assertEquals((String)("Expected to find exactly 1 Driver but found: " + drivers), (long)1L, (long)drivers.size());
    }

    @Test
    public void testAcceptsOptions(TestContext ctx) {
        Assert.assertTrue((boolean)this.getDriver().acceptsOptions(this.defaultOptions()));
    }

    @Test
    public void testAcceptsGenericOptions(TestContext ctx) {
        Assert.assertTrue((boolean)this.getDriver().acceptsOptions(new SqlConnectOptions()));
    }

    @Test
    public void testRejectsOtherOptions(TestContext ctx) {
        Assert.assertFalse((boolean)this.getDriver().acceptsOptions((SqlConnectOptions)new BogusOptions()));
    }

    @Test
    public void testCreatePoolFromDriver01(TestContext ctx) {
        Pool p = this.getDriver().createPool(null, Collections.singletonList(this.defaultOptions()), new PoolOptions());
        p.getConnection(ctx.asyncAssertSuccess(ar -> ar.close()));
    }

    @Test
    public void testCreatePoolFromDriver02(TestContext ctx) {
        Pool p = this.getDriver().createPool(null, Collections.singletonList(new SqlConnectOptions(this.defaultOptions())), new PoolOptions());
        p.getConnection(ctx.asyncAssertSuccess(ar -> ar.close()));
    }

    @Test
    public void testCreatePoolFromDriver03(TestContext ctx) {
        Pool p = this.getDriver().createPool(null, Collections.singletonList(this.defaultOptions()), new PoolOptions().setMaxSize(1));
        p.getConnection(ctx.asyncAssertSuccess(ar -> ar.close()));
    }

    @Test
    public void testCreatePoolFromDriver04(TestContext ctx) {
        Pool p = this.getDriver().createPool(Vertx.vertx(), Collections.singletonList(this.defaultOptions()), new PoolOptions().setMaxSize(1));
        p.getConnection(ctx.asyncAssertSuccess(ar -> ar.close()));
    }

    @Test
    public void testCreatePool01(TestContext ctx) {
        Pool.pool((SqlConnectOptions)this.defaultOptions()).getConnection(ctx.asyncAssertSuccess(ar -> ar.close()));
    }

    @Test
    public void testCreatePool02(TestContext ctx) {
        Pool.pool((SqlConnectOptions)new SqlConnectOptions(this.defaultOptions()), (PoolOptions)new PoolOptions()).getConnection(ctx.asyncAssertSuccess(ar -> ar.close()));
    }

    @Test
    public void testCreatePool03(TestContext ctx) {
        Pool.pool((SqlConnectOptions)this.defaultOptions(), (PoolOptions)new PoolOptions().setMaxSize(1)).getConnection(ctx.asyncAssertSuccess(ar -> ar.close()));
    }

    @Test
    public void testCreatePool04(TestContext ctx) {
        Pool.pool((Vertx)Vertx.vertx(), (SqlConnectOptions)this.defaultOptions(), (PoolOptions)new PoolOptions()).getConnection(ctx.asyncAssertSuccess(ar -> ar.close()));
    }

    @Test
    public void testCreatePool05(TestContext ctx) {
        SqlConnectOptions defaults = this.defaultOptions();
        SqlConnectOptions opts = new SqlConnectOptions().setHost(defaults.getHost()).setPort(defaults.getPort()).setDatabase(defaults.getDatabase()).setUser(defaults.getUser()).setPassword(defaults.getPassword());
        Pool.pool((SqlConnectOptions)opts).getConnection(ctx.asyncAssertSuccess(ar -> ar.close()));
    }

    @Test(expected=ServiceConfigurationError.class)
    public void testRejectCreatePool01(TestContext ctx) {
        Pool.pool((SqlConnectOptions)new BogusOptions());
    }

    @Test(expected=ServiceConfigurationError.class)
    public void testRejectCreatePool02(TestContext ctx) {
        Pool.pool((SqlConnectOptions)new BogusOptions(), (PoolOptions)new PoolOptions());
    }

    @Test(expected=ServiceConfigurationError.class)
    public void testRejectCreatePool03(TestContext ctx) {
        Pool.pool((Vertx)Vertx.vertx(), (SqlConnectOptions)new BogusOptions(), (PoolOptions)new PoolOptions());
    }

    private Driver getDriver() {
        return ServiceLoader.load(Driver.class).iterator().next();
    }

    public static class BogusOptions
    extends SqlConnectOptions {
    }
}

