/*
 * Decompiled with CFR 0.152.
 */
package io.vertx.sqlclient.tck;

import io.vertx.core.Future;
import io.vertx.core.Vertx;
import io.vertx.core.VertxOptions;
import io.vertx.core.metrics.MetricsOptions;
import io.vertx.core.net.SocketAddress;
import io.vertx.core.spi.metrics.ClientMetrics;
import io.vertx.core.spi.metrics.VertxMetrics;
import io.vertx.ext.unit.Async;
import io.vertx.ext.unit.TestContext;
import io.vertx.ext.unit.junit.VertxUnitRunner;
import io.vertx.sqlclient.Pool;
import io.vertx.sqlclient.SqlConnection;
import io.vertx.sqlclient.Tuple;
import java.util.Collections;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.atomic.AtomicReference;
import java.util.function.Function;
import org.junit.After;
import org.junit.Before;
import org.junit.Test;
import org.junit.runner.RunWith;

@RunWith(value=VertxUnitRunner.class)
public abstract class MetricsTestBase {
    Vertx vertx;
    ClientMetrics metrics;
    Pool pool;

    @Before
    public void setup() {
        this.vertx = Vertx.vertx((VertxOptions)new VertxOptions().setMetricsOptions(new MetricsOptions().setEnabled(true).setFactory(tracingOptions -> new VertxMetrics(){

            public ClientMetrics<?, ?, ?, ?> createClientMetrics(SocketAddress remoteAddress, String type, String namespace) {
                return MetricsTestBase.this.metrics;
            }
        })));
    }

    @After
    public void teardown(TestContext ctx) {
        this.vertx.close(ctx.asyncAssertSuccess());
    }

    protected Pool getPool() {
        if (this.pool == null) {
            this.pool = this.createPool(this.vertx);
        }
        return this.pool;
    }

    protected abstract Pool createPool(Vertx var1);

    protected abstract String statement(String ... var1);

    @Test
    public void testClosePool(TestContext ctx) {
        final AtomicInteger closeCount = new AtomicInteger();
        this.metrics = new ClientMetrics(){

            public void close() {
                closeCount.incrementAndGet();
            }
        };
        Pool pool = this.createPool(this.vertx);
        ctx.assertEquals((Object)0, (Object)closeCount.get());
        pool.close(ctx.asyncAssertSuccess(v -> ctx.assertEquals((Object)1, (Object)closeCount.get())));
    }

    @Test
    public void testSimpleQuery(TestContext ctx) {
        Function<SqlConnection, Future<?>> fn = conn -> conn.query("SELECT * FROM immutable WHERE id=1").execute();
        this.testMetrics(ctx, false, fn);
    }

    @Test
    public void testPreparedQuery(TestContext ctx) {
        Function<SqlConnection, Future<?>> fn = conn -> conn.preparedQuery("SELECT * FROM immutable WHERE id=1").execute();
        this.testMetrics(ctx, false, fn);
    }

    @Test
    public void testPreparedBatchQuery(TestContext ctx) {
        Function<SqlConnection, Future<?>> fn = conn -> conn.preparedQuery("SELECT * FROM immutable WHERE id=1").executeBatch(Collections.singletonList(Tuple.tuple()));
        this.testMetrics(ctx, false, fn);
    }

    @Test
    public void testPrepareAndQuery(TestContext ctx) {
        Function<SqlConnection, Future<?>> fn = conn -> conn.prepare("SELECT * FROM immutable WHERE id=1").compose(ps -> ps.query().execute());
        this.testMetrics(ctx, false, fn);
    }

    @Test
    public void testPrepareAndBatchQuery(TestContext ctx) {
        Function<SqlConnection, Future<?>> fn = conn -> conn.prepare("SELECT * FROM immutable WHERE id=1").compose(ps -> ps.query().executeBatch(Collections.singletonList(Tuple.tuple())));
        this.testMetrics(ctx, false, fn);
    }

    @Test
    public void testFailure(TestContext ctx) {
        Function<SqlConnection, Future<?>> fn = conn -> conn.query("SELECT * FROM undefined_table WHERE id = 1").execute();
        this.testMetrics(ctx, true, fn);
    }

    private void testMetrics(final TestContext ctx, boolean fail, Function<SqlConnection, Future<?>> fn) {
        final Object metric = new Object();
        final Object queueMetric = new Object();
        final AtomicReference responseMetric = new AtomicReference();
        final AtomicReference failureMetric = new AtomicReference();
        final AtomicInteger enqueueCount = new AtomicInteger();
        final AtomicInteger dequeueCount = new AtomicInteger();
        this.metrics = new ClientMetrics(){

            public Object enqueueRequest() {
                enqueueCount.incrementAndGet();
                return queueMetric;
            }

            public void dequeueRequest(Object taskMetric) {
                dequeueCount.incrementAndGet();
            }

            public Object requestBegin(String uri, Object request) {
                return metric;
            }

            public void requestEnd(Object requestMetric) {
                ctx.assertEquals(metric, requestMetric);
            }

            public void responseEnd(Object requestMetric) {
                responseMetric.set(requestMetric);
            }

            public void requestReset(Object requestMetric) {
                failureMetric.set(requestMetric);
            }
        };
        Pool pool = this.getPool();
        Async async = ctx.async();
        this.vertx.runOnContext(v1 -> pool.getConnection(ctx.asyncAssertSuccess(conn -> ((Future)fn.apply((SqlConnection)conn)).onComplete(ar -> {
            ctx.assertEquals((Object)(!fail ? 1 : 0), (Object)ar.succeeded());
            conn.close(ctx.asyncAssertSuccess(v3 -> this.vertx.runOnContext(v4 -> {
                if (fail) {
                    ctx.assertNull(responseMetric.get());
                    ctx.assertEquals(metric, failureMetric.get());
                } else {
                    ctx.assertEquals(metric, responseMetric.get());
                    ctx.assertNull(failureMetric.get());
                }
                ctx.assertEquals((Object)1, (Object)enqueueCount.get());
                ctx.assertEquals((Object)1, (Object)dequeueCount.get());
                async.complete();
            })));
        }))));
    }
}

