/*
 * Decompiled with CFR 0.152.
 */
package io.vertx.sqlclient.tck;

import io.vertx.core.AsyncResult;
import io.vertx.core.Handler;
import io.vertx.core.Vertx;
import io.vertx.ext.unit.TestContext;
import io.vertx.sqlclient.Row;
import io.vertx.sqlclient.SqlConnection;
import io.vertx.sqlclient.Tuple;
import io.vertx.sqlclient.tck.Connector;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import org.junit.After;
import org.junit.Before;
import org.junit.Test;

public abstract class PreparedBatchTestBase {
    protected Vertx vertx;
    protected Connector<SqlConnection> connector;

    protected void connect(Handler<AsyncResult<SqlConnection>> handler) {
        this.connector.connect(handler);
    }

    protected abstract String statement(String ... var1);

    protected abstract void initConnector();

    @Before
    public void setUp(TestContext ctx) throws Exception {
        this.vertx = Vertx.vertx();
        this.initConnector();
        this.cleanTestTable(ctx);
    }

    @After
    public void tearDown(TestContext ctx) {
        this.connector.close();
        this.vertx.close(ctx.asyncAssertSuccess());
    }

    @Test
    public void testInsert(TestContext ctx) {
        this.connector.connect((Handler<AsyncResult<SqlConnection>>)ctx.asyncAssertSuccess(conn -> {
            ArrayList<Tuple> batch = new ArrayList<Tuple>();
            batch.add(Tuple.of((Object)79991, (Object)"batch one"));
            batch.add(Tuple.of((Object)79992, (Object)"batch two"));
            batch.add(Tuple.wrap(Arrays.asList(79993, "batch three")));
            batch.add(Tuple.wrap(Arrays.asList(79994, "batch four")));
            conn.preparedQuery(this.statement("INSERT INTO mutable (id, val) VALUES (", ", ", ")")).executeBatch(batch, ctx.asyncAssertSuccess(result -> {
                ctx.assertEquals((Object)1, (Object)result.rowCount());
                conn.preparedQuery(this.statement("SELECT * FROM mutable WHERE id=", "")).executeBatch(Collections.singletonList(Tuple.of((Object)79991)), ctx.asyncAssertSuccess(ar1 -> {
                    ctx.assertEquals((Object)1, (Object)ar1.size());
                    Row one = (Row)ar1.iterator().next();
                    ctx.assertEquals((Object)79991, (Object)one.getInteger("id"));
                    ctx.assertEquals((Object)"batch one", (Object)one.getString("val"));
                    conn.preparedQuery(this.statement("SELECT * FROM mutable WHERE id=", "")).executeBatch(Collections.singletonList(Tuple.of((Object)79992)), ctx.asyncAssertSuccess(ar2 -> {
                        ctx.assertEquals((Object)1, (Object)ar2.size());
                        Row two = (Row)ar2.iterator().next();
                        ctx.assertEquals((Object)79992, (Object)two.getInteger("id"));
                        ctx.assertEquals((Object)"batch two", (Object)two.getString("val"));
                        conn.preparedQuery(this.statement("SELECT * FROM mutable WHERE id=", "")).executeBatch(Collections.singletonList(Tuple.of((Object)79993)), ctx.asyncAssertSuccess(ar3 -> {
                            ctx.assertEquals((Object)1, (Object)ar3.size());
                            Row three = (Row)ar3.iterator().next();
                            ctx.assertEquals((Object)79993, (Object)three.getInteger("id"));
                            ctx.assertEquals((Object)"batch three", (Object)three.getString("val"));
                            conn.preparedQuery(this.statement("SELECT * FROM mutable WHERE id=", "")).executeBatch(Collections.singletonList(Tuple.of((Object)79994)), ctx.asyncAssertSuccess(ar4 -> {
                                ctx.assertEquals((Object)1, (Object)ar4.size());
                                Row four = (Row)ar4.iterator().next();
                                ctx.assertEquals((Object)79994, (Object)four.getInteger("id"));
                                ctx.assertEquals((Object)"batch four", (Object)four.getString("val"));
                            }));
                        }));
                    }));
                }));
            }));
        }));
    }

    @Test
    public void testBatchQuery(TestContext ctx) {
        this.connector.connect((Handler<AsyncResult<SqlConnection>>)ctx.asyncAssertSuccess(conn -> {
            ArrayList<Tuple> batch = new ArrayList<Tuple>();
            batch.add(Tuple.of((Object)1));
            batch.add(Tuple.of((Object)3));
            batch.add(Tuple.of((Object)5));
            conn.preparedQuery(this.statement("SELECT * FROM immutable WHERE id=", "")).executeBatch(batch, ctx.asyncAssertSuccess(result -> {
                ctx.assertEquals((Object)1, (Object)result.size());
                Row row = (Row)result.iterator().next();
                ctx.assertEquals((Object)1, (Object)row.getInteger(0));
                ctx.assertEquals((Object)"fortune: No such file or directory", (Object)row.getString(1));
                result = result.next();
                ctx.assertEquals((Object)1, (Object)result.size());
                row = (Row)result.iterator().next();
                ctx.assertEquals((Object)3, (Object)row.getInteger(0));
                ctx.assertEquals((Object)"After enough decimal places, nobody gives a damn.", (Object)row.getString(1));
                result = result.next();
                ctx.assertEquals((Object)1, (Object)result.size());
                row = (Row)result.iterator().next();
                ctx.assertEquals((Object)5, (Object)row.getInteger(0));
                ctx.assertEquals((Object)"A computer program does what you tell it to do, not what you want it to do.", (Object)row.getString(1));
            }));
        }));
    }

    @Test
    public void testEmptyBatch(TestContext ctx) {
        this.connector.connect((Handler<AsyncResult<SqlConnection>>)ctx.asyncAssertSuccess(conn -> {
            ArrayList batch = new ArrayList();
            conn.preparedQuery(this.statement("SELECT * FROM immutable WHERE id=", "")).executeBatch(batch, ctx.asyncAssertFailure(err -> {}));
        }));
    }

    @Test
    public void testIncorrectNumBatchArguments(TestContext ctx) {
        this.connector.connect((Handler<AsyncResult<SqlConnection>>)ctx.asyncAssertSuccess(conn -> {
            ArrayList<Tuple> batch = new ArrayList<Tuple>();
            batch.add(Tuple.of((Object)1, (Object)2));
            conn.preparedQuery(this.statement("SELECT * FROM immutable WHERE id=", "")).executeBatch(batch, ctx.asyncAssertFailure(err -> {}));
        }));
    }

    protected void cleanTestTable(TestContext ctx) {
        this.connect((Handler<AsyncResult<SqlConnection>>)ctx.asyncAssertSuccess(conn -> conn.preparedQuery("TRUNCATE TABLE mutable;").execute(ctx.asyncAssertSuccess(result -> conn.close()))));
    }
}

