/*
 * Decompiled with CFR 0.152.
 */
package io.vertx.sqlclient;

import io.vertx.core.json.JsonObject;
import io.vertx.core.json.impl.JsonUtil;
import io.vertx.sqlclient.PoolOptions;
import java.util.Base64;
import java.util.Map;
import java.util.concurrent.TimeUnit;

public class PoolOptionsConverter {
    private static final Base64.Decoder BASE64_DECODER = JsonUtil.BASE64_DECODER;
    private static final Base64.Encoder BASE64_ENCODER = JsonUtil.BASE64_ENCODER;

    public static void fromJson(Iterable<Map.Entry<String, Object>> json, PoolOptions obj) {
        for (Map.Entry<String, Object> member : json) {
            switch (member.getKey()) {
                case "connectionTimeout": {
                    if (!(member.getValue() instanceof Number)) break;
                    obj.setConnectionTimeout(((Number)member.getValue()).intValue());
                    break;
                }
                case "connectionTimeoutUnit": {
                    if (!(member.getValue() instanceof String)) break;
                    obj.setConnectionTimeoutUnit(TimeUnit.valueOf((String)member.getValue()));
                    break;
                }
                case "idleTimeout": {
                    if (!(member.getValue() instanceof Number)) break;
                    obj.setIdleTimeout(((Number)member.getValue()).intValue());
                    break;
                }
                case "idleTimeoutUnit": {
                    if (!(member.getValue() instanceof String)) break;
                    obj.setIdleTimeoutUnit(TimeUnit.valueOf((String)member.getValue()));
                    break;
                }
                case "maxSize": {
                    if (!(member.getValue() instanceof Number)) break;
                    obj.setMaxSize(((Number)member.getValue()).intValue());
                    break;
                }
                case "maxWaitQueueSize": {
                    if (!(member.getValue() instanceof Number)) break;
                    obj.setMaxWaitQueueSize(((Number)member.getValue()).intValue());
                    break;
                }
                case "poolCleanerPeriod": {
                    if (!(member.getValue() instanceof Number)) break;
                    obj.setPoolCleanerPeriod(((Number)member.getValue()).intValue());
                }
            }
        }
    }

    public static void toJson(PoolOptions obj, JsonObject json) {
        PoolOptionsConverter.toJson(obj, json.getMap());
    }

    public static void toJson(PoolOptions obj, Map<String, Object> json) {
        json.put("connectionTimeout", obj.getConnectionTimeout());
        if (obj.getConnectionTimeoutUnit() != null) {
            json.put("connectionTimeoutUnit", obj.getConnectionTimeoutUnit().name());
        }
        json.put("idleTimeout", obj.getIdleTimeout());
        if (obj.getIdleTimeoutUnit() != null) {
            json.put("idleTimeoutUnit", obj.getIdleTimeoutUnit().name());
        }
        json.put("maxSize", obj.getMaxSize());
        json.put("maxWaitQueueSize", obj.getMaxWaitQueueSize());
        json.put("poolCleanerPeriod", obj.getPoolCleanerPeriod());
    }
}

